"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var uuid_1 = require("uuid");
exports.ColorVariant = Object.freeze({
    Series: '__use__series__color__',
    None: '__use__empty__color__',
});
exports.Position = Object.freeze({
    Top: 'top',
    Bottom: 'bottom',
    Left: 'left',
    Right: 'right',
});
function identity(value) {
    return value;
}
exports.identity = identity;
function compareByValueAsc(a, b) {
    return a > b ? 1 : -1;
}
exports.compareByValueAsc = compareByValueAsc;
function minValueWithLowerLimit(val1, val2, lowerLimit) {
    return Math.max(Math.min(val1, val2), lowerLimit);
}
exports.minValueWithLowerLimit = minValueWithLowerLimit;
function maxValueWithUpperLimit(val1, val2, upperLimit) {
    return Math.min(Math.max(val1, val2), upperLimit);
}
exports.maxValueWithUpperLimit = maxValueWithUpperLimit;
function getColorFromVariant(seriesColor, color) {
    if (color === exports.ColorVariant.Series) {
        return seriesColor;
    }
    if (color === exports.ColorVariant.None) {
        return 'transparent';
    }
    return color || seriesColor;
}
exports.getColorFromVariant = getColorFromVariant;
function htmlIdGenerator(idPrefix) {
    var prefix = idPrefix || "i" + uuid_1.v1();
    return function (suffix) { return prefix + "_" + (suffix || uuid_1.v1()); };
}
exports.htmlIdGenerator = htmlIdGenerator;
function getPartialValue(base, partial, partials) {
    if (partials === void 0) { partials = []; }
    var partialWithValue = partial !== undefined ? partial : partials.find(function (v) { return v !== undefined; });
    return partialWithValue !== undefined ? partialWithValue : base;
}
exports.getPartialValue = getPartialValue;
function getAllKeys(object, objects) {
    if (objects === void 0) { objects = []; }
    var initalKeys = object instanceof Map ? __spread(object.keys()) : Object.keys(object);
    return objects.reduce(function (keys, obj) {
        if (obj && typeof obj === 'object') {
            var newKeys = obj instanceof Map ? obj.keys() : Object.keys(obj);
            keys.push.apply(keys, __spread(newKeys));
        }
        return keys;
    }, initalKeys);
}
exports.getAllKeys = getAllKeys;
function isArrayOrSet(value) {
    return Array.isArray(value) || value instanceof Set;
}
exports.isArrayOrSet = isArrayOrSet;
function hasPartialObjectToMerge(base, partial, additionalPartials) {
    if (additionalPartials === void 0) { additionalPartials = []; }
    if (isArrayOrSet(base)) {
        return false;
    }
    if (typeof base === 'object' && base !== null) {
        if (typeof partial === 'object' && !isArrayOrSet(partial) && partial !== null) {
            return true;
        }
        return additionalPartials.some(function (p) { return typeof p === 'object' && !Array.isArray(p); });
    }
    return false;
}
exports.hasPartialObjectToMerge = hasPartialObjectToMerge;
function shallowClone(value) {
    if (Array.isArray(value)) {
        return __spread(value);
    }
    if (value instanceof Set) {
        return new Set(__spread(value));
    }
    if (typeof value === 'object' && value !== null) {
        if (value instanceof Map) {
            return new Map(value.entries());
        }
        return __assign({}, value);
    }
    return value;
}
exports.shallowClone = shallowClone;
function mergePartial(base, partial, options, additionalPartials) {
    if (options === void 0) { options = {}; }
    if (additionalPartials === void 0) { additionalPartials = []; }
    var baseClone = shallowClone(base);
    if (hasPartialObjectToMerge(base, partial, additionalPartials)) {
        var mapCondition = !(baseClone instanceof Map) || options.mergeMaps;
        if (partial !== undefined && options.mergeOptionalPartialValues && mapCondition) {
            getAllKeys(partial, additionalPartials).forEach(function (key) {
                if (baseClone instanceof Map) {
                    if (!baseClone.has(key)) {
                        baseClone.set(key, partial.get(key) !== undefined
                            ? partial.get(key)
                            : additionalPartials.find(function (v) { return v.get(key) !== undefined; }) || new Map().get(key));
                    }
                }
                else if (!(key in baseClone)) {
                    baseClone[key] = partial[key] !== undefined
                        ? partial[key]
                        : (additionalPartials.find(function (v) { return v[key] !== undefined; }) || {})[key];
                }
            });
        }
        if (baseClone instanceof Map) {
            if (options.mergeMaps) {
                return __spread(baseClone.keys()).reduce(function (newBase, key) {
                    var partialValue = partial && partial.get(key);
                    var partialValues = additionalPartials.map(function (v) {
                        return typeof v === 'object' && v instanceof Map ? v.get(key) : undefined;
                    });
                    var baseValue = base.get(key);
                    newBase.set(key, mergePartial(baseValue, partialValue, options, partialValues));
                    return newBase;
                }, baseClone);
            }
            if (partial !== undefined) {
                return partial;
            }
            var additional = additionalPartials.find(function (p) { return p !== undefined; });
            if (additional) {
                return additional;
            }
            return baseClone;
        }
        return Object.keys(base).reduce(function (newBase, key) {
            var partialValue = partial && partial[key];
            var partialValues = additionalPartials.map(function (v) { return (typeof v === 'object' ? v[key] : undefined); });
            var baseValue = base[key];
            newBase[key] = mergePartial(baseValue, partialValue, options, partialValues);
            return newBase;
        }, baseClone);
    }
    return getPartialValue(baseClone, partial, additionalPartials);
}
exports.mergePartial = mergePartial;
function getUniqueValues(fullArray, uniqueProperty, filterConsecutives) {
    if (filterConsecutives === void 0) { filterConsecutives = false; }
    return fullArray.reduce(function (acc, currentValue) {
        var uniqueValue = currentValue[uniqueProperty];
        if (acc.uniqueValues.has(uniqueValue)) {
            return acc;
        }
        if (filterConsecutives) {
            acc.uniqueValues.clear();
            acc.uniqueValues.add(uniqueValue);
        }
        else {
            acc.uniqueValues.add(uniqueValue);
        }
        acc.filtered.push(currentValue);
        return acc;
    }, {
        filtered: [],
        uniqueValues: new Set(),
    }).filtered;
}
exports.getUniqueValues = getUniqueValues;
function getDistance(a, b) {
    return Math.sqrt(Math.pow(b.x - a.x, 2) + Math.pow(b.y - a.y, 2));
}
exports.getDistance = getDistance;
function stringifyNullsUndefined(value) {
    if (value === undefined) {
        return 'undefined';
    }
    if (value === null) {
        return 'null';
    }
    return value;
}
exports.stringifyNullsUndefined = stringifyNullsUndefined;
function isUniqueArray(arr, extractor) {
    var values = new Set();
    return (function isUniqueArrayFn() {
        return arr.every(function (v) {
            var value = extractor ? extractor(v) : v;
            if (values.has(value)) {
                return false;
            }
            values.add(value);
            return true;
        });
    }());
}
exports.isUniqueArray = isUniqueArray;
function isDefined(value) {
    return value !== null && value !== undefined;
}
exports.isDefined = isDefined;
exports.isDefinedFrom = function (typeCheck) { return function (value) {
    if (value === undefined) {
        return false;
    }
    try {
        return typeCheck(value);
    }
    catch (_a) {
        return false;
    }
}; };
exports.round = function (value, fractionDigits) {
    if (fractionDigits === void 0) { fractionDigits = 0; }
    var precision = Math.pow(10, Math.max(fractionDigits, 0));
    var scaledValue = Math.floor(value * precision);
    return scaledValue / precision;
};
//# sourceMappingURL=commons.js.map