function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { htmlIdGenerator } from '../../../services';
import { EuiAccordion } from '../../accordion';
import { EuiIcon } from '../../icon';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiTitle } from '../../title';
var backgroundToClassNameMap = {
  none: '',
  light: 'euiCollapsibleNavGroup--light',
  dark: 'euiCollapsibleNavGroup--dark'
};
export var BACKGROUNDS = Object.keys(backgroundToClassNameMap);
export var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
      children = _ref.children,
      id = _ref.id,
      title = _ref.title,
      iconType = _ref.iconType,
      _ref$iconSize = _ref.iconSize,
      iconSize = _ref$iconSize === void 0 ? 'l' : _ref$iconSize,
      _ref$background = _ref.background,
      background = _ref$background === void 0 ? 'none' : _ref$background,
      _ref$isCollapsible = _ref.isCollapsible,
      isCollapsible = _ref$isCollapsible === void 0 ? false : _ref$isCollapsible,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'h3' : _ref$titleElement,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xxs' : _ref$titleSize,
      iconProps = _ref.iconProps,
      rest = _objectWithoutProperties(_ref, ["className", "children", "id", "title", "iconType", "iconSize", "background", "isCollapsible", "titleElement", "titleSize", "iconProps"]);

  var _useState = useState(id || htmlIdGenerator()()),
      _useState2 = _slicedToArray(_useState, 1),
      groupID = _useState2[0];

  var titleID = "".concat(groupID, "__title");
  var classes = classNames('euiCollapsibleNavGroup', backgroundToClassNameMap[background], {
    'euiCollapsibleNavGroup--withHeading': title
  }, className); // Warn if consumer passes an iconType without a title

  if (iconType && !title) {
    console.warn('EuiCollapsibleNavGroup will not render an icon without `title`.');
  }

  var content = React.createElement("div", {
    className: "euiCollapsibleNavGroup__children"
  }, children);
  var headingClasses = 'euiCollapsibleNavGroup__heading';
  var TitleElement = titleElement;
  var titleContent = title ? React.createElement(EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, iconType && React.createElement(EuiFlexItem, {
    grow: false
  }, React.createElement(EuiIcon, _extends({}, iconProps, {
    type: iconType,
    size: iconSize
  }))), React.createElement(EuiFlexItem, null, React.createElement(EuiTitle, {
    size: titleSize
  }, React.createElement(TitleElement, {
    id: titleID,
    className: "euiCollapsibleNavGroup__title"
  }, title)))) : undefined;

  if (isCollapsible && title) {
    return React.createElement(EuiAccordion, _extends({
      id: groupID,
      className: classes,
      buttonClassName: headingClasses,
      buttonContent: titleContent,
      initialIsOpen: true,
      arrowDisplay: "right"
    }, rest), content);
  } else {
    return React.createElement("div", _extends({
      id: groupID,
      className: classes
    }, rest), titleContent && React.createElement("div", {
      className: headingClasses
    }, titleContent), content);
  }
};
EuiCollapsibleNavGroup.propTypes = {
  children: PropTypes.node,

  /**
     * Sits left of the `title` and only when `title` is present
     */
  iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),

  /**
     * Change the size of the icon in the `title`
     */
  iconSize: PropTypes.oneOf(["original", "s", "m", "l", "xl", "xxl"]),

  /**
     * Further extend the props applied to EuiIcon
     */
  iconProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
         * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
         * Note that coloring only works if your SVG is removed of fill attributes.
         */
    color: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost"]).isRequired]),

    /**
         * Descriptive title for naming the icon based on its use
         */
    title: PropTypes.string,

    /**
         * A unique identifier for the title element
         */
    titleId: PropTypes.string,

    /**
         * Its value should be one or more element IDs
         */
    "aria-labelledby": PropTypes.string,

    /**
         * Callback when the icon has been loaded & rendered
         */
    onIconLoad: PropTypes.func
  }),

  /**
     * Optionally provide an id, otherwise one will be created
     */

  /**
     * Optionally provide an id, otherwise one will be created
     */
  id: PropTypes.string,

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */
  background: PropTypes.oneOf(["none", "light", "dark"]),

  /**
     * Determines the title's heading element
     */

  /**
     * Determines the title's heading element
     */
  titleElement: PropTypes.oneOf(["h2", "h3", "h4", "h5", "h6", "span"]),

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */
  titleSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: PropTypes.string,

  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: PropTypes.string,

  /**
       * The content of the clickable trigger
       */
  buttonContent: PropTypes.node,

  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: PropTypes.node,

  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: PropTypes.bool,

  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: PropTypes.func,

  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: PropTypes.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       * Placing on the `right` doesn't work with `extraAction` and so it will be ignored
       */
  arrowDisplay: PropTypes.oneOf(["left", "right", "none"]),

  /**
       * Control the opening of accordin via prop
       */
  forceState: PropTypes.oneOf(["closed", "open"]),

  /**
     * If `true`, wraps children in the body of an accordion,
     * requiring the prop `title` to be used as the button.
     * When `false`, simply renders a div without any accordion functionality.
     */

  /**
       * If `true`, wraps children in the body of an accordion,
       * requiring the prop `title` to be used as the button.
       * When `false`, simply renders a div without any accordion functionality.
       */
  isCollapsible: PropTypes.oneOfType([PropTypes.oneOf([true]).isRequired, PropTypes.oneOf([false])]),

  /**
     * The title gets wrapped in the appropriate heading level
     * with the option to add an iconType
     */

  /**
       * The title gets wrapped in the appropriate heading level
       * with the option to add an iconType
       */
  title: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.node])
};
EuiCollapsibleNavGroup.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCollapsibleNavGroup",
  "props": {
    "iconSize": {
      "defaultValue": {
        "value": "'l'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"original\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }, {
          "value": "\"xl\"",
          "computed": false
        }, {
          "value": "\"xxl\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Change the size of the icon in the `title`"
    },
    "background": {
      "defaultValue": {
        "value": "'none'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"light\"",
          "computed": false
        }, {
          "value": "\"dark\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Adds a background color to the entire group,\napplying the correct text color to the `title` only"
    },
    "isCollapsible": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "true",
            "computed": false
          }]
        }, {
          "name": "enum",
          "value": [{
            "value": "false",
            "computed": false
          }]
        }]
      },
      "required": false,
      "description": "If `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality."
    },
    "titleElement": {
      "defaultValue": {
        "value": "'h3'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"h2\"",
          "computed": false
        }, {
          "value": "\"h3\"",
          "computed": false
        }, {
          "value": "\"h4\"",
          "computed": false
        }, {
          "value": "\"h5\"",
          "computed": false
        }, {
          "value": "\"h6\"",
          "computed": false
        }, {
          "value": "\"span\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Determines the title's heading element"
    },
    "titleSize": {
      "defaultValue": {
        "value": "'xxs'",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Title sizing equivelant to EuiTitle, but only `s` and smaller"
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "iconType": {
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "\"accessibility\"",
            "computed": false
          }, {
            "value": "\"addDataApp\"",
            "computed": false
          }, {
            "value": "\"advancedSettingsApp\"",
            "computed": false
          }, {
            "value": "\"aggregate\"",
            "computed": false
          }, {
            "value": "\"alert\"",
            "computed": false
          }, {
            "value": "\"annotation\"",
            "computed": false
          }, {
            "value": "\"apmApp\"",
            "computed": false
          }, {
            "value": "\"apmTrace\"",
            "computed": false
          }, {
            "value": "\"apps\"",
            "computed": false
          }, {
            "value": "\"arrowDown\"",
            "computed": false
          }, {
            "value": "\"arrowLeft\"",
            "computed": false
          }, {
            "value": "\"arrowRight\"",
            "computed": false
          }, {
            "value": "\"arrowUp\"",
            "computed": false
          }, {
            "value": "\"asterisk\"",
            "computed": false
          }, {
            "value": "\"auditbeatApp\"",
            "computed": false
          }, {
            "value": "\"beaker\"",
            "computed": false
          }, {
            "value": "\"bell\"",
            "computed": false
          }, {
            "value": "\"bellSlash\"",
            "computed": false
          }, {
            "value": "\"bolt\"",
            "computed": false
          }, {
            "value": "\"boxesHorizontal\"",
            "computed": false
          }, {
            "value": "\"boxesVertical\"",
            "computed": false
          }, {
            "value": "\"branch\"",
            "computed": false
          }, {
            "value": "\"broom\"",
            "computed": false
          }, {
            "value": "\"brush\"",
            "computed": false
          }, {
            "value": "\"bug\"",
            "computed": false
          }, {
            "value": "\"bullseye\"",
            "computed": false
          }, {
            "value": "\"calendar\"",
            "computed": false
          }, {
            "value": "\"canvasApp\"",
            "computed": false
          }, {
            "value": "\"codeApp\"",
            "computed": false
          }, {
            "value": "\"check\"",
            "computed": false
          }, {
            "value": "\"checkInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"cheer\"",
            "computed": false
          }, {
            "value": "\"clock\"",
            "computed": false
          }, {
            "value": "\"cloudDrizzle\"",
            "computed": false
          }, {
            "value": "\"cloudStormy\"",
            "computed": false
          }, {
            "value": "\"cloudSunny\"",
            "computed": false
          }, {
            "value": "\"compute\"",
            "computed": false
          }, {
            "value": "\"console\"",
            "computed": false
          }, {
            "value": "\"consoleApp\"",
            "computed": false
          }, {
            "value": "\"controlsHorizontal\"",
            "computed": false
          }, {
            "value": "\"controlsVertical\"",
            "computed": false
          }, {
            "value": "\"copy\"",
            "computed": false
          }, {
            "value": "\"copyClipboard\"",
            "computed": false
          }, {
            "value": "\"createAdvancedJob\"",
            "computed": false
          }, {
            "value": "\"createMultiMetricJob\"",
            "computed": false
          }, {
            "value": "\"createPopulationJob\"",
            "computed": false
          }, {
            "value": "\"createSingleMetricJob\"",
            "computed": false
          }, {
            "value": "\"cross\"",
            "computed": false
          }, {
            "value": "\"crossClusterReplicationApp\"",
            "computed": false
          }, {
            "value": "\"crosshairs\"",
            "computed": false
          }, {
            "value": "\"crossInACircleFilled\"",
            "computed": false
          }, {
            "value": "\"currency\"",
            "computed": false
          }, {
            "value": "\"cut\"",
            "computed": false
          }, {
            "value": "\"dashboardApp\"",
            "computed": false
          }, {
            "value": "\"database\"",
            "computed": false
          }, {
            "value": "\"dataVisualizer\"",
            "computed": false
          }, {
            "value": "\"devToolsApp\"",
            "computed": false
          }, {
            "value": "\"discoverApp\"",
            "computed": false
          }, {
            "value": "\"document\"",
            "computed": false
          }, {
            "value": "\"documentEdit\"",
            "computed": false
          }, {
            "value": "\"documents\"",
            "computed": false
          }, {
            "value": "\"dot\"",
            "computed": false
          }, {
            "value": "\"download\"",
            "computed": false
          }, {
            "value": "\"editorAlignCenter\"",
            "computed": false
          }, {
            "value": "\"editorAlignLeft\"",
            "computed": false
          }, {
            "value": "\"editorAlignRight\"",
            "computed": false
          }, {
            "value": "\"editorBold\"",
            "computed": false
          }, {
            "value": "\"editorCodeBlock\"",
            "computed": false
          }, {
            "value": "\"editorComment\"",
            "computed": false
          }, {
            "value": "\"editorDistributeHorizontal\"",
            "computed": false
          }, {
            "value": "\"editorDistributeVertical\"",
            "computed": false
          }, {
            "value": "\"editorHeading\"",
            "computed": false
          }, {
            "value": "\"editorItalic\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignLeft\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignBottom\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignCenter\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignMiddle\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignRight\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignTop\"",
            "computed": false
          }, {
            "value": "\"editorLink\"",
            "computed": false
          }, {
            "value": "\"editorOrderedList\"",
            "computed": false
          }, {
            "value": "\"editorPositionBottomLeft\"",
            "computed": false
          }, {
            "value": "\"editorPositionBottomRight\"",
            "computed": false
          }, {
            "value": "\"editorPositionTopLeft\"",
            "computed": false
          }, {
            "value": "\"editorPositionTopRight\"",
            "computed": false
          }, {
            "value": "\"editorRedo\"",
            "computed": false
          }, {
            "value": "\"editorStrike\"",
            "computed": false
          }, {
            "value": "\"editorTable\"",
            "computed": false
          }, {
            "value": "\"editorUnderline\"",
            "computed": false
          }, {
            "value": "\"editorUndo\"",
            "computed": false
          }, {
            "value": "\"editorUnorderedList\"",
            "computed": false
          }, {
            "value": "\"email\"",
            "computed": false
          }, {
            "value": "\"empty\"",
            "computed": false
          }, {
            "value": "\"emsApp\"",
            "computed": false
          }, {
            "value": "\"exit\"",
            "computed": false
          }, {
            "value": "\"expand\"",
            "computed": false
          }, {
            "value": "\"expandMini\"",
            "computed": false
          }, {
            "value": "\"exportAction\"",
            "computed": false
          }, {
            "value": "\"eye\"",
            "computed": false
          }, {
            "value": "\"eyeClosed\"",
            "computed": false
          }, {
            "value": "\"faceHappy\"",
            "computed": false
          }, {
            "value": "\"faceNeutral\"",
            "computed": false
          }, {
            "value": "\"faceSad\"",
            "computed": false
          }, {
            "value": "\"filebeatApp\"",
            "computed": false
          }, {
            "value": "\"filter\"",
            "computed": false
          }, {
            "value": "\"flag\"",
            "computed": false
          }, {
            "value": "\"folderCheck\"",
            "computed": false
          }, {
            "value": "\"folderClosed\"",
            "computed": false
          }, {
            "value": "\"folderExclamation\"",
            "computed": false
          }, {
            "value": "\"folderOpen\"",
            "computed": false
          }, {
            "value": "\"fullScreen\"",
            "computed": false
          }, {
            "value": "\"gear\"",
            "computed": false
          }, {
            "value": "\"gisApp\"",
            "computed": false
          }, {
            "value": "\"glasses\"",
            "computed": false
          }, {
            "value": "\"globe\"",
            "computed": false
          }, {
            "value": "\"grab\"",
            "computed": false
          }, {
            "value": "\"grabHorizontal\"",
            "computed": false
          }, {
            "value": "\"graphApp\"",
            "computed": false
          }, {
            "value": "\"grid\"",
            "computed": false
          }, {
            "value": "\"grokApp\"",
            "computed": false
          }, {
            "value": "\"heart\"",
            "computed": false
          }, {
            "value": "\"heartbeatApp\"",
            "computed": false
          }, {
            "value": "\"heatmap\"",
            "computed": false
          }, {
            "value": "\"help\"",
            "computed": false
          }, {
            "value": "\"home\"",
            "computed": false
          }, {
            "value": "\"iInCircle\"",
            "computed": false
          }, {
            "value": "\"image\"",
            "computed": false
          }, {
            "value": "\"importAction\"",
            "computed": false
          }, {
            "value": "\"indexClose\"",
            "computed": false
          }, {
            "value": "\"indexEdit\"",
            "computed": false
          }, {
            "value": "\"indexFlush\"",
            "computed": false
          }, {
            "value": "\"indexManagementApp\"",
            "computed": false
          }, {
            "value": "\"indexMapping\"",
            "computed": false
          }, {
            "value": "\"indexOpen\"",
            "computed": false
          }, {
            "value": "\"indexPatternApp\"",
            "computed": false
          }, {
            "value": "\"indexRollupApp\"",
            "computed": false
          }, {
            "value": "\"indexSettings\"",
            "computed": false
          }, {
            "value": "\"inputOutput\"",
            "computed": false
          }, {
            "value": "\"inspect\"",
            "computed": false
          }, {
            "value": "\"invert\"",
            "computed": false
          }, {
            "value": "\"ip\"",
            "computed": false
          }, {
            "value": "\"keyboardShortcut\"",
            "computed": false
          }, {
            "value": "\"kqlField\"",
            "computed": false
          }, {
            "value": "\"kqlFunction\"",
            "computed": false
          }, {
            "value": "\"kqlOperand\"",
            "computed": false
          }, {
            "value": "\"kqlSelector\"",
            "computed": false
          }, {
            "value": "\"kqlValue\"",
            "computed": false
          }, {
            "value": "\"lensApp\"",
            "computed": false
          }, {
            "value": "\"link\"",
            "computed": false
          }, {
            "value": "\"list\"",
            "computed": false
          }, {
            "value": "\"listAdd\"",
            "computed": false
          }, {
            "value": "\"lock\"",
            "computed": false
          }, {
            "value": "\"lockOpen\"",
            "computed": false
          }, {
            "value": "\"logsApp\"",
            "computed": false
          }, {
            "value": "\"logoAerospike\"",
            "computed": false
          }, {
            "value": "\"logoApache\"",
            "computed": false
          }, {
            "value": "\"logoAPM\"",
            "computed": false
          }, {
            "value": "\"logoAppSearch\"",
            "computed": false
          }, {
            "value": "\"logoAWS\"",
            "computed": false
          }, {
            "value": "\"logoAWSMono\"",
            "computed": false
          }, {
            "value": "\"logoAzure\"",
            "computed": false
          }, {
            "value": "\"logoAzureMono\"",
            "computed": false
          }, {
            "value": "\"logoBeats\"",
            "computed": false
          }, {
            "value": "\"logoBusinessAnalytics\"",
            "computed": false
          }, {
            "value": "\"logoCeph\"",
            "computed": false
          }, {
            "value": "\"logoCloud\"",
            "computed": false
          }, {
            "value": "\"logoCloudEnterprise\"",
            "computed": false
          }, {
            "value": "\"logoCode\"",
            "computed": false
          }, {
            "value": "\"logoCodesandbox\"",
            "computed": false
          }, {
            "value": "\"logoCouchbase\"",
            "computed": false
          }, {
            "value": "\"logoDocker\"",
            "computed": false
          }, {
            "value": "\"logoDropwizard\"",
            "computed": false
          }, {
            "value": "\"logoElastic\"",
            "computed": false
          }, {
            "value": "\"logoElasticsearch\"",
            "computed": false
          }, {
            "value": "\"logoElasticStack\"",
            "computed": false
          }, {
            "value": "\"logoEnterpriseSearch\"",
            "computed": false
          }, {
            "value": "\"logoEtcd\"",
            "computed": false
          }, {
            "value": "\"logoGCP\"",
            "computed": false
          }, {
            "value": "\"logoGCPMono\"",
            "computed": false
          }, {
            "value": "\"logoGithub\"",
            "computed": false
          }, {
            "value": "\"logoGmail\"",
            "computed": false
          }, {
            "value": "\"logoGolang\"",
            "computed": false
          }, {
            "value": "\"logoGoogleG\"",
            "computed": false
          }, {
            "value": "\"logoHAproxy\"",
            "computed": false
          }, {
            "value": "\"logoIBM\"",
            "computed": false
          }, {
            "value": "\"logoIBMMono\"",
            "computed": false
          }, {
            "value": "\"logoKafka\"",
            "computed": false
          }, {
            "value": "\"logoKibana\"",
            "computed": false
          }, {
            "value": "\"logoKubernetes\"",
            "computed": false
          }, {
            "value": "\"logoLogging\"",
            "computed": false
          }, {
            "value": "\"logoLogstash\"",
            "computed": false
          }, {
            "value": "\"logoMaps\"",
            "computed": false
          }, {
            "value": "\"logoMemcached\"",
            "computed": false
          }, {
            "value": "\"logoMetrics\"",
            "computed": false
          }, {
            "value": "\"logoMongodb\"",
            "computed": false
          }, {
            "value": "\"logoMySQL\"",
            "computed": false
          }, {
            "value": "\"logoNginx\"",
            "computed": false
          }, {
            "value": "\"logoObservability\"",
            "computed": false
          }, {
            "value": "\"logoOsquery\"",
            "computed": false
          }, {
            "value": "\"logoPhp\"",
            "computed": false
          }, {
            "value": "\"logoPostgres\"",
            "computed": false
          }, {
            "value": "\"logoPrometheus\"",
            "computed": false
          }, {
            "value": "\"logoRabbitmq\"",
            "computed": false
          }, {
            "value": "\"logoRedis\"",
            "computed": false
          }, {
            "value": "\"logoSecurity\"",
            "computed": false
          }, {
            "value": "\"logoSiteSearch\"",
            "computed": false
          }, {
            "value": "\"logoSketch\"",
            "computed": false
          }, {
            "value": "\"logoSlack\"",
            "computed": false
          }, {
            "value": "\"logoUptime\"",
            "computed": false
          }, {
            "value": "\"logoWebhook\"",
            "computed": false
          }, {
            "value": "\"logoWindows\"",
            "computed": false
          }, {
            "value": "\"logoWorkplaceSearch\"",
            "computed": false
          }, {
            "value": "\"logstashFilter\"",
            "computed": false
          }, {
            "value": "\"logstashIf\"",
            "computed": false
          }, {
            "value": "\"logstashInput\"",
            "computed": false
          }, {
            "value": "\"logstashOutput\"",
            "computed": false
          }, {
            "value": "\"logstashQueue\"",
            "computed": false
          }, {
            "value": "\"machineLearningApp\"",
            "computed": false
          }, {
            "value": "\"magnet\"",
            "computed": false
          }, {
            "value": "\"magnifyWithMinus\"",
            "computed": false
          }, {
            "value": "\"magnifyWithPlus\"",
            "computed": false
          }, {
            "value": "\"managementApp\"",
            "computed": false
          }, {
            "value": "\"mapMarker\"",
            "computed": false
          }, {
            "value": "\"memory\"",
            "computed": false
          }, {
            "value": "\"menu\"",
            "computed": false
          }, {
            "value": "\"menuLeft\"",
            "computed": false
          }, {
            "value": "\"menuRight\"",
            "computed": false
          }, {
            "value": "\"merge\"",
            "computed": false
          }, {
            "value": "\"metricbeatApp\"",
            "computed": false
          }, {
            "value": "\"metricsApp\"",
            "computed": false
          }, {
            "value": "\"minimize\"",
            "computed": false
          }, {
            "value": "\"minusInCircle\"",
            "computed": false
          }, {
            "value": "\"minusInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"monitoringApp\"",
            "computed": false
          }, {
            "value": "\"moon\"",
            "computed": false
          }, {
            "value": "\"nested\"",
            "computed": false
          }, {
            "value": "\"node\"",
            "computed": false
          }, {
            "value": "\"notebookApp\"",
            "computed": false
          }, {
            "value": "\"number\"",
            "computed": false
          }, {
            "value": "\"offline\"",
            "computed": false
          }, {
            "value": "\"online\"",
            "computed": false
          }, {
            "value": "\"package\"",
            "computed": false
          }, {
            "value": "\"packetbeatApp\"",
            "computed": false
          }, {
            "value": "\"pageSelect\"",
            "computed": false
          }, {
            "value": "\"pagesSelect\"",
            "computed": false
          }, {
            "value": "\"partial\"",
            "computed": false
          }, {
            "value": "\"paperClip\"",
            "computed": false
          }, {
            "value": "\"pause\"",
            "computed": false
          }, {
            "value": "\"pencil\"",
            "computed": false
          }, {
            "value": "\"pin\"",
            "computed": false
          }, {
            "value": "\"pinFilled\"",
            "computed": false
          }, {
            "value": "\"pipelineApp\"",
            "computed": false
          }, {
            "value": "\"play\"",
            "computed": false
          }, {
            "value": "\"plusInCircle\"",
            "computed": false
          }, {
            "value": "\"plusInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"popout\"",
            "computed": false
          }, {
            "value": "\"push\"",
            "computed": false
          }, {
            "value": "\"questionInCircle\"",
            "computed": false
          }, {
            "value": "\"quote\"",
            "computed": false
          }, {
            "value": "\"recentlyViewedApp\"",
            "computed": false
          }, {
            "value": "\"refresh\"",
            "computed": false
          }, {
            "value": "\"reporter\"",
            "computed": false
          }, {
            "value": "\"reportingApp\"",
            "computed": false
          }, {
            "value": "\"save\"",
            "computed": false
          }, {
            "value": "\"savedObjectsApp\"",
            "computed": false
          }, {
            "value": "\"scale\"",
            "computed": false
          }, {
            "value": "\"search\"",
            "computed": false
          }, {
            "value": "\"searchProfilerApp\"",
            "computed": false
          }, {
            "value": "\"securityAnalyticsApp\"",
            "computed": false
          }, {
            "value": "\"securityApp\"",
            "computed": false
          }, {
            "value": "\"securitySignal\"",
            "computed": false
          }, {
            "value": "\"securitySignalDetected\"",
            "computed": false
          }, {
            "value": "\"securitySignalResolved\"",
            "computed": false
          }, {
            "value": "\"shard\"",
            "computed": false
          }, {
            "value": "\"share\"",
            "computed": false
          }, {
            "value": "\"snowflake\"",
            "computed": false
          }, {
            "value": "\"sortable\"",
            "computed": false
          }, {
            "value": "\"sortDown\"",
            "computed": false
          }, {
            "value": "\"sortLeft\"",
            "computed": false
          }, {
            "value": "\"sortRight\"",
            "computed": false
          }, {
            "value": "\"sortUp\"",
            "computed": false
          }, {
            "value": "\"spacesApp\"",
            "computed": false
          }, {
            "value": "\"sqlApp\"",
            "computed": false
          }, {
            "value": "\"starEmpty\"",
            "computed": false
          }, {
            "value": "\"starEmptySpace\"",
            "computed": false
          }, {
            "value": "\"starFilled\"",
            "computed": false
          }, {
            "value": "\"starFilledSpace\"",
            "computed": false
          }, {
            "value": "\"starMinusEmpty\"",
            "computed": false
          }, {
            "value": "\"starMinusFilled\"",
            "computed": false
          }, {
            "value": "\"starPlusEmpty\"",
            "computed": false
          }, {
            "value": "\"starPlusFilled\"",
            "computed": false
          }, {
            "value": "\"stats\"",
            "computed": false
          }, {
            "value": "\"stop\"",
            "computed": false
          }, {
            "value": "\"stopFilled\"",
            "computed": false
          }, {
            "value": "\"stopSlash\"",
            "computed": false
          }, {
            "value": "\"storage\"",
            "computed": false
          }, {
            "value": "\"string\"",
            "computed": false
          }, {
            "value": "\"submodule\"",
            "computed": false
          }, {
            "value": "\"swatchInput\"",
            "computed": false
          }, {
            "value": "\"symlink\"",
            "computed": false
          }, {
            "value": "\"tableOfContents\"",
            "computed": false
          }, {
            "value": "\"tableDensityExpanded\"",
            "computed": false
          }, {
            "value": "\"tableDensityCompact\"",
            "computed": false
          }, {
            "value": "\"tableDensityNormal\"",
            "computed": false
          }, {
            "value": "\"tag\"",
            "computed": false
          }, {
            "value": "\"tear\"",
            "computed": false
          }, {
            "value": "\"temperature\"",
            "computed": false
          }, {
            "value": "\"timeline\"",
            "computed": false
          }, {
            "value": "\"timelionApp\"",
            "computed": false
          }, {
            "value": "\"training\"",
            "computed": false
          }, {
            "value": "\"trash\"",
            "computed": false
          }, {
            "value": "\"upgradeAssistantApp\"",
            "computed": false
          }, {
            "value": "\"uptimeApp\"",
            "computed": false
          }, {
            "value": "\"user\"",
            "computed": false
          }, {
            "value": "\"users\"",
            "computed": false
          }, {
            "value": "\"usersRolesApp\"",
            "computed": false
          }, {
            "value": "\"vector\"",
            "computed": false
          }, {
            "value": "\"videoPlayer\"",
            "computed": false
          }, {
            "value": "\"visArea\"",
            "computed": false
          }, {
            "value": "\"visAreaStacked\"",
            "computed": false
          }, {
            "value": "\"visBarHorizontal\"",
            "computed": false
          }, {
            "value": "\"visBarHorizontalStacked\"",
            "computed": false
          }, {
            "value": "\"visBarVertical\"",
            "computed": false
          }, {
            "value": "\"visBarVerticalStacked\"",
            "computed": false
          }, {
            "value": "\"visGauge\"",
            "computed": false
          }, {
            "value": "\"visGoal\"",
            "computed": false
          }, {
            "value": "\"visLine\"",
            "computed": false
          }, {
            "value": "\"visMapCoordinate\"",
            "computed": false
          }, {
            "value": "\"visMapRegion\"",
            "computed": false
          }, {
            "value": "\"visMetric\"",
            "computed": false
          }, {
            "value": "\"visPie\"",
            "computed": false
          }, {
            "value": "\"visTable\"",
            "computed": false
          }, {
            "value": "\"visTagCloud\"",
            "computed": false
          }, {
            "value": "\"visText\"",
            "computed": false
          }, {
            "value": "\"visTimelion\"",
            "computed": false
          }, {
            "value": "\"visualizeApp\"",
            "computed": false
          }, {
            "value": "\"visVega\"",
            "computed": false
          }, {
            "value": "\"visVisualBuilder\"",
            "computed": false
          }, {
            "value": "\"watchesApp\"",
            "computed": false
          }, {
            "value": "\"wrench\"",
            "computed": false
          }, {
            "value": "\"tokenClass\"",
            "computed": false
          }, {
            "value": "\"tokenProperty\"",
            "computed": false
          }, {
            "value": "\"tokenEnum\"",
            "computed": false
          }, {
            "value": "\"tokenVariable\"",
            "computed": false
          }, {
            "value": "\"tokenMethod\"",
            "computed": false
          }, {
            "value": "\"tokenAnnotation\"",
            "computed": false
          }, {
            "value": "\"tokenException\"",
            "computed": false
          }, {
            "value": "\"tokenInterface\"",
            "computed": false
          }, {
            "value": "\"tokenParameter\"",
            "computed": false
          }, {
            "value": "\"tokenField\"",
            "computed": false
          }, {
            "value": "\"tokenElement\"",
            "computed": false
          }, {
            "value": "\"tokenFunction\"",
            "computed": false
          }, {
            "value": "\"tokenBoolean\"",
            "computed": false
          }, {
            "value": "\"tokenString\"",
            "computed": false
          }, {
            "value": "\"tokenArray\"",
            "computed": false
          }, {
            "value": "\"tokenNumber\"",
            "computed": false
          }, {
            "value": "\"tokenConstant\"",
            "computed": false
          }, {
            "value": "\"tokenObject\"",
            "computed": false
          }, {
            "value": "\"tokenEvent\"",
            "computed": false
          }, {
            "value": "\"tokenKey\"",
            "computed": false
          }, {
            "value": "\"tokenNull\"",
            "computed": false
          }, {
            "value": "\"tokenStruct\"",
            "computed": false
          }, {
            "value": "\"tokenPackage\"",
            "computed": false
          }, {
            "value": "\"tokenOperator\"",
            "computed": false
          }, {
            "value": "\"tokenEnumMember\"",
            "computed": false
          }, {
            "value": "\"tokenRepo\"",
            "computed": false
          }, {
            "value": "\"tokenSymbol\"",
            "computed": false
          }, {
            "value": "\"tokenFile\"",
            "computed": false
          }, {
            "value": "\"tokenModule\"",
            "computed": false
          }, {
            "value": "\"tokenNamespace\"",
            "computed": false
          }, {
            "value": "\"tokenDate\"",
            "computed": false
          }, {
            "value": "\"tokenIP\"",
            "computed": false
          }, {
            "value": "\"tokenNested\"",
            "computed": false
          }, {
            "value": "\"tokenAlias\"",
            "computed": false
          }, {
            "value": "\"tokenShape\"",
            "computed": false
          }, {
            "value": "\"tokenGeo\"",
            "computed": false
          }, {
            "value": "\"tokenRange\"",
            "computed": false
          }, {
            "value": "\"tokenBinary\"",
            "computed": false
          }, {
            "value": "\"tokenJoin\"",
            "computed": false
          }, {
            "value": "\"tokenPercolator\"",
            "computed": false
          }, {
            "value": "\"tokenFlattened\"",
            "computed": false
          }, {
            "value": "\"tokenRankFeature\"",
            "computed": false
          }, {
            "value": "\"tokenRankFeatures\"",
            "computed": false
          }, {
            "value": "\"tokenKeyword\"",
            "computed": false
          }, {
            "value": "\"tokenCompletionSuggester\"",
            "computed": false
          }, {
            "value": "\"tokenDenseVector\"",
            "computed": false
          }, {
            "value": "\"tokenText\"",
            "computed": false
          }, {
            "value": "\"tokenTokenCount\"",
            "computed": false
          }, {
            "value": "\"tokenSearchType\"",
            "computed": false
          }, {
            "value": "\"tokenHistogram\"",
            "computed": false
          }]
        }, {
          "name": "string"
        }, {
          "name": "elementType"
        }]
      },
      "required": false,
      "description": "Sits left of the `title` and only when `title` is present"
    },
    "iconProps": {
      "type": {
        "name": "shape",
        "value": {
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "color": {
            "name": "union",
            "value": [{
              "name": "string"
            }, {
              "name": "enum",
              "value": [{
                "value": "\"default\"",
                "computed": false
              }, {
                "value": "\"primary\"",
                "computed": false
              }, {
                "value": "\"secondary\"",
                "computed": false
              }, {
                "value": "\"success\"",
                "computed": false
              }, {
                "value": "\"accent\"",
                "computed": false
              }, {
                "value": "\"warning\"",
                "computed": false
              }, {
                "value": "\"danger\"",
                "computed": false
              }, {
                "value": "\"text\"",
                "computed": false
              }, {
                "value": "\"subdued\"",
                "computed": false
              }, {
                "value": "\"ghost\"",
                "computed": false
              }]
            }],
            "description": "One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.\nNote that coloring only works if your SVG is removed of fill attributes.",
            "required": false
          },
          "title": {
            "name": "string",
            "description": "Descriptive title for naming the icon based on its use",
            "required": false
          },
          "titleId": {
            "name": "string",
            "description": "A unique identifier for the title element",
            "required": false
          },
          "aria-labelledby": {
            "name": "string",
            "description": "Its value should be one or more element IDs",
            "required": false
          },
          "onIconLoad": {
            "name": "func",
            "description": "Callback when the icon has been loaded & rendered",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Further extend the props applied to EuiIcon"
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Optionally provide an id, otherwise one will be created"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "buttonClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Class that will apply to the trigger for the accordion."
    },
    "buttonContentClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Class that will apply to the trigger content for the accordion."
    },
    "buttonContent": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "The content of the clickable trigger"
    },
    "extraAction": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Will appear right aligned against the button. Useful for separate actions like deletions."
    },
    "initialIsOpen": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "The accordion will start in the open state."
    },
    "onToggle": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Optional callback method called on open and close with a single `isOpen` parameter"
    },
    "paddingSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"xs\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }, {
          "value": "\"xl\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "The padding around the exposed accordion content."
    },
    "arrowDisplay": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"left\"",
          "computed": false
        }, {
          "value": "\"right\"",
          "computed": false
        }, {
          "value": "\"none\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Placement of the arrow indicator, or 'none' to hide it.\nPlacing on the `right` doesn't work with `extraAction` and so it will be ignored"
    },
    "forceState": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"closed\"",
          "computed": false
        }, {
          "value": "\"open\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Control the opening of accordin via prop"
    },
    "title": {
      "type": {
        "name": "union",
        "value": [{
          "name": "node"
        }, {
          "name": "node"
        }]
      },
      "required": false,
      "description": "The title gets wrapped in the appropriate heading level\nwith the option to add an iconType"
    }
  }
};