function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { BucketAggType } from './bucket_agg_type';
import { KBN_FIELD_TYPES } from '../../../../common';
import { BUCKET_TYPES } from './bucket_agg_types';
var defaultBoundingBox = {
  top_left: {
    lat: 1,
    lon: 1
  },
  bottom_right: {
    lat: 0,
    lon: 0
  }
};
var defaultPrecision = 2;
var geohashGridTitle = i18n.translate('data.search.aggs.buckets.geohashGridTitle', {
  defaultMessage: 'Geohash'
});
export var getGeoHashBucketAgg = function getGeoHashBucketAgg() {
  return new BucketAggType({
    name: BUCKET_TYPES.GEOHASH_GRID,
    title: geohashGridTitle,
    makeLabel: function makeLabel() {
      return geohashGridTitle;
    },
    params: [{
      name: 'field',
      type: 'field',
      filterFieldTypes: KBN_FIELD_TYPES.GEO_POINT
    }, {
      name: 'autoPrecision',
      default: true,
      write: function write() {}
    }, {
      name: 'precision',
      default: defaultPrecision,
      write: function write(aggConfig, output) {
        output.params.precision = aggConfig.params.precision;
      }
    }, {
      name: 'useGeocentroid',
      default: true,
      write: function write() {}
    }, {
      name: 'isFilteredByCollar',
      default: true,
      write: function write() {}
    }, {
      name: 'boundingBox',
      default: null,
      write: function write() {}
    }],
    getRequestAggs: function getRequestAggs(agg) {
      var aggs = [];
      var params = agg.params;

      if (params.isFilteredByCollar && agg.getField()) {
        aggs.push(agg.aggConfigs.createAggConfig({
          type: 'filter',
          id: 'filter_agg',
          enabled: true,
          params: {
            geo_bounding_box: _defineProperty({
              ignore_unmapped: true
            }, agg.getField().name, params.boundingBox || defaultBoundingBox)
          }
        }, {
          addToAggConfigs: false
        }));
      }

      aggs.push(agg);

      if (params.useGeocentroid) {
        aggs.push(agg.aggConfigs.createAggConfig({
          type: 'geo_centroid',
          enabled: true,
          params: {
            field: agg.getField()
          }
        }, {
          addToAggConfigs: false
        }));
      }

      return aggs;
    }
  });
};