function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { SavedObjectNotFound } from '../../../../../../plugins/kibana_utils/common';
import { BaseParamType } from './base';
import { propFilter } from '../utils';
import { isNestedField } from '../../../../common';
var filterByType = propFilter('type');
export var FieldParamType = /*#__PURE__*/function (_BaseParamType) {
  _inherits(FieldParamType, _BaseParamType);

  var _super = _createSuper(FieldParamType);

  function FieldParamType(config) {
    var _this;

    _classCallCheck(this, FieldParamType);

    _this = _super.call(this, config);

    _defineProperty(_assertThisInitialized(_this), "required", true);

    _defineProperty(_assertThisInitialized(_this), "scriptable", true);

    _defineProperty(_assertThisInitialized(_this), "filterFieldTypes", void 0);

    _defineProperty(_assertThisInitialized(_this), "onlyAggregatable", void 0);

    _defineProperty(_assertThisInitialized(_this), "getAvailableFields", function (aggConfig) {
      var fields = aggConfig.getIndexPattern().fields;
      var filteredFields = fields.filter(function (field) {
        var _assertThisInitialize = _assertThisInitialized(_this),
            onlyAggregatable = _assertThisInitialize.onlyAggregatable,
            scriptable = _assertThisInitialize.scriptable,
            filterFieldTypes = _assertThisInitialize.filterFieldTypes;

        if (onlyAggregatable && (!field.aggregatable || isNestedField(field)) || !scriptable && field.scripted) {
          return false;
        }

        return filterByType([field], filterFieldTypes).length !== 0;
      });
      return filteredFields;
    });

    _this.filterFieldTypes = config.filterFieldTypes || '*';
    _this.onlyAggregatable = config.onlyAggregatable !== false;

    if (!config.write) {
      _this.write = function (aggConfig, output) {
        var field = aggConfig.getField();

        if (!field) {
          throw new TypeError(i18n.translate('data.search.aggs.paramTypes.field.requiredFieldParameterErrorMessage', {
            defaultMessage: '{fieldParameter} is a required parameter',
            values: {
              fieldParameter: '"field"'
            }
          }));
        }

        if (field.scripted) {
          output.params.script = {
            source: field.script,
            lang: field.lang
          };
        } else {
          output.params.field = field.name;
        }
      };
    }

    _this.serialize = function (field) {
      return field.name;
    };

    _this.deserialize = function (fieldName, aggConfig) {
      if (!aggConfig) {
        throw new Error('aggConfig was not provided to FieldParamType deserialize function');
      }

      var field = aggConfig.getIndexPattern().fields.getByName(fieldName);

      if (!field) {
        throw new SavedObjectNotFound('index-pattern-field', fieldName);
      }

      var validField = _this.getAvailableFields(aggConfig).find(function (f) {
        return f.name === fieldName;
      });

      if (!validField) {
        throw new Error(i18n.translate('data.search.aggs.paramTypes.field.invalidSavedFieldParameterErrorMessage', {
          defaultMessage: 'Saved {fieldParameter} parameter is now invalid. Please select a new field.',
          values: {
            fieldParameter: '"field"'
          }
        }));
      }

      return validField;
    };

    return _this;
  }
  /**
   * filter the fields to the available ones
   */


  return FieldParamType;
}(BaseParamType);