function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getSort } from './get_sort';
import { getDefaultSort } from './get_default_sort';
/**
 * Prepares sort for search source, that's sending the request to ES
 * - Adds default sort if necessary
 * - Handles the special case when there's sorting by date_nanos typed fields
 *   the addon of the numeric_type guarantees the right sort order
 *   when there are indices with date and indices with date_nanos field
 */

export function getSortForSearchSource(sort, indexPattern) {
  var defaultDirection = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'desc';

  if (!sort || !indexPattern) {
    return [];
  } else if (Array.isArray(sort) && sort.length === 0) {
    sort = getDefaultSort(indexPattern, defaultDirection);
  }

  var timeFieldName = indexPattern.timeFieldName;
  return getSort(sort, indexPattern).map(function (sortPair) {
    if (indexPattern.isTimeNanosBased() && timeFieldName && sortPair[timeFieldName]) {
      return _defineProperty({}, timeFieldName, {
        order: sortPair[timeFieldName],
        numeric_type: 'date_nanos'
      });
    }

    return sortPair;
  });
}