function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { cloneDeep } from 'lodash';
import { isEmbeddableEditorState, isEmbeddablePackageState } from './types';
/**
 * A wrapper around the state object in {@link ScopedHistory | core scoped history} which provides
 * strongly typed helper methods for common incoming and outgoing states used by the embeddable infrastructure.
 *
 * @public
 */

export var EmbeddableStateTransfer = /*#__PURE__*/function () {
  function EmbeddableStateTransfer(navigateToApp, scopedHistory) {
    _classCallCheck(this, EmbeddableStateTransfer);

    this.navigateToApp = navigateToApp;
    this.scopedHistory = scopedHistory;
  }
  /**
   * Fetches an {@link EmbeddableEditorState | originating app} argument from the scoped
   * history's location state.
   *
   * @param history - the scoped history to fetch from
   * @param options.keysToRemoveAfterFetch - an array of keys to be removed from the state after they are retrieved
   */


  _createClass(EmbeddableStateTransfer, [{
    key: "getIncomingEditorState",
    value: function getIncomingEditorState(options) {
      return this.getIncomingState(isEmbeddableEditorState, {
        keysToRemoveAfterFetch: options === null || options === void 0 ? void 0 : options.keysToRemoveAfterFetch
      });
    }
    /**
     * Fetches an {@link EmbeddablePackageState | embeddable package} argument from the scoped
     * history's location state.
     *
     * @param history - the scoped history to fetch from
     * @param options.keysToRemoveAfterFetch - an array of keys to be removed from the state after they are retrieved
     */

  }, {
    key: "getIncomingEmbeddablePackage",
    value: function getIncomingEmbeddablePackage(options) {
      return this.getIncomingState(isEmbeddablePackageState, {
        keysToRemoveAfterFetch: options === null || options === void 0 ? void 0 : options.keysToRemoveAfterFetch
      });
    }
    /**
     * A wrapper around the {@link ApplicationStart.navigateToApp} method which navigates to the specified appId
     * with {@link EmbeddableEditorState | embeddable editor state}
     */

  }, {
    key: "navigateToEditor",
    value: function () {
      var _navigateToEditor = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(appId, options) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.navigateToWithState(appId, options);

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function navigateToEditor(_x, _x2) {
        return _navigateToEditor.apply(this, arguments);
      }

      return navigateToEditor;
    }()
    /**
     * A wrapper around the {@link ApplicationStart.navigateToApp} method which navigates to the specified appId
     * with {@link EmbeddablePackageState | embeddable package state}
     */

  }, {
    key: "navigateToWithEmbeddablePackage",
    value: function () {
      var _navigateToWithEmbeddablePackage = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(appId, options) {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.navigateToWithState(appId, options);

              case 2:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function navigateToWithEmbeddablePackage(_x3, _x4) {
        return _navigateToWithEmbeddablePackage.apply(this, arguments);
      }

      return navigateToWithEmbeddablePackage;
    }()
  }, {
    key: "getIncomingState",
    value: function getIncomingState(guard, options) {
      var _this$scopedHistory$l;

      if (!this.scopedHistory) {
        throw new TypeError('ScopedHistory is required to fetch incoming state');
      }

      var incomingState = (_this$scopedHistory$l = this.scopedHistory.location) === null || _this$scopedHistory$l === void 0 ? void 0 : _this$scopedHistory$l.state;
      var castState = !guard || guard(incomingState) ? cloneDeep(incomingState) : undefined;

      if (castState && (options === null || options === void 0 ? void 0 : options.keysToRemoveAfterFetch)) {
        var stateReplace = _objectSpread({}, this.scopedHistory.location.state);

        options.keysToRemoveAfterFetch.forEach(function (key) {
          delete stateReplace[key];
        });
        this.scopedHistory.replace(_objectSpread(_objectSpread({}, this.scopedHistory.location), {}, {
          state: stateReplace
        }));
      }

      return castState;
    }
  }, {
    key: "navigateToWithState",
    value: function () {
      var _navigateToWithState = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(appId, options) {
        var _this$scopedHistory;

        var stateObject;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                stateObject = (options === null || options === void 0 ? void 0 : options.appendToExistingState) && this.scopedHistory ? _objectSpread(_objectSpread({}, (_this$scopedHistory = this.scopedHistory) === null || _this$scopedHistory === void 0 ? void 0 : _this$scopedHistory.location.state), options.state) : options === null || options === void 0 ? void 0 : options.state;
                _context3.next = 3;
                return this.navigateToApp(appId, {
                  path: options === null || options === void 0 ? void 0 : options.path,
                  state: stateObject
                });

              case 3:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function navigateToWithState(_x5, _x6) {
        return _navigateToWithState.apply(this, arguments);
      }

      return navigateToWithState;
    }()
  }]);

  return EmbeddableStateTransfer;
}();