function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './index.scss';
import { createSavedObjectClass } from './saved_object';
import { PER_PAGE_SETTING, LISTING_LIMIT_SETTING } from '../common';
export var SavedObjectsPublicPlugin = /*#__PURE__*/function () {
  function SavedObjectsPublicPlugin() {
    _classCallCheck(this, SavedObjectsPublicPlugin);
  }

  _createClass(SavedObjectsPublicPlugin, [{
    key: "setup",
    value: function setup() {}
  }, {
    key: "start",
    value: function start(core, _ref) {
      var data = _ref.data;
      return {
        SavedObjectClass: createSavedObjectClass({
          indexPatterns: data.indexPatterns,
          savedObjectsClient: core.savedObjects.client,
          search: data.search,
          chrome: core.chrome,
          overlays: core.overlays
        }),
        settings: {
          getPerPage: function getPerPage() {
            return core.uiSettings.get(PER_PAGE_SETTING);
          },
          getListingLimit: function getListingLimit() {
            return core.uiSettings.get(LISTING_LIMIT_SETTING);
          }
        }
      };
    }
  }]);

  return SavedObjectsPublicPlugin;
}();