function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from 'react';
import { EuiCallOut, EuiCodeBlock, EuiFlexGroup, EuiFlexItem, EuiFlyout, EuiFlyoutHeader, EuiFlyoutBody, EuiLoadingSpinner, EuiPortal // EuiPortal is a temporary requirement to use EuiFlyout with "ownFocus"
, EuiText, EuiTextColor, EuiTitle } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';

/**
 * React component for displaying the example data associated with the Telemetry opt-in banner.
 */
export var OptInExampleFlyout = /*#__PURE__*/function (_React$PureComponent) {
  _inherits(OptInExampleFlyout, _React$PureComponent);

  var _super = _createSuper(OptInExampleFlyout);

  function OptInExampleFlyout() {
    var _this;

    _classCallCheck(this, OptInExampleFlyout);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      data: null,
      isLoading: true,
      hasPrivilegeToRead: false
    });

    return _this;
  }

  _createClass(OptInExampleFlyout, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var fetchExample, clusters;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                fetchExample = this.props.fetchExample;
                _context.next = 4;
                return fetchExample();

              case 4:
                clusters = _context.sent;
                this.setState({
                  data: Array.isArray(clusters) ? clusters : null,
                  isLoading: false,
                  hasPrivilegeToRead: true
                });
                _context.next = 11;
                break;

              case 8:
                _context.prev = 8;
                _context.t0 = _context["catch"](0);
                this.setState({
                  isLoading: false,
                  hasPrivilegeToRead: _context.t0.status !== 403
                });

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 8]]);
      }));

      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }

      return componentDidMount;
    }()
  }, {
    key: "renderBody",
    value: function renderBody(_ref) {
      var data = _ref.data,
          isLoading = _ref.isLoading,
          hasPrivilegeToRead = _ref.hasPrivilegeToRead;

      if (isLoading) {
        return /*#__PURE__*/React.createElement(EuiFlexGroup, {
          justifyContent: "spaceAround"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
          size: "xl"
        })));
      }

      if (!hasPrivilegeToRead) {
        return /*#__PURE__*/React.createElement(EuiCallOut, {
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "telemetry.callout.errorUnprivilegedUserTitle",
            defaultMessage: "Error displaying cluster statistics"
          }),
          color: "danger",
          iconType: "cross"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "telemetry.callout.errorUnprivilegedUserDescription",
          defaultMessage: "You do not have access to see unencrypted cluster statistics."
        }));
      }

      if (data === null) {
        return /*#__PURE__*/React.createElement(EuiCallOut, {
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "telemetry.callout.errorLoadingClusterStatisticsTitle",
            defaultMessage: "Error loading cluster statistics"
          }),
          color: "danger",
          iconType: "cross"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "telemetry.callout.errorLoadingClusterStatisticsDescription",
          defaultMessage: "An unexpected error occured while attempting to fetch the cluster statistics. This can occur because Elasticsearch failed, Kibana failed, or there is a network error. Check Kibana, then reload the page and try again."
        }));
      }

      return /*#__PURE__*/React.createElement(EuiCodeBlock, {
        language: "js"
      }, JSON.stringify(data, null, 2));
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(EuiPortal, null, /*#__PURE__*/React.createElement(EuiFlyout, {
        ownFocus: true,
        onClose: this.props.onClose,
        maxWidth: true
      }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, null, /*#__PURE__*/React.createElement(EuiTitle, null, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "telemetry.callout.clusterStatisticsTitle",
        defaultMessage: "Cluster statistics"
      }))), /*#__PURE__*/React.createElement(EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "telemetry.callout.clusterStatisticsDescription",
        defaultMessage: "This is an example of the basic cluster statistics that we'll collect. It includes the number of indices, shards, and nodes. It also includes high-level usage statistics, such as whether monitoring is turned on."
      })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, this.renderBody(this.state))));
    }
  }]);

  return OptInExampleFlyout;
}(React.PureComponent);