function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * @name Vis
 *
 * @description This class consists of aggs, params, listeners, title, and type.
 *  - Aggs: Instances of IAggConfig.
 *  - Params: The settings in the Options tab.
 *
 * Not to be confused with vislib/vis.js.
 */
import { isFunction, defaults, cloneDeep } from 'lodash';
import { i18n } from '@kbn/i18n';
import { PersistedState } from './persisted_state';
import { getTypes, getAggs, getSearch, getSavedSearchLoader } from './services';

var getSearchSource = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(inputSearchSource, savedSearchId) {
    var searchSource, savedSearch;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            searchSource = inputSearchSource.createCopy();

            if (!savedSearchId) {
              _context.next = 6;
              break;
            }

            _context.next = 4;
            return getSavedSearchLoader().get(savedSearchId);

          case 4:
            savedSearch = _context.sent;
            searchSource.setParent(savedSearch.searchSource);

          case 6:
            searchSource.setField('size', 0);
            return _context.abrupt("return", searchSource);

          case 8:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function getSearchSource(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

export var Vis = /*#__PURE__*/function () {
  // Session state is for storing information that is transitory, and will not be saved with the visualization.
  // For instance, map bounds, which depends on the view port, browser window size, etc.
  function Vis(visType) {
    var visState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Vis);

    _defineProperty(this, "type", void 0);

    _defineProperty(this, "id", void 0);

    _defineProperty(this, "title", '');

    _defineProperty(this, "description", '');

    _defineProperty(this, "params", {});

    _defineProperty(this, "sessionState", {});

    _defineProperty(this, "data", {});

    _defineProperty(this, "uiState", void 0);

    this.type = this.getType(visType);
    this.params = this.getParams(visState.params);
    this.uiState = new PersistedState(visState.uiState);
    this.id = visState.id;
  }

  _createClass(Vis, [{
    key: "getType",
    value: function getType(visType) {
      var type = getTypes().get(visType);

      if (!type) {
        var errorMessage = i18n.translate('visualizations.visualizationTypeInvalidMessage', {
          defaultMessage: 'Invalid visualization type "{visType}"',
          values: {
            visType: visType
          }
        });
        throw new Error(errorMessage);
      }

      return type;
    }
  }, {
    key: "getParams",
    value: function getParams(params) {
      return defaults({}, cloneDeep(params || {}), cloneDeep(this.type.visConfig.defaults || {}));
    }
  }, {
    key: "setState",
    value: function () {
      var _setState = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(state) {
        var typeChanged, aggs, configStates, errorMessage;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                typeChanged = false;

                if (state.type && this.type.name !== state.type) {
                  // @ts-ignore
                  this.type = this.getType(state.type);
                  typeChanged = true;
                }

                if (state.title !== undefined) {
                  this.title = state.title;
                }

                if (state.description !== undefined) {
                  this.description = state.description;
                }

                if (state.params || typeChanged) {
                  this.params = this.getParams(state.params);
                }

                if (!(state.data && state.data.searchSource)) {
                  _context2.next = 10;
                  break;
                }

                _context2.next = 8;
                return getSearch().searchSource.create(state.data.searchSource);

              case 8:
                this.data.searchSource = _context2.sent;
                this.data.indexPattern = this.data.searchSource.getField('index');

              case 10:
                if (!(state.data && state.data.savedSearchId)) {
                  _context2.next = 17;
                  break;
                }

                this.data.savedSearchId = state.data.savedSearchId;

                if (!this.data.searchSource) {
                  _context2.next = 17;
                  break;
                }

                _context2.next = 15;
                return getSearchSource(this.data.searchSource, this.data.savedSearchId);

              case 15:
                this.data.searchSource = _context2.sent;
                this.data.indexPattern = this.data.searchSource.getField('index');

              case 17:
                if (!(state.data && (state.data.aggs || !this.data.aggs))) {
                  _context2.next = 26;
                  break;
                }

                aggs = state.data.aggs ? cloneDeep(state.data.aggs) : [];
                configStates = this.initializeDefaultsFromSchemas(aggs, this.type.schemas.all || []);

                if (this.data.indexPattern) {
                  _context2.next = 25;
                  break;
                }

                if (!aggs.length) {
                  _context2.next = 24;
                  break;
                }

                errorMessage = i18n.translate('visualizations.initializeWithoutIndexPatternErrorMessage', {
                  defaultMessage: 'Trying to initialize aggs without index pattern'
                });
                throw new Error(errorMessage);

              case 24:
                return _context2.abrupt("return");

              case 25:
                this.data.aggs = getAggs().createAggConfigs(this.data.indexPattern, configStates);

              case 26:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function setState(_x3) {
        return _setState.apply(this, arguments);
      }

      return setState;
    }()
  }, {
    key: "clone",
    value: function clone() {
      var _this$serialize = this.serialize(),
          data = _this$serialize.data,
          restOfSerialized = _objectWithoutProperties(_this$serialize, ["data"]);

      var vis = new Vis(this.type.name, restOfSerialized);
      vis.setState(_objectSpread(_objectSpread({}, restOfSerialized), {}, {
        data: {}
      }));
      var aggs = this.data.indexPattern ? getAggs().createAggConfigs(this.data.indexPattern, data.aggs) : undefined;
      vis.data = _objectSpread(_objectSpread({}, this.data), {}, {
        aggs: aggs
      });
      return vis;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      var aggs = this.data.aggs ? this.data.aggs.aggs.map(function (agg) {
        return agg.toJSON();
      }) : [];
      return {
        id: this.id,
        title: this.title,
        description: this.description,
        type: this.type.name,
        params: cloneDeep(this.params),
        uiState: this.uiState.toJSON(),
        data: {
          aggs: aggs,
          searchSource: this.data.searchSource ? this.data.searchSource.getSerializedFields() : {},
          savedSearchId: this.data.savedSearchId
        }
      };
    }
  }, {
    key: "toAST",
    value: function toAST() {
      return this.type.toAST(this.params);
    } // deprecated

  }, {
    key: "isHierarchical",
    value: function isHierarchical() {
      if (isFunction(this.type.hierarchicalData)) {
        return !!this.type.hierarchicalData(this);
      } else {
        return !!this.type.hierarchicalData;
      }
    }
  }, {
    key: "initializeDefaultsFromSchemas",
    value: function initializeDefaultsFromSchemas(configStates, schemas) {
      // Set the defaults for any schema which has them. If the defaults
      // for some reason has more then the max only set the max number
      // of defaults (not sure why a someone define more...
      // but whatever). Also if a schema.name is already set then don't
      // set anything.
      var newConfigs = _toConsumableArray(configStates);

      schemas.filter(function (schema) {
        return Array.isArray(schema.defaults) && schema.defaults.length > 0;
      }).filter(function (schema) {
        return !configStates.find(function (agg) {
          return agg.schema && agg.schema === schema.name;
        });
      }).forEach(function (schema) {
        var defaultSchemaConfig = schema.defaults.slice(0, schema.max);
        defaultSchemaConfig.forEach(function (d) {
          return newConfigs.push(d);
        });
      });
      return newConfigs;
    }
  }]);

  return Vis;
}();