function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
export var BaseVisType = /*#__PURE__*/function () {
  function BaseVisType(opts) {
    _classCallCheck(this, BaseVisType);

    _defineProperty(this, "name", void 0);

    _defineProperty(this, "title", void 0);

    _defineProperty(this, "description", void 0);

    _defineProperty(this, "getSupportedTriggers", void 0);

    _defineProperty(this, "icon", void 0);

    _defineProperty(this, "image", void 0);

    _defineProperty(this, "stage", void 0);

    _defineProperty(this, "isExperimental", void 0);

    _defineProperty(this, "options", void 0);

    _defineProperty(this, "visualization", void 0);

    _defineProperty(this, "visConfig", void 0);

    _defineProperty(this, "editor", void 0);

    _defineProperty(this, "editorConfig", void 0);

    _defineProperty(this, "hidden", void 0);

    _defineProperty(this, "requiresSearch", void 0);

    _defineProperty(this, "requestHandler", void 0);

    _defineProperty(this, "responseHandler", void 0);

    _defineProperty(this, "hierarchicalData", void 0);

    _defineProperty(this, "setup", void 0);

    _defineProperty(this, "useCustomNoDataScreen", void 0);

    if (!opts.icon && !opts.image) {
      throw new Error('vis_type must define its icon or image');
    }

    var defaultOptions = {
      // controls the visualize editor
      showTimePicker: true,
      showQueryBar: true,
      showFilterBar: true,
      showIndexSelection: true,
      hierarchicalData: false // we should get rid of this i guess ?

    };
    this.name = opts.name;
    this.description = opts.description || '';
    this.getSupportedTriggers = opts.getSupportedTriggers;
    this.title = opts.title;
    this.icon = opts.icon;
    this.image = opts.image;
    this.visualization = opts.visualization;
    this.visConfig = _.defaultsDeep({}, opts.visConfig, {
      defaults: {}
    });
    this.editor = opts.editor;
    this.editorConfig = _.defaultsDeep({}, opts.editorConfig, {
      collections: {}
    });
    this.options = _.defaultsDeep({}, opts.options, defaultOptions);
    this.stage = opts.stage || 'production';
    this.isExperimental = opts.stage === 'experimental';
    this.hidden = opts.hidden || false;
    this.requestHandler = opts.requestHandler || 'courier';
    this.responseHandler = opts.responseHandler || 'none';
    this.setup = opts.setup;
    this.requiresSearch = this.requestHandler !== 'none';
    this.hierarchicalData = opts.hierarchicalData || false;
    this.useCustomNoDataScreen = opts.useCustomNoDataScreen || false;
  }

  _createClass(BaseVisType, [{
    key: "schemas",
    get: function get() {
      if (this.editorConfig && this.editorConfig.schemas) {
        return this.editorConfig.schemas;
      }

      return [];
    }
  }]);

  return BaseVisType;
}();