// -*- C++ -*-
//===--------------------------- complex.h --------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_COMPLEX_H
#define _LIBCPP_COMPLEX_H

/*
    complex.h synopsis

#include <ccomplex>

*/

#include <__config>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#pragma GCC system_header
#endif

#ifdef __cplusplus

#include <ccomplex>

#else  // __cplusplus

#include_next <complex.h>

#endif  // __cplusplus

#endif  // _LIBCPP_COMPLEX_H
