/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextAreaCreationTool
extends CreationTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolderFigure typingTarget;
    private Color rubberbandColor = null;

    public TextAreaCreationTool(TextHolderFigure textHolderFigure) {
        super(textHolderFigure);
    }

    public TextAreaCreationTool(TextHolderFigure textHolderFigure, Map<AttributeKey, Object> map) {
        super(textHolderFigure, map);
    }

    public void setRubberbandColor(Color color) {
        this.rubberbandColor = color;
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        this.endEdit();
        super.deactivate(drawingEditor);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextHolderFigure textHolderFigure = null;
        DrawingView drawingView = this.getView();
        Point2D.Double double_ = drawingView.viewToDrawing(mouseEvent.getPoint());
        Figure figure = null;
        for (Figure figure2 : drawingView.getSelectedFigures()) {
            if (!figure2.contains(double_)) continue;
            figure = figure2;
            break;
        }
        if (figure == null) {
            figure = this.getDrawing().findFigureInside(double_);
        }
        if (figure instanceof TextHolderFigure) {
            textHolderFigure = (TextHolderFigure)figure;
            textHolderFigure = null;
        }
        if (textHolderFigure != null) {
            this.createdFigure = null;
            this.beginEdit(textHolderFigure);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            if (this.isToolDoneAfterCreation()) {
                this.fireToolDone();
            }
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void creationFinished(Figure figure) {
        this.getView().clearSelection();
        this.getView().addToSelection(figure);
        this.beginEdit((TextHolderFigure)figure);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.createdFigure != null && this.rubberbandColor != null) {
            graphics2D.setColor(this.rubberbandColor);
            graphics2D.draw(this.getView().drawingToView(this.createdFigure.getBounds()));
        }
    }

    protected void beginEdit(TextHolderFigure textHolderFigure) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolderFigure != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolderFigure);
        this.textArea.setBounds(this.getFieldBounds(textHolderFigure), textHolderFigure.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolderFigure;
    }

    private Rectangle2D.Double getFieldBounds(TextHolderFigure textHolderFigure) {
        Rectangle2D.Double double_ = textHolderFigure.getDrawingArea();
        Insets2D.Double double_2 = textHolderFigure.getInsets();
        double_2.subtractTo(double_);
        double_.x -= 1.0;
        double_.y -= 2.0;
        double_.width += 18.0;
        double_.height += 4.0;
        return double_;
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure textHolderFigure = this.typingTarget;
            final String string = this.typingTarget.getText();
            final String string2 = this.textArea.getText();
            if (string2.length() > 0) {
                this.typingTarget.setText(string2);
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string);
                    textHolderFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string2);
                    textHolderFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(abstractUndoableEdit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.endEdit();
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }
}

