/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallWithArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirComponentCallImpl;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.TypeConstraint;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a,\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0086\b\u001a/\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0014\u001a\n\u0010\u001f\u001a\u00020\u0002*\u00020\u001e\u001a\n\u0010 \u001a\u00020\u0011*\u00020\u0014\u001a\u0018\u0010!\u001a\u00020\"*\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0001\u001a\u0016\u0010&\u001a\u00020'*\u0004\u0018\u00010\u001e2\b\b\u0002\u0010(\u001a\u00020\u001e\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"expressionSet", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "qualifiedAccessTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "getQualifiedAccessTokens", "()Lcom/intellij/psi/tree/TokenSet;", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "isClassLocal", "classNode", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;", "stubMode", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;Ljava/util/List;Z)Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;", "getAsStringWithoutBacktick", "", "getOperationSymbol", "isExpression", "joinTypeParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParametersOwner;", "typeConstraints", "Lorg/jetbrains/kotlin/fir/lightTree/fir/TypeConstraint;", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "lightTree"})
public final class ConverterUtilKt {
    private static final List<IElementType> expressionSet = CollectionsKt.listOf((Object[])new IElementType[]{KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN});
    @NotNull
    private static final TokenSet qualifiedAccessTokens;

    @NotNull
    public static final TokenSet getQualifiedAccessTokens() {
        return qualifiedAccessTokens;
    }

    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkParameterIsNotNull((Object)defaultName, (String)"defaultName");
        if ($this$nameAsSafeName != null) {
            Name name2 = Name.identifier(StringsKt.replace$default((String)$this$nameAsSafeName, (String)"`", (String)"", (boolean)false, (int)4, null));
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(this.replace(\"`\", \"\"))");
        } else {
            CharSequence charSequence = defaultName;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Name name3 = Name.identifier(defaultName);
                name = name3;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(defaultName)");
            } else {
                Name name4 = SpecialNames.NO_NAME_PROVIDED;
                name = name4;
                Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"SpecialNames.NO_NAME_PROVIDED");
            }
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getOperationSymbol, (String)"$this$getOperationSymbol");
        TokenSet tokenSet = KotlinExpressionParsing.ALL_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KotlinExpressionParsing.ALL_OPERATIONS");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"KotlinExpressionParsing.ALL_OPERATIONS.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            IElementType element$iv;
            IElementType it = element$iv = iElementTypeArray2[i];
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual((Object)((KtSingleValueToken)it).getValue(), (Object)$this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual((Object)$this$getOperationSymbol, (Object)"as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktToken, (String)"KtTokens.AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktToken, (String)"KtTokens.IDENTIFIER");
        return ktToken;
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getAsStringWithoutBacktick, (String)"$this$getAsStringWithoutBacktick");
        return StringsKt.replace$default((String)$this$getAsStringWithoutBacktick.toString(), (String)"`", (String)"", (boolean)false, (int)4, null);
    }

    public static final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isExpression, (String)"$this$isExpression");
        IElementType iElementType = $this$isExpression.getTokenType();
        return iElementType instanceof KtNodeType || iElementType instanceof KtConstantExpressionElementType || iElementType instanceof KtStringTemplateExpressionElementType || expressionSet.contains(iElementType);
    }

    public static final void joinTypeParameters(@NotNull FirTypeParametersOwner $this$joinTypeParameters, @NotNull List<TypeConstraint> typeConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)$this$joinTypeParameters, (String)"$this$joinTypeParameters");
        Intrinsics.checkParameterIsNotNull(typeConstraints, (String)"typeConstraints");
        Iterable $this$forEach$iv = typeConstraints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeConstraint typeConstraint = (TypeConstraint)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$joinTypeParameters.getTypeParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FirTypeParameter typeParameter = (FirTypeParameter)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)typeConstraint.getIdentifier(), (Object)typeParameter.getName().getIdentifier())) {
                    FirTypeParameter firTypeParameter = typeParameter;
                    if (firTypeParameter == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl");
                    }
                    Collection collection = ((FirTypeParameterImpl)firTypeParameter).getBounds();
                    Object object = typeConstraint.getFirTypeRef();
                    boolean bl3 = false;
                    collection.add(object);
                    collection = ((FirTypeParameterImpl)typeParameter).getAnnotations();
                    object = typeConstraint.getAnnotations();
                    bl3 = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)object);
                }
                FirTypeParameter firTypeParameter = typeParameter;
                if (firTypeParameter == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl");
                }
                FirDeclarationUtilKt.addDefaultBoundIfNecessary((FirTypeParameterImpl)firTypeParameter);
            }
        }
    }

    @NotNull
    public static final <T extends FirCallWithArgumentList> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container, boolean stubMode) {
        Intrinsics.checkParameterIsNotNull($this$extractArgumentsFrom, (String)"$this$extractArgumentsFrom");
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        if (!stubMode || $this$extractArgumentsFrom instanceof FirAnnotationCall) {
            Collection collection = $this$extractArgumentsFrom.getArguments();
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)container);
        }
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        int $i$f$isClassLocal = 0;
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        Intrinsics.checkParameterIsNotNull(getParent, (String)"getParent");
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode parent2 = (LighterASTNode)getParent.invoke((Object)currentNode);
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.PROPERTY) || Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode = parent2;
                LighterASTNode grandParent = lighterASTNode != null ? (LighterASTNode)getParent.invoke((Object)lighterASTNode) : null;
                LighterASTNode lighterASTNode2 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)KtNodeTypes.KT_FILE)) {
                    return true;
                }
                LighterASTNode lighterASTNode3 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null), (Object)KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (!Intrinsics.areEqual((Object)(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null), (Object)KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode4 = grandParent) != null && (lighterASTNode4 = (LighterASTNode)getParent.invoke((Object)lighterASTNode4)) != null ? lighterASTNode4.getTokenType() : null, (Object)KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                LighterASTNode lighterASTNode6 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null), (Object)KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode7 = grandParent;
                    if (Intrinsics.areEqual((Object)(lighterASTNode7 != null ? lighterASTNode7.getTokenType() : null), (Object)KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        FirBlockImpl firBlockImpl = new FirBlockImpl(null);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        if (tmpVariable) {
            Collection collection = $this$apply.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl4 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl5 = false;
        for (FirVariable entry : (Iterable)multiDeclaration.getEntries()) {
            void index2;
            Collection collection = $this$apply.getStatements();
            FirTypeRef firTypeRef = entry.getReturnTypeRef();
            Name name = entry.getName();
            FirExpression firExpression2 = new FirComponentCallImpl(null, ConversionUtilsKt.generateResolvedAccessExpression(null, container), (int)(index2 + true));
            FirPropertySymbol firPropertySymbol = new FirPropertySymbol(new CallableId(entry.getName()), false, null, 6, null);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.LOCAL");
            FirPropertyImpl firPropertyImpl = new FirPropertyImpl(null, session, firTypeRef, null, name, firExpression2, null, isVar, firPropertySymbol, true, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            boolean bl6 = false;
            boolean bl7 = false;
            FirPropertyImpl $this$apply2 = firPropertyImpl;
            boolean bl8 = false;
            Collection collection2 = $this$apply2.getAnnotations();
            Iterable iterable = entry.getAnnotations();
            boolean bl9 = false;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
            $this$apply2.getSymbol().bind((FirSymbolOwner)$this$apply2);
            bl6 = false;
            collection.add(firPropertyImpl);
            ++index2;
        }
        return firBlockImpl;
    }

    static {
        TokenSet tokenSet = TokenSet.create(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        qualifiedAccessTokens = tokenSet;
    }
}

