/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.PropertiesMembershipChoiceDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class UnGlueAction
extends JosmAction {
    private transient Node selectedNode;
    private transient Way selectedWay;
    private transient Set<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways", new Object[0]), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways.", new Object[0]), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways", new Object[0])), 71, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.unglue(e);
        }
        catch (UserCancelException ignore) {
            Logging.trace(ignore);
        }
        finally {
            this.cleanup();
        }
    }

    protected void unglue(ActionEvent e) throws UserCancelException {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        String errMsg = null;
        int errorTime = Notification.TIME_DEFAULT;
        if (this.checkSelectionOneNodeAtMostOneWay(selection)) {
            this.checkAndConfirmOutlyingUnglue();
            int count = 0;
            for (Way w : this.selectedNode.getParentWays()) {
                if (!w.isUsable() || w.getNodesCount() < 1) continue;
                ++count;
            }
            if (count < 2) {
                boolean selfCrossing = false;
                if (count == 1) {
                    selfCrossing = this.unglueSelfCrossingWay();
                }
                if (!selfCrossing) {
                    if (this.checkForUnglueNode(selection)) {
                        this.unglueOneNodeAtMostOneWay(e);
                    } else {
                        errorTime = Notification.TIME_SHORT;
                        errMsg = I18n.tr("This node is not glued to anything else.", new Object[0]);
                    }
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelectionOneWayAnyNodes(selection)) {
            this.checkAndConfirmOutlyingUnglue();
            HashSet<Node> tmpNodes = new HashSet<Node>();
            for (Node n : this.selectedNodes) {
                int count = 0;
                for (Way w : n.getParentWays()) {
                    if (!w.isUsable()) continue;
                    ++count;
                }
                if (count < 2) continue;
                tmpNodes.add(n);
            }
            if (tmpNodes.isEmpty()) {
                errMsg = selection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.", new Object[0]) : I18n.tr("None of this way''s nodes are glued to anything else.", new Object[0]);
            } else {
                this.selectedNodes = tmpNodes;
                this.unglueOneWayAnyNodes();
            }
        } else {
            errorTime = Notification.TIME_VERY_LONG;
            errMsg = I18n.tr("The current selection cannot be used for unglueing.", new Object[0]) + '\n' + '\n' + I18n.tr("Select either:", new Object[0]) + '\n' + I18n.tr("* One tagged node, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way and one of those ways, or", new Object[0]) + '\n' + I18n.tr("* One way that has one or more nodes that are used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One way and one or more of its nodes that are used by more than one way.", new Object[0]) + '\n' + '\n' + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.", new Object[0]);
        }
        if (errMsg != null) {
            new Notification(errMsg).setIcon(0).setDuration(errorTime).show();
        }
    }

    private void cleanup() {
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    static void update(PropertiesMembershipChoiceDialog dialog, Node existingNode, List<Node> newNodes, Collection<Command> cmds) {
        UnGlueAction.updateMemberships(dialog.getMemberships().orElse(null), existingNode, newNodes, cmds);
        UnGlueAction.updateProperties(dialog.getTags().orElse(null), existingNode, newNodes, cmds);
    }

    private static void updateProperties(PropertiesMembershipChoiceDialog.ExistingBothNew tags, Node existingNode, Iterable<Node> newNodes, Collection<Command> cmds) {
        if (PropertiesMembershipChoiceDialog.ExistingBothNew.NEW == tags) {
            Node newSelectedNode = new Node(existingNode);
            newSelectedNode.removeAll();
            cmds.add(new ChangeCommand(existingNode, newSelectedNode));
        } else if (PropertiesMembershipChoiceDialog.ExistingBothNew.OLD == tags) {
            for (Node newNode : newNodes) {
                newNode.removeAll();
            }
        }
    }

    private void unglueOneNodeAtMostOneWay(ActionEvent e) {
        PropertiesMembershipChoiceDialog dialog;
        try {
            dialog = PropertiesMembershipChoiceDialog.showIfNecessary(Collections.singleton(this.selectedNode), true);
        }
        catch (UserCancelException ex) {
            Logging.trace(ex);
            return;
        }
        Node unglued = new Node(this.selectedNode, true);
        boolean moveSelectedNode = false;
        LinkedList<Command> cmds = new LinkedList<Command>();
        cmds.add(new AddCommand(this.selectedNode.getDataSet(), unglued));
        if (dialog != null && PropertiesMembershipChoiceDialog.ExistingBothNew.NEW == dialog.getTags().orElse(null)) {
            Way way = this.selectedNode.getParentWays().get(0);
            List<Node> newWayNodes = way.getNodes();
            newWayNodes.replaceAll(n -> this.selectedNode.equals(n) ? unglued : n);
            cmds.add(new ChangeNodesCommand(way, newWayNodes));
            UnGlueAction.updateMemberships(dialog.getMemberships().map(PropertiesMembershipChoiceDialog.ExistingBothNew::opposite).orElse(null), this.selectedNode, Collections.singletonList(unglued), cmds);
            UnGlueAction.updateProperties(dialog.getTags().map(PropertiesMembershipChoiceDialog.ExistingBothNew::opposite).orElse(null), this.selectedNode, Collections.singletonList(unglued), cmds);
            moveSelectedNode = true;
        } else if (dialog != null) {
            UnGlueAction.update(dialog, this.selectedNode, Collections.singletonList(unglued), cmds);
        }
        MapView mv = MainApplication.getMap().mapView;
        if (e.getSource() instanceof JPanel) {
            LatLon latLon = mv.getLatLon(mv.lastMEvent.getX(), mv.lastMEvent.getY());
            if (moveSelectedNode) {
                cmds.add(new MoveCommand(this.selectedNode, latLon));
            } else {
                unglued.setCoor(latLon);
            }
        }
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Unglued Node", new Object[0]), cmds));
        this.getLayerManager().getEditDataSet().setSelected(moveSelectedNode ? this.selectedNode : unglued);
        mv.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() != 1) {
            return false;
        }
        OsmPrimitive n = (OsmPrimitive)selection.toArray()[0];
        if (!(n instanceof Node)) {
            return false;
        }
        if (((Node)n).getParentWays().isEmpty()) {
            return false;
        }
        this.selectedNode = (Node)n;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelectionOneNodeAtMostOneWay(Collection<? extends OsmPrimitive> selection) {
        int size = selection.size();
        if (size < 1 || size > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (size != 1 && this.selectedWay == null) continue;
                return size == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (size != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelectionOneWayAnyNodes(Collection<? extends OsmPrimitive> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node n = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(n)) {
                return false;
            }
            this.selectedNodes.add(n);
        }
        if (this.selectedNodes.isEmpty()) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private static Way modifyWay(Node originalNode, Way w, List<Command> cmds, List<Node> newNodes) {
        Node newNode = new Node(originalNode, true);
        newNodes.add(newNode);
        cmds.add(new AddCommand(originalNode.getDataSet(), newNode));
        ArrayList<Node> nn = new ArrayList<Node>();
        for (Node pushNode : w.getNodes()) {
            if (originalNode == pushNode) {
                pushNode = newNode;
            }
            nn.add(pushNode);
        }
        Way newWay = new Way(w);
        newWay.setNodes((List<Node>)nn);
        return newWay;
    }

    private static void updateMemberships(PropertiesMembershipChoiceDialog.ExistingBothNew memberships, Node originalNode, List<Node> newNodes, Collection<Command> cmds) {
        if (memberships == null || PropertiesMembershipChoiceDialog.ExistingBothNew.OLD == memberships) {
            return;
        }
        for (Relation r : OsmPrimitive.getParentRelations(Collections.singleton(originalNode))) {
            if (r.isDeleted()) continue;
            Relation newRel = null;
            HashMap<String, Integer> rolesToReAdd = null;
            int i = 0;
            for (RelationMember relationMember : r.getMembers()) {
                if (relationMember.isNode() && relationMember.getMember() == originalNode) {
                    if (newRel == null) {
                        newRel = new Relation(r);
                        rolesToReAdd = new HashMap<String, Integer>();
                    }
                    if (rolesToReAdd != null) {
                        rolesToReAdd.put(relationMember.getRole(), i);
                    }
                }
                ++i;
            }
            if (newRel == null) continue;
            if (rolesToReAdd != null) {
                for (Map.Entry entry : rolesToReAdd.entrySet()) {
                    for (Node n : newNodes) {
                        newRel.addMember((Integer)entry.getValue() + 1, new RelationMember((String)entry.getKey(), n));
                    }
                    if (PropertiesMembershipChoiceDialog.ExistingBothNew.NEW != memberships) continue;
                    newRel.removeMember((Integer)entry.getValue());
                }
            }
            cmds.add(new ChangeCommand(r, newRel));
        }
    }

    private void unglueWays() {
        PropertiesMembershipChoiceDialog dialog;
        try {
            dialog = PropertiesMembershipChoiceDialog.showIfNecessary(Collections.singleton(this.selectedNode), false);
        }
        catch (UserCancelException e) {
            Logging.trace(e);
            return;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> newNodes = new LinkedList<Node>();
        if (this.selectedWay == null) {
            Way wayWithSelectedNode = null;
            LinkedList<Way> parentWays = new LinkedList<Way>();
            for (OsmPrimitive osm : this.selectedNode.getReferrers()) {
                if (!osm.isUsable() || !(osm instanceof Way)) continue;
                Way w = (Way)osm;
                if (wayWithSelectedNode == null && !w.isFirstLastNode(this.selectedNode)) {
                    wayWithSelectedNode = w;
                    continue;
                }
                parentWays.add(w);
            }
            if (wayWithSelectedNode == null) {
                parentWays.removeFirst();
            }
            for (Way w : parentWays) {
                cmds.add(new ChangeCommand(w, UnGlueAction.modifyWay(this.selectedNode, w, cmds, newNodes)));
            }
            this.notifyWayPartOfRelation(parentWays);
        } else {
            cmds.add(new ChangeCommand(this.selectedWay, UnGlueAction.modifyWay(this.selectedNode, this.selectedWay, cmds, newNodes)));
            this.notifyWayPartOfRelation(Collections.singleton(this.selectedWay));
        }
        if (dialog != null) {
            UnGlueAction.update(dialog, this.selectedNode, newNodes, cmds);
        }
        this.execCommands(cmds, newNodes);
    }

    private void execCommands(List<Command> cmds, List<Node> newNodes) {
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.trn("Dupe into {0} node", "Dupe into {0} nodes", (long)newNodes.size() + 1L, (long)newNodes.size() + 1L), cmds));
        this.getLayerManager().getEditDataSet().setSelected(newNodes.get(0));
    }

    private boolean unglueSelfCrossingWay() {
        Way way = null;
        for (Way w : this.selectedNode.getParentWays()) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            way = w;
        }
        if (way == null) {
            return false;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        List<Node> oldNodes = way.getNodes();
        ArrayList<Node> newNodes = new ArrayList<Node>(oldNodes.size());
        ArrayList<Node> addNodes = new ArrayList<Node>();
        boolean seen = false;
        for (Node n : oldNodes) {
            if (n == this.selectedNode) {
                if (seen) {
                    Node newNode = new Node(n, true);
                    cmds.add(new AddCommand(this.selectedNode.getDataSet(), newNode));
                    newNodes.add(newNode);
                    addNodes.add(newNode);
                    continue;
                }
                newNodes.add(n);
                seen = true;
                continue;
            }
            newNodes.add(n);
        }
        if (addNodes.isEmpty()) {
            return false;
        }
        cmds.add(new ChangeNodesCommand(way, newNodes));
        this.notifyWayPartOfRelation(Collections.singleton(way));
        try {
            PropertiesMembershipChoiceDialog dialog = PropertiesMembershipChoiceDialog.showIfNecessary(Collections.singleton(this.selectedNode), false);
            if (dialog != null) {
                UnGlueAction.update(dialog, this.selectedNode, addNodes, cmds);
            }
            this.execCommands(cmds, addNodes);
            return true;
        }
        catch (UserCancelException ignore) {
            Logging.trace(ignore);
            return false;
        }
    }

    private void unglueOneWayAnyNodes() {
        PropertiesMembershipChoiceDialog dialog;
        Way tmpWay = this.selectedWay;
        try {
            dialog = PropertiesMembershipChoiceDialog.showIfNecessary(this.selectedNodes, false);
        }
        catch (UserCancelException e) {
            Logging.trace(e);
            return;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> allNewNodes = new LinkedList<Node>();
        for (Node n : this.selectedNodes) {
            LinkedList<Node> newNodes = new LinkedList<Node>();
            tmpWay = UnGlueAction.modifyWay(n, tmpWay, cmds, newNodes);
            if (dialog != null) {
                UnGlueAction.update(dialog, n, newNodes, cmds);
            }
            allNewNodes.addAll(newNodes);
        }
        cmds.add(new ChangeCommand(this.selectedWay, tmpWay));
        this.notifyWayPartOfRelation(Collections.singleton(this.selectedWay));
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), this.selectedNodes.size() + allNewNodes.size()), cmds));
        this.getLayerManager().getEditDataSet().setSelected(allNewNodes);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    protected void checkAndConfirmOutlyingUnglue() throws UserCancelException {
        boolean ok;
        ArrayList<Node> primitives = new ArrayList<Node>(2 + (this.selectedNodes == null ? 0 : this.selectedNodes.size()));
        if (this.selectedNodes != null) {
            primitives.addAll(this.selectedNodes);
        }
        if (this.selectedNode != null) {
            primitives.add(this.selectedNode);
        }
        if (!(ok = UnGlueAction.checkAndConfirmOutlyingOperation("unglue", I18n.tr("Unglue confirmation", new Object[0]), I18n.tr("You are about to unglue nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to unglue?", new Object[0]), I18n.tr("You are about to unglue incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to unglue?", new Object[0]), primitives, null))) {
            throw new UserCancelException();
        }
    }

    protected void notifyWayPartOfRelation(Iterable<Way> ways) {
        HashSet<String> affectedRelations = new HashSet<String>();
        for (Way way : ways) {
            for (OsmPrimitive ref : way.getReferrers()) {
                if (!(ref instanceof Relation) || !ref.isUsable()) continue;
                affectedRelations.add(ref.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        }
        if (affectedRelations.isEmpty()) {
            return;
        }
        String msg1 = I18n.trn("Unglueing affected {0} relation: {1}", "Unglueing affected {0} relations: {1}", affectedRelations.size(), affectedRelations.size(), Utils.joinAsHtmlUnorderedList(affectedRelations));
        String msg2 = I18n.trn("Ensure that the relation has not been broken!", "Ensure that the relations have not been broken!", affectedRelations.size(), new Object[0]);
        new Notification("<html>" + msg1 + msg2).setIcon(2).show();
    }
}

