/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBJarResource;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class CBResourceLoader {
    protected HashSet unknownResources = new HashSet();
    protected CBJarResource[] resourceFiles = null;
    protected static boolean debug = false;
    private static Logger log = Logger.getLogger(CBResourceLoader.class.getName());

    public CBResourceLoader() {
        log.fine("Started CBResourceLoader");
    }

    public void addResource(CBJarResource resource) {
        int size = this.resourceFiles == null ? 0 : this.resourceFiles.length;
        CBJarResource[] newArray = new CBJarResource[size + 1];
        for (int i = 0; i < size; ++i) {
            newArray[i] = this.resourceFiles[i];
        }
        newArray[size] = resource;
        this.resourceFiles = newArray;
        log.fine("Added CBJarResource: " + resource.toString());
    }

    public InputStream getInputStream(String resourceName) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(resourceName);
        if (resourceFile != null) {
            return resourceFile.getInputStream(resourceName);
        }
        throw new ZipException("File: '" + resourceName + "' not found");
    }

    public Image getImage(String imageName, Toolkit imageCreator) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(imageName);
        if (resourceFile != null) {
            return resourceFile.getImage(imageName, imageCreator);
        }
        throw new ZipException("Image File: '" + imageName + "' not found");
    }

    public byte[] getResource(String resourceName) throws ZipException {
        log.finer("  $$ getting resource '" + resourceName + "' from CBResourceLoader");
        CBJarResource resourceFile = this.getJarContainingResource(resourceName);
        if (resourceFile != null) {
            log.finer("  $$ found resource '" + resourceName + "' in zip file '" + resourceFile.getZipFileName() + "' - extracting");
            return resourceFile.getResource(resourceName);
        }
        throw new ZipException("File: '" + resourceName + "' not found");
    }

    public long getLastModified(String resourceName) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(resourceName);
        if (resourceFile != null) {
            return resourceFile.getLastModified();
        }
        throw new ZipException("File: '" + resourceName + "' not found");
    }

    public CBJarResource getJarContainingResource(String resourceName) {
        if (this.resourceFiles == null) {
            return null;
        }
        if (this.unknownResources.contains(resourceName)) {
            return null;
        }
        for (int i = 0; i < this.resourceFiles.length; ++i) {
            if (!this.resourceFiles[i].hasResource(resourceName)) continue;
            return this.resourceFiles[i];
        }
        this.unknownResources.add(resourceName);
        return null;
    }

    public String[] getPrefixedResources(String prefix) {
        if (this.resourceFiles == null) {
            return new String[0];
        }
        Vector<String> resources = new Vector<String>();
        for (int i = 0; i < this.resourceFiles.length; ++i) {
            resources.addAll(Arrays.asList(this.resourceFiles[i].getPrefixedResources(prefix)));
        }
        if (resources.size() == 0) {
            return new String[0];
        }
        return resources.toArray(new String[resources.size()]);
    }
}

