/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.ProjectOpenedHookImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.configurations.ProjectProfileHandlerImpl;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.debug.MavenJPDAStart;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.queries.PomCompilerOptionsQueryImpl;
import org.netbeans.modules.maven.queries.UnitTestsCompilerOptionsQueryImpl;
import org.netbeans.modules.maven.spi.nodes.OtherSourcesExclude;
import org.netbeans.modules.maven.spi.queries.JavaLikeRootProvider;
import org.netbeans.spi.java.project.support.LookupMergerSupport;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NbMavenProjectImpl
implements Project {
    private static final Logger LOG = Logger.getLogger(NbMavenProjectImpl.class.getName());
    public static final RequestProcessor RELOAD_RP = new RequestProcessor("Maven project reloading", 1);
    private final RequestProcessor.Task reloadTask = RELOAD_RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NbMavenProjectImpl.this.problemReporter.clearReports();
            MavenProject prj = NbMavenProjectImpl.this.loadOriginalMavenProject(true);
            NbMavenProjectImpl nbMavenProjectImpl = NbMavenProjectImpl.this;
            synchronized (nbMavenProjectImpl) {
                MavenProject old;
                MavenProject mavenProject = old = NbMavenProjectImpl.this.project == null ? null : (MavenProject)NbMavenProjectImpl.this.project.get();
                if (old != null && MavenProjectCache.isFallbackproject(prj)) {
                    prj.setPackaging(old.getPackaging());
                }
                NbMavenProjectImpl.this.project = new SoftReference<MavenProject>(prj);
                if (NbMavenProjectImpl.this.hardReferencingMavenProject) {
                    NbMavenProjectImpl.this.hardRefProject = prj;
                }
            }
            ACCESSOR.doFireReload(NbMavenProjectImpl.this.watcher);
        }
    });
    private final FileObject fileObject;
    private final FileObject folderFileObject;
    private final File projectFile;
    private final Lookup basicLookup;
    private final Lookup completeLookup;
    private final Lookup lookup;
    private final Updater openedProjectUpdater;
    private Reference<MavenProject> project;
    private boolean hardReferencingMavenProject = false;
    private MavenProject hardRefProject;
    private ProblemReporterImpl problemReporter;
    @NonNull
    private final NbMavenProject watcher;
    private final M2ConfigProvider configProvider;
    @NonNull
    private final MavenProjectPropsImpl auxprops;
    private ProjectProfileHandlerImpl profileHandler;
    private CopyResourcesOnSave copyResourcesOnSave;
    private final Object COPYRESOURCES_LOCK = new Object();
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static WatcherAccessor ACCESSOR = null;
    private ProjectOpenedHookImpl hookImpl;
    private Exception ex;
    private final Object LOCK_224012 = new Object();
    private final Object MODEL_LOCK = new Object();
    private Model model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setIssue224012(ProjectOpenedHookImpl hook, Exception exception) {
        Object object = this.LOCK_224012;
        synchronized (object) {
            if (this.hookImpl == null) {
                this.hookImpl = hook;
                this.ex = exception;
                return true;
            }
            LOG.log(Level.INFO, "    first creation stacktrace", this.ex);
            LOG.log(Level.INFO, "    second creation stacktrace", exception);
            LOG.log(Level.WARNING, "Spotted issue 224012 (https://netbeans.org/bugzilla/show_bug.cgi?id=224012). Please report the incident wth IDE log attached.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getRawModel() throws ModelBuildingException {
        Object object = this.MODEL_LOCK;
        synchronized (object) {
            if (this.model == null) {
                MavenEmbedder projectEmbedder = EmbedderFactory.getProjectEmbedder();
                ModelBuildingResult br = projectEmbedder.executeModelBuilder(this.getPOMFile());
                this.model = br.getRawModel();
            }
            return this.model;
        }
    }

    NbMavenProjectImpl(FileObject folder, FileObject projectFO, ProjectState projectState) {
        this.projectFile = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectFO));
        this.fileObject = projectFO;
        this.folderFileObject = folder;
        this.lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                if (NbMavenProjectImpl.this.completeLookup == null) {
                    LOG.log(Level.FINE, "accessing project's lookup before the instance is fully initialized at " + NbMavenProjectImpl.this.projectFile, new Exception());
                    assert (NbMavenProjectImpl.this.basicLookup != null);
                    return NbMavenProjectImpl.this.basicLookup;
                }
                return NbMavenProjectImpl.this.completeLookup;
            }
        });
        this.watcher = ACCESSOR.createWatcher(this);
        this.openedProjectUpdater = new Updater(new FileProvider(){

            @Override
            public File[] getFiles() {
                File homeFile = FileUtil.normalizeFile((File)MavenCli.USER_MAVEN_CONFIGURATION_HOME);
                return new File[]{new File(NbMavenProjectImpl.this.projectFile.getParentFile(), "nb-configuration.xml"), NbMavenProjectImpl.this.projectFile, new File(new File(NbMavenProjectImpl.this.projectFile.getParentFile(), ".mvn"), "maven.config"), new File(homeFile, "settings.xml")};
            }
        });
        this.problemReporter = new ProblemReporterImpl(this);
        M2AuxilaryConfigImpl auxiliary = new M2AuxilaryConfigImpl(folder, true);
        this.auxprops = new MavenProjectPropsImpl(auxiliary, this);
        this.profileHandler = new ProjectProfileHandlerImpl(this, auxiliary);
        this.configProvider = new M2ConfigProvider(this, auxiliary, this.profileHandler);
        this.basicLookup = this.createBasicLookup(projectState, auxiliary);
        this.completeLookup = LookupProviderSupport.createCompositeLookup((Lookup)this.basicLookup, (Lookup)new PackagingTypeDependentLookup(this.watcher));
    }

    public File getPOMFile() {
        return this.projectFile;
    }

    @NonNull
    public NbMavenProject getProjectWatcher() {
        return this.watcher;
    }

    public ProblemReporterImpl getProblemReporter() {
        return this.problemReporter;
    }

    public String getHintJavaPlatform() {
        String hint = this.getAuxProps().get("netbeans.hint.jdkPlatform", true);
        if (hint == null) {
            hint = MavenSettings.getDefault().getDefaultJdk();
        }
        return hint == null || hint.isEmpty() ? null : hint;
    }

    @NonNull
    public MavenProject loadMavenProject(MavenEmbedder embedder, List<String> activeProfiles, Properties properties) {
        try {
            MavenExecutionRequest req = embedder.createMavenExecutionRequest();
            req.addActiveProfiles(activeProfiles);
            req.setPom(this.projectFile);
            req.setNoSnapshotUpdates(true);
            req.setUpdateSnapshots(false);
            if (properties != null) {
                Properties uprops = req.getUserProperties();
                uprops.putAll((Map<?, ?>)properties);
                req.setUserProperties(uprops);
            }
            req.setInteractiveMode(false);
            req.setOffline(true);
            req.setRecursive(false);
            MavenExecutionResult res = embedder.readProjectWithDependencies(req, true);
            if (!res.hasExceptions()) {
                res.getProject().setProjectBuildingRequest(null);
                return res.getProject();
            }
            List exc = res.getExceptions();
            for (Throwable ex : exc) {
                LOG.log(Level.FINE, "Exception thrown while loading maven project at " + this.getProjectDirectory(), ex);
            }
        }
        catch (RuntimeException exc) {
            LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), exc);
        }
        return MavenProjectCache.getFallbackProject(this.getPOMFile());
    }

    public MavenProject loadParentOf(MavenEmbedder embedder, MavenProject project) throws ProjectBuildingException {
        MavenProject parent = null;
        ProjectBuilder builder = (ProjectBuilder)embedder.lookupComponent(ProjectBuilder.class);
        MavenExecutionRequest req = embedder.createMavenExecutionRequest();
        M2Configuration active = this.configProvider.getActiveConfiguration();
        req.addActiveProfiles(active.getActivatedProfiles());
        req.setNoSnapshotUpdates(true);
        req.setUpdateSnapshots(false);
        req.setInteractiveMode(false);
        req.setRecursive(false);
        req.setOffline(true);
        Properties uprops = req.getUserProperties();
        uprops.putAll((Map<?, ?>)MavenProjectCache.createUserPropsForProjectLoading(active.getProperties()));
        req.setUserProperties(uprops);
        ProjectBuildingRequest request = req.getProjectBuildingRequest();
        request.setRemoteRepositories(project.getRemoteArtifactRepositories());
        DefaultMaven maven = (DefaultMaven)embedder.lookupComponent(Maven.class);
        request.setRepositorySession(maven.newRepositorySession(req));
        if (project.getParentFile() != null) {
            parent = builder.build(project.getParentFile(), request).getProject();
        } else if (project.getModel().getParent() != null) {
            parent = builder.build(project.getParentArtifact(), request).getProject();
        }
        if (parent != null) {
            parent.setProjectBuildingRequest(null);
        }
        MavenEmbedder.normalizePaths((MavenProject)parent);
        return parent;
    }

    public List<String> getCurrentActiveProfiles() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.addAll(this.configProvider.getActiveConfiguration().getActivatedProfiles());
        return toRet;
    }

    public Map<? extends String, ? extends String> createSystemPropsForPropertyExpressions() {
        Map props = NbCollections.checkedMapByCopy((Map)EmbedderFactory.getProjectEmbedder().getSystemProperties(), String.class, String.class, (boolean)true);
        ActiveJ2SEPlatformProvider platformProvider = (ActiveJ2SEPlatformProvider)this.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
        if (platformProvider != null) {
            props.putAll(platformProvider.getJavaPlatform().getSystemProperties());
        }
        return props;
    }

    public Map<? extends String, ? extends String> createUserPropsForPropertyExpressions() {
        return NbCollections.checkedMapByCopy(this.configProvider.getActiveConfiguration().getProperties(), String.class, String.class, (boolean)true);
    }

    @NonNull
    public synchronized MavenProject getOriginalMavenProject() {
        MavenProject mp;
        MavenProject mavenProject = mp = this.project == null ? null : this.project.get();
        if (mp == null) {
            mp = this.loadOriginalMavenProject(false);
            this.project = new SoftReference<MavenProject>(mp);
            if (this.hardReferencingMavenProject) {
                this.hardRefProject = mp;
            }
        }
        return mp;
    }

    public boolean isMavenProjectLoaded() {
        Reference<MavenProject> prj = this.project;
        if (prj != null) {
            return prj.get() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startHardReferencingMavenPoject() {
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            MavenProject mp;
            this.hardReferencingMavenProject = true;
            this.hardRefProject = mp = this.project == null ? null : this.project.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopHardReferencingMavenPoject() {
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            this.hardReferencingMavenProject = false;
            this.hardRefProject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private MavenProject loadOriginalMavenProject(boolean reload) {
        MavenProject newproject;
        try {
            Object object = this.MODEL_LOCK;
            synchronized (object) {
                this.model = null;
            }
            newproject = MavenProjectCache.getMavenProject(this.getPOMFile(), reload);
            if (newproject == null) {
                newproject = MavenProjectCache.getFallbackProject(this.projectFile);
            }
            MavenExecutionResult res = MavenProjectCache.getExecutionResult(newproject);
            MavenProject mavenProject = newproject;
        }
        finally {
            if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                LOG.log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
            }
        }
        assert (newproject != null);
        return newproject;
    }

    public RequestProcessor.Task fireProjectReload() {
        if (Boolean.getBoolean("test.reload.sync")) {
            this.reloadTask.run();
        } else {
            this.reloadTask.schedule(0);
        }
        return this.reloadTask;
    }

    public static void refreshLocalRepository(NbMavenProjectImpl project) {
        File file = project.getEmbedder().getLocalRepositoryFile();
        FileUtil.refreshFor((File[])new File[]{file});
    }

    void attachUpdater() {
        this.openedProjectUpdater.attachAll();
    }

    void detachUpdater() {
        this.openedProjectUpdater.detachAll();
    }

    public FileObject getProjectDirectory() {
        return this.folderFileObject;
    }

    @CheckForNull
    public String getArtifactRelativeRepositoryPath() {
        Artifact artifact = this.getOriginalMavenProject().getArtifact();
        if (artifact == null) {
            return null;
        }
        return this.getArtifactRelativeRepositoryPath(artifact);
    }

    @CheckForNull
    public String getTestArtifactRelativeRepositoryPath() {
        Artifact main = this.getOriginalMavenProject().getArtifact();
        if (main == null) {
            return null;
        }
        ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)this.getEmbedder().lookupComponent(ArtifactHandlerManager.class);
        assert (artifactHandlerManager != null) : "ArtifactHandlerManager component not found in maven";
        DefaultArtifact test = new DefaultArtifact(main.getGroupId(), main.getArtifactId(), main.getVersionRange(), "test", "test-jar", "tests", artifactHandlerManager.getArtifactHandler("test-jar"));
        return this.getArtifactRelativeRepositoryPath((Artifact)test);
    }

    public String getArtifactRelativeRepositoryPath(@NonNull Artifact artifact) {
        return this.getEmbedder().getLocalRepository().pathOf(artifact);
    }

    public MavenEmbedder getEmbedder() {
        return EmbedderFactory.getProjectEmbedder();
    }

    @NonNull
    public MavenProjectPropsImpl getAuxProps() {
        return this.auxprops;
    }

    public URI[] getSourceRoots(boolean test) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String root : test ? this.getOriginalMavenProject().getTestCompileSourceRoots() : this.getOriginalMavenProject().getCompileSourceRoots()) {
            uris.add(FileUtilities.convertStringToUri(root));
        }
        for (JavaLikeRootProvider rp : this.getLookup().lookupAll(JavaLikeRootProvider.class)) {
            FileObject root = this.getProjectDirectory().getFileObject("src/" + (test ? "test" : "main") + "/" + rp.kind());
            if (root == null || !root.isFolder()) continue;
            uris.add(root.toURI());
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public URI[] getGeneratedSourceRoots(boolean test) {
        File[] kids;
        HashSet<URI> BHTestUris = new HashSet<URI>();
        String[] buildHelpers = PluginPropertyUtils.getPluginPropertyList(this, "org.codehaus.mojo", "build-helper-maven-plugin", "sources", "source", "add-test-source");
        if (buildHelpers != null && buildHelpers.length > 0) {
            File root = FileUtil.toFile((FileObject)this.getProjectDirectory());
            for (String helper : buildHelpers) {
                BHTestUris.add(FileUtilities.getDirURI(root, helper));
            }
        }
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "target/generated-test-sources" : "target/generated-sources");
        HashSet<URI> uris = new HashSet<URI>();
        File[] roots = Utilities.toFile((URI)uri).listFiles();
        if (roots != null) {
            File[] fileArray = roots;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File root = fileArray[i];
                if (!VisibilityQuery.getDefault().isVisible(root) || !test && root.getName().startsWith("test-")) continue;
                kids = root.listFiles();
                URI u = Utilities.toURI((File)root);
                if (!test && BHTestUris.contains(u)) continue;
                if (kids != null && kids.length > 0) {
                    uris.add(u);
                    continue;
                }
                this.watcher.addWatchedPath(u);
            }
        }
        if (test && (roots = Utilities.toFile((URI)FileUtilities.getDirURI(this.getProjectDirectory(), "target/generated-sources")).listFiles()) != null) {
            for (File root : roots) {
                if (!VisibilityQuery.getDefault().isVisible(root) || !root.getName().startsWith("test-")) continue;
                kids = root.listFiles();
                if (kids != null && kids.length > 0) {
                    uris.add(Utilities.toURI((File)root));
                    continue;
                }
                this.watcher.addWatchedPath(Utilities.toURI((File)root));
            }
        }
        if (!test) {
            buildHelpers = PluginPropertyUtils.getPluginPropertyList(this, "org.codehaus.mojo", "build-helper-maven-plugin", "sources", "source", "add-source");
            if (buildHelpers != null && buildHelpers.length > 0) {
                File root = FileUtil.toFile((FileObject)this.getProjectDirectory());
                for (String helper : buildHelpers) {
                    uris.add(FileUtilities.getDirURI(root, helper));
                }
            }
        } else {
            uris.addAll(BHTestUris);
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public URI getWebAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory", "war", null);
        prop = prop == null ? "src/main/webapp" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getSiteDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-site-plugin", "siteDirectory", "site", null);
        prop = prop == null ? "src/site" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getEarAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory", "ear", null);
        prop = prop == null ? "src/main/application" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI[] getResources(boolean test) {
        ArrayList<URI> toRet = new ArrayList<URI>();
        URI projectroot = this.getProjectDirectory().toURI();
        HashSet<URI> sourceRoots = null;
        List res = test ? this.getOriginalMavenProject().getTestResources() : this.getOriginalMavenProject().getResources();
        block0: for (Resource elem : res) {
            String dir = elem.getDirectory();
            if (dir == null) continue;
            URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), dir);
            if (elem.getTargetPath() != null || !elem.getExcludes().isEmpty() || !elem.getIncludes().isEmpty()) {
                URI rel = projectroot.relativize(uri);
                if (rel.isAbsolute()) continue;
                if (sourceRoots == null) {
                    sourceRoots = new HashSet<URI>();
                    sourceRoots.addAll(Arrays.asList(this.getSourceRoots(true)));
                    sourceRoots.addAll(Arrays.asList(this.getSourceRoots(false)));
                }
                for (URI sr : sourceRoots) {
                    if (uri.relativize(sr).isAbsolute()) continue;
                    continue block0;
                }
            }
            toRet.add(uri);
        }
        return toRet.toArray(new URI[toRet.size()]);
    }

    public File[] getOtherRoots(boolean test) {
        URI[] res;
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "src/test" : "src/main");
        HashSet<File> toRet = new HashSet<File>();
        File fil = Utilities.toFile((URI)uri);
        if (fil.exists()) {
            try {
                Path sourceRoot = fil.toPath();
                OtherRootsVisitor visitor = new OtherRootsVisitor(this.getLookup(), sourceRoot);
                Files.walkFileTree(sourceRoot, visitor);
                toRet.addAll(visitor.getOtherRoots());
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        for (URI rs : res = this.getResources(test)) {
            File fl = Utilities.toFile((URI)rs);
            if (!fl.exists()) continue;
            toRet.add(fl);
        }
        return toRet.toArray(new File[0]);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CopyResourcesOnSave getCopyOnSaveResources() {
        Object object = this.COPYRESOURCES_LOCK;
        synchronized (object) {
            if (this.copyResourcesOnSave == null) {
                this.copyResourcesOnSave = new CopyResourcesOnSave(this.watcher, this);
            }
            return this.copyResourcesOnSave;
        }
    }

    private Lookup createBasicLookup(ProjectState state, M2AuxilaryConfigImpl auxiliary) {
        return Lookups.fixed((Object[])new Object[]{this, this.fileObject, auxiliary, auxiliary.getProblemProvider(), this.auxprops, new MavenProjectPropsImpl.Merger(this.auxprops), this.profileHandler, this.configProvider, this.problemReporter, this.watcher, state, UILookupMergerSupport.createPrivilegedTemplatesMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), UILookupMergerSupport.createProjectProblemsProviderMerger(), LookupProviderSupport.createSourcesMerger(), LookupProviderSupport.createSharabilityQueryMerger(), ProjectClassPathModifier.extenderForModifier((Project)this), LookupMergerSupport.createClassPathModifierMerger(), new UnitTestsCompilerOptionsQueryImpl(this), new PomCompilerOptionsQueryImpl(this), LookupMergerSupport.createCompilerOptionsQueryMerger(), MavenJPDAStart.create(this)});
    }

    public int hashCode() {
        return this.getPOMFile().hashCode() * 13;
    }

    public boolean equals(Object obj) {
        NbMavenProjectImpl impl;
        if (obj instanceof Project && (impl = obj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)obj : (NbMavenProjectImpl)((Project)obj).getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            return this.getPOMFile().equals(impl.getPOMFile());
        }
        return false;
    }

    public String toString() {
        return "Maven[" + this.getPOMFile().getAbsolutePath() + "]";
    }

    static {
        Class<NbMavenProject> c = NbMavenProject.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "very wrong, very wrong, yes indeed", ex);
        }
    }

    private class Updater
    implements FileChangeListener {
        private final FileProvider fileProvider;
        private List<File> filesToWatch;
        private long lastTime = 0L;
        private Map<File, Long> lastMods;

        Updater(FileProvider toWatch) {
            this.fileProvider = toWatch;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            if (this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.lastTime = System.currentTimeMillis();
            NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        synchronized void attachAll() {
            this.filesToWatch = new ArrayList<File>(Arrays.asList(this.fileProvider.getFiles()));
            this.filesToWatch.addAll(this.getParents());
            Collections.sort(this.filesToWatch);
            for (File file : this.filesToWatch) {
                try {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.INFO, "project opened twice in a row, issue #236211 for " + NbMavenProjectImpl.this.projectFile.getAbsolutePath(), ex);
                    Thread.dumpStack();
                    assert (false) : "project opened twice in a row, issue #236211 for " + NbMavenProjectImpl.access$700(NbMavenProjectImpl.this).getAbsolutePath();
                }
            }
            if (this.lastMods == null) {
                this.lastMods = new HashMap<File, Long>(this.filesToWatch.size());
                for (File file : this.filesToWatch) {
                    this.lastMods.put(file, file.lastModified());
                }
            } else {
                for (Map.Entry entry : this.lastMods.entrySet()) {
                    File file = (File)entry.getKey();
                    long ts = file.lastModified();
                    if ((Long)entry.getValue() >= ts) continue;
                    this.lastMods.put(file, ts);
                    NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
                }
            }
        }

        protected List<File> getParents() {
            LinkedList<File> ret = new LinkedList<File>();
            MavenProject project = NbMavenProjectImpl.this.getOriginalMavenProject();
            try {
                while (true) {
                    MavenProject parent;
                    File parentFile;
                    File file = parentFile = (parent = NbMavenProjectImpl.this.loadParentOf(NbMavenProjectImpl.this.getEmbedder(), project)) != null ? parent.getFile() : null;
                    if (parentFile != null) {
                        ret.add(parentFile);
                        project = parent;
                        continue;
                    }
                    break;
                }
            }
            catch (ProjectBuildingException ex) {
            }
            return ret;
        }

        synchronized void detachAll() {
            if (this.filesToWatch != null) {
                List<File> toWatch = this.filesToWatch;
                this.filesToWatch = null;
                for (File file : toWatch) {
                    try {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)file);
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.log(Level.INFO, "project closed twice in a row, issue #236211 for " + NbMavenProjectImpl.this.projectFile.getAbsolutePath(), ex);
                        Thread.dumpStack();
                        assert (false) : "project closed twice in a row, issue #236211 for " + NbMavenProjectImpl.access$700(NbMavenProjectImpl.this).getAbsolutePath();
                    }
                }
            }
        }
    }

    static interface FileProvider {
        public File[] getFiles();
    }

    private static class PackagingTypeDependentLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        private final WeakReference<NbMavenProject> watcherRef;
        private String packaging;
        private final Lookup general;

        PackagingTypeDependentLookup(NbMavenProject watcher) {
            this.watcherRef = new WeakReference<NbMavenProject>(watcher);
            this.general = Lookups.forPath((String)"Projects/org-netbeans-modules-maven/Lookup");
            this.check();
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)watcher));
        }

        private void check() {
            String newPackaging;
            NbMavenProject watcher = (NbMavenProject)this.watcherRef.get();
            String string = newPackaging = this.packaging != null ? this.packaging : "jar";
            if (watcher != null && (newPackaging = watcher.getPackagingType()) == null) {
                newPackaging = "jar";
            }
            if (!newPackaging.equals(this.packaging)) {
                this.packaging = newPackaging;
                Lookup pack = Lookups.forPath((String)("Projects/org-netbeans-modules-maven/" + this.packaging + "/Lookup"));
                this.setLookups(new Lookup[]{this.general, pack});
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.check();
            }
        }
    }

    private static class OtherRootsVisitor
    extends SimpleFileVisitor<Path> {
        private final Lookup lookup;
        private final List<Path> otherRoots;
        private final Path sourceRoot;

        public OtherRootsVisitor(Lookup lookup, Path sourceRoot) {
            this.lookup = lookup;
            this.sourceRoot = sourceRoot;
            this.otherRoots = new ArrayList<Path>();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.sourceRoot.equals(dir)) {
                return FileVisitResult.CONTINUE;
            }
            if (!VisibilityQuery.getDefault().isVisible(dir.toFile())) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            for (Object rp : this.lookup.lookupAll(OtherSourcesExclude.class)) {
                for (Path folder : rp.excludedFolders()) {
                    if (folder.equals(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!folder.startsWith(dir)) continue;
                    return FileVisitResult.CONTINUE;
                }
            }
            for (Object rp : this.lookup.lookupAll(JavaLikeRootProvider.class)) {
                if (!rp.kind().equalsIgnoreCase(dir.getFileName().toString())) continue;
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.isOtherRoot(dir)) {
                this.otherRoots.add(dir);
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isOtherRoot(Path dir) throws IOException {
            if (!dir.toFile().isDirectory() || Files.isHidden(dir)) {
                return false;
            }
            for (Path path : this.otherRoots) {
                if (!dir.startsWith(path)) continue;
                return false;
            }
            return true;
        }

        public List<File> getOtherRoots() {
            ArrayList<File> result = new ArrayList<File>();
            for (Path path : this.otherRoots) {
                result.add(path.toFile());
            }
            return Collections.unmodifiableList(result);
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbMavenProject createWatcher(NbMavenProjectImpl var1);

        public abstract void doFireReload(NbMavenProject var1);
    }
}

