/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class CompileAnnotation
implements OutputListener {
    File clazzfile;
    private int lineNum;
    private final String text;
    private static final RequestProcessor RP = new RequestProcessor(CompileAnnotation.class);

    public CompileAnnotation(File clazz, String line, String textAnn) {
        this.clazzfile = clazz;
        this.text = textAnn;
        try {
            this.lineNum = Integer.parseInt(line);
        }
        catch (NumberFormatException exc) {
            this.lineNum = -1;
        }
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineAction(OutputEvent ev) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{CompileAnnotation.this.clazzfile});
                FileObject file = FileUtil.toFileObject((File)CompileAnnotation.this.clazzfile);
                if (file == null) {
                    CompileAnnotation.this.beep();
                    return;
                }
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    final EditorCookie ed = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                    if (ed != null && file == dob.getPrimaryFile()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block6: {
                                    try {
                                        if (CompileAnnotation.this.lineNum == -1) {
                                            ed.open();
                                            break block6;
                                        }
                                        ed.openDocument();
                                        try {
                                            Line l = ed.getLineSet().getOriginal(CompileAnnotation.this.lineNum - 1);
                                            if (!l.isDeleted()) {
                                                l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
                                            }
                                        }
                                        catch (IndexOutOfBoundsException ioobe) {
                                            ed.open();
                                        }
                                    }
                                    catch (IOException ioe) {
                                        ErrorManager.getDefault().notify((Throwable)ioe);
                                    }
                                }
                            }
                        });
                    } else {
                        CompileAnnotation.this.beep();
                    }
                }
                catch (DataObjectNotFoundException donfe) {
                    ErrorManager.getDefault().notify((Throwable)donfe);
                }
            }
        });
    }

    private void beep() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolkit.getDefaultToolkit().beep();
            }
        });
    }

    public void outputLineCleared(OutputEvent ev) {
    }

    public String toString() {
        return "error[" + this.clazzfile + ":" + this.lineNum + ":" + this.text + "]";
    }
}

