/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.db.nodes;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.DeleteAction;
import org.netbeans.jellytools.actions.PropertiesAction;
import org.netbeans.jellytools.modules.db.actions.ConnectAction;
import org.netbeans.jellytools.modules.db.actions.DisconnectAction;
import org.netbeans.jellytools.modules.db.actions.ExecuteCommandAction;
import org.netbeans.jellytools.modules.db.nodes.DatabasesNode;
import org.netbeans.jellytools.nodes.Node;

public class ConnectionNode
extends Node {
    private static final Action connectAction = new ConnectAction();
    private static final Action disconnectAction = new DisconnectAction();
    private static final Action executeCommandAction = new ExecuteCommandAction();
    private static final Action deleteAction = new DeleteAction();
    private static final Action propertiesAction = new PropertiesAction();

    public ConnectionNode(String url, String user, String schema) {
        super(new RuntimeTabOperator().getRootNode(), DatabasesNode.TREE_PATH + "|" + ConnectionNode.connectionName(url, user, schema));
    }

    public static ConnectionNode invoke(String url, String user, String schema) {
        RuntimeTabOperator.invoke();
        return new ConnectionNode(url, user, schema);
    }

    public void connect() {
        connectAction.perform((Node)this);
    }

    public void disconnect() {
        disconnectAction.perform((Node)this);
    }

    public void executeCommand() {
        executeCommandAction.perform((Node)this);
    }

    public void delete() {
        deleteAction.perform((Node)this);
    }

    public void properties() {
        propertiesAction.perform((Node)this);
    }

    void verifyPopup() {
        this.verifyPopup(new Action[]{connectAction, disconnectAction, executeCommandAction, deleteAction, propertiesAction});
    }

    private static String connectionName(String url, String user, String schema) {
        if (schema == null) {
            schema = Bundle.getStringTrimmed((String)"org.netbeans.modules.db.explorer.Bundle", (String)"SchemaIsNotSet");
        }
        return Bundle.getStringTrimmed((String)"org.netbeans.modules.db.explorer.Bundle", (String)"ConnectionNodeUniqueName", (Object[])new Object[]{url, user, schema});
    }
}

