/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.io.File;
import java.util.MissingResourceException;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelector;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.netbeans.modules.team.spi.TeamBugtrackingConnector;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BugtrackingUtil {
    public static RepositoryImpl createRepository() {
        return BugtrackingUtil.createRepository(true);
    }

    public static RepositoryImpl createRepository(boolean selectNode) {
        RepositorySelector rs = new RepositorySelector();
        RepositoryImpl repo = rs.create(selectNode);
        return repo;
    }

    public static boolean editRepository(RepositoryImpl repository, String errorMessage) {
        RepositorySelector rs = new RepositorySelector();
        return rs.edit(repository, errorMessage);
    }

    public static boolean editRepository(Repository repository) {
        return BugtrackingUtil.editRepository(APIAccessor.IMPL.getImpl(repository), null);
    }

    public static BugtrackingConnector[] getBugtrackingConnectors() {
        DelegatingConnector[] dcs = BugtrackingManager.getInstance().getConnectors();
        BugtrackingConnector[] cons = new BugtrackingConnector[dcs.length];
        for (int i = 0; i < cons.length; ++i) {
            cons[i] = dcs[i].getDelegate();
        }
        return cons;
    }

    public static void savePassword(char[] password, String prefix, String user, String url) throws MissingResourceException {
        if (password != null && password.length != 0) {
            Keyring.save((String)BugtrackingUtil.getPasswordKey(prefix, user, url), (char[])password, (String)NbBundle.getMessage(BugtrackingUtil.class, (String)"password_keyring_description", (Object)url));
        } else {
            Keyring.delete((String)BugtrackingUtil.getPasswordKey(prefix, user, url));
        }
    }

    public static char[] readPassword(String scrambledPassword, String keyPrefix, String user, String url) {
        char[] password = Keyring.read((String)BugtrackingUtil.getPasswordKey(keyPrefix, user, url));
        return password != null ? password : new char[]{};
    }

    private static String getPasswordKey(String prefix, String user, String url) {
        return (prefix != null ? prefix + "-" : "") + user + "@" + url;
    }

    public static File getLargerSelection() {
        FileObject[] fos = BugtrackingUtil.getCurrentSelection();
        if (fos == null) {
            return null;
        }
        for (FileObject fo : fos) {
            File file;
            FileObject ownerDirectory = BugtrackingUtil.getFileOwnerDirectory(fo);
            if (ownerDirectory != null) {
                fo = ownerDirectory;
            }
            if ((file = FileUtil.toFile((FileObject)fo)) == null) continue;
            return file;
        }
        return null;
    }

    public static FileObject getFileOwnerDirectory(FileObject fileObject) {
        ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
        return projectServices != null ? projectServices.getFileOwnerDirectory(fileObject) : null;
    }

    public static FileObject[] getCurrentSelection() {
        ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
        return projectServices != null ? projectServices.getCurrentSelection() : null;
    }

    public static boolean isJiraInstalled() {
        DelegatingConnector[] connectors;
        for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            if (c.getDelegate() == null || !c.getDelegate().getClass().getName().startsWith("org.netbeans.modules.jira")) continue;
            return true;
        }
        return false;
    }

    public static RepositoryImpl findNBRepository() {
        DelegatingConnector[] connectors;
        for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            TeamBugtrackingConnector teamConnector;
            BugtrackingConnector bugtrackingConnector = c.getDelegate();
            if (!(bugtrackingConnector instanceof TeamBugtrackingConnector) || (teamConnector = (TeamBugtrackingConnector)bugtrackingConnector).getType() != TeamBugtrackingConnector.BugtrackingType.BUGZILLA) continue;
            String id = teamConnector.findNBRepository();
            return RepositoryRegistry.getInstance().getRepository(c.getID(), id, true);
        }
        return null;
    }
}

