/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.utils.CancelRevFilter;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetPreviousCommitCommand
extends GitCommand {
    private final String revision;
    private GitRevisionInfo previousRevision;
    private final File file;
    private final ProgressMonitor monitor;

    public GetPreviousCommitCommand(Repository repository, GitClassFactory gitFactory, File file, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        block17: {
            Repository repository = this.getRepository();
            try {
                RevCommit rev = Utils.findCommit(repository, this.revision);
                if (rev.getParentCount() != 1) break block17;
                try (RevWalk walk = new RevWalk(repository);){
                    walk.markStart(walk.parseCommit((AnyObjectId)rev.getParent(0)));
                    String path = Utils.getRelativePath(repository.getWorkTree(), this.file);
                    if (path != null && !path.isEmpty()) {
                        walk.setTreeFilter((TreeFilter)FollowFilter.create((String)path, (DiffConfig)((DiffConfig)repository.getConfig().get(DiffConfig.KEY))));
                    }
                    walk.setRevFilter(AndRevFilter.create((RevFilter[])new RevFilter[]{new CancelRevFilter(this.monitor), MaxCountRevFilter.create((int)1)}));
                    Iterator it = walk.iterator();
                    if (it.hasNext()) {
                        this.previousRevision = this.getClassFactory().createRevisionInfo(new RevWalk(repository).parseCommit((AnyObjectId)it.next()), repository);
                    }
                }
            }
            catch (MissingObjectException ex) {
                throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git log ");
        sb.append(this.revision).append(' ');
        sb.append("-- ").append(this.file.getPath());
        return sb.toString();
    }

    public GitRevisionInfo getRevision() {
        return this.previousRevision;
    }
}

