/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.WeakMapPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=WeakMapPrototypeBuiltins.class)
public final class WeakMapPrototypeBuiltinsFactory {

    @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapHasNode.class)
    public static final class JSWeakMapHasNodeGen
    extends WeakMapPrototypeBuiltins.JSWeakMapHasNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private HasCachedData hasCached_cache;

        private JSWeakMapHasNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    HasCachedData s1_;
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if ((state & 1) != 0 && (s1_ = this.hasCached_cache) != null && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__) && !JSGuards.isJSProxy(arguments1Value__)) {
                        return this.hasCached(arguments0Value__, arguments1Value__, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return WeakMapPrototypeBuiltins.JSWeakMapHasNode.has(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 4) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && !JSGuards.isJSObject(arguments1Value_)) {
                    return WeakMapPrototypeBuiltins.JSWeakMapHasNode.hasNonObjectKey(arguments0Value__, arguments1Value_);
                }
            }
            if ((state & 8) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapHasNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 1) != 0) {
                return JSTypesGen.expectBoolean(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 6) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 2) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return WeakMapPrototypeBuiltins.JSWeakMapHasNode.has(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 4) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && !JSGuards.isJSObject(arguments1Value_)) {
                    return WeakMapPrototypeBuiltins.JSWeakMapHasNode.hasNonObjectKey(arguments0Value__, arguments1Value_);
                }
            }
            if ((state & 8) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapHasNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 1) == 0 && state != 0) {
                    this.executeBoolean(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_) && !JSGuards.isJSProxy(arguments1Value_)) {
                            HasCachedData s1_ = (HasCachedData)super.insert((Node)new HasCachedData());
                            s1_.storageGetter_ = s1_.insertAccessor(this.createStorageGet());
                            s1_.invertedGetter_ = s1_.insertAccessor(this.createInvertedGet());
                            s1_.invertedHas_ = s1_.insertAccessor(this.createInvertedHas());
                            s1_.weakMapKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.invertedKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.hasInvertedProfile_ = ConditionProfile.createBinaryProfile();
                            this.hasCached_cache = s1_;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.hasCached(arguments0Value_, arguments1Value_, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                            return object;
                        }
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Boolean bl = WeakMapPrototypeBuiltins.JSWeakMapHasNode.has(arguments0Value_, arguments1Value_);
                            return bl;
                        }
                    }
                    if (JSGuards.isJSWeakMap(arguments0Value_) && !JSGuards.isJSObject(arguments1Value)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Boolean bl = WeakMapPrototypeBuiltins.JSWeakMapHasNode.hasNonObjectKey(arguments0Value_, arguments1Value);
                        return bl;
                    }
                }
                if (!JSGuards.isJSWeakMap(arguments0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = WeakMapPrototypeBuiltins.JSWeakMapHasNode.notWeakMap(arguments0Value, arguments1Value);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "hasCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                HasCachedData s1_ = this.hasCached_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "has";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "hasNonObjectKey";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "notWeakMap";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static WeakMapPrototypeBuiltins.JSWeakMapHasNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSWeakMapHasNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapHasNode.class)
        private static final class HasCachedData
        extends Node {
            @Node.Child
            PropertyGetNode storageGetter_;
            @Node.Child
            PropertyGetNode invertedGetter_;
            @Node.Child
            HasHiddenKeyCacheNode invertedHas_;
            @CompilerDirectives.CompilationFinal
            ValueProfile weakMapKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ValueProfile invertedKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile hasInvertedProfile_;

            HasCachedData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapSetNode.class)
    public static final class JSWeakMapSetNodeGen
    extends WeakMapPrototypeBuiltins.JSWeakMapSetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private SetCachedData setCached_cache;

        private JSWeakMapSetNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                        SetCachedData s1_;
                        DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                        if ((state & 1) != 0 && (s1_ = this.setCached_cache) != null && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__) && !JSGuards.isJSProxy(arguments1Value__)) {
                            return this.setCached(arguments0Value__, arguments1Value__, arguments2Value_, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                        }
                        if ((state & 2) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                            return WeakMapPrototypeBuiltins.JSWeakMapSetNode.set(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                    if ((state & 4) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && !JSGuards.isJSObject(arguments1Value_)) {
                        return WeakMapPrototypeBuiltins.JSWeakMapSetNode.setNonObjectKey(arguments0Value__, arguments1Value_, arguments2Value_);
                    }
                }
                if ((state & 8) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                    return WeakMapPrototypeBuiltins.JSWeakMapSetNode.notWeakMap(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_) && !JSGuards.isJSProxy(arguments1Value_)) {
                            SetCachedData s1_ = (SetCachedData)super.insert((Node)new SetCachedData());
                            s1_.storageGetter_ = s1_.insertAccessor(this.createStorageGet());
                            s1_.invertedGetter_ = s1_.insertAccessor(this.createInvertedGet());
                            s1_.invertedHas_ = s1_.insertAccessor(this.createInvertedHas());
                            s1_.weakMapKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.invertedKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.hasInvertedProfile_ = ConditionProfile.createBinaryProfile();
                            this.setCached_cache = s1_;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.setCached(arguments0Value_, arguments1Value_, arguments2Value, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                            return object;
                        }
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = WeakMapPrototypeBuiltins.JSWeakMapSetNode.set(arguments0Value_, arguments1Value_, arguments2Value);
                            return dynamicObject;
                        }
                    }
                    if (JSGuards.isJSWeakMap(arguments0Value_) && !JSGuards.isJSObject(arguments1Value)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = WeakMapPrototypeBuiltins.JSWeakMapSetNode.setNonObjectKey(arguments0Value_, arguments1Value, arguments2Value);
                        return dynamicObject;
                    }
                }
                if (!JSGuards.isJSWeakMap(arguments0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = WeakMapPrototypeBuiltins.JSWeakMapSetNode.notWeakMap(arguments0Value, arguments1Value, arguments2Value);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "setCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                SetCachedData s1_ = this.setCached_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "set";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "setNonObjectKey";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "notWeakMap";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static WeakMapPrototypeBuiltins.JSWeakMapSetNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSWeakMapSetNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapSetNode.class)
        private static final class SetCachedData
        extends Node {
            @Node.Child
            PropertyGetNode storageGetter_;
            @Node.Child
            PropertyGetNode invertedGetter_;
            @Node.Child
            HasHiddenKeyCacheNode invertedHas_;
            @CompilerDirectives.CompilationFinal
            ValueProfile weakMapKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ValueProfile invertedKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile hasInvertedProfile_;

            SetCachedData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapGetNode.class)
    public static final class JSWeakMapGetNodeGen
    extends WeakMapPrototypeBuiltins.JSWeakMapGetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private GetCachedData getCached_cache;

        private JSWeakMapGetNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    GetCachedData s1_;
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if ((state & 1) != 0 && (s1_ = this.getCached_cache) != null && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__) && !JSGuards.isJSProxy(arguments1Value__)) {
                        return this.getCached(arguments0Value__, arguments1Value__, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return this.get(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 4) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && !JSGuards.isJSObject(arguments1Value_)) {
                    return WeakMapPrototypeBuiltins.JSWeakMapGetNode.getNonObjectKey(arguments0Value__, arguments1Value_);
                }
            }
            if ((state & 8) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapGetNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 7) != 0) {
                return JSTypesGen.expectBoolean(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 8) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapGetNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 7) == 0 && state != 0) {
                    this.executeBoolean(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_) && !JSGuards.isJSProxy(arguments1Value_)) {
                            GetCachedData s1_ = (GetCachedData)super.insert((Node)new GetCachedData());
                            s1_.storageGetter_ = s1_.insertAccessor(this.createStorageGet());
                            s1_.invertedGetter_ = s1_.insertAccessor(this.createInvertedGet());
                            s1_.invertedHas_ = s1_.insertAccessor(this.createInvertedHas());
                            s1_.weakMapKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.invertedKlassProfile_ = ValueProfile.createClassProfile();
                            s1_.hasInvertedProfile_ = ConditionProfile.createBinaryProfile();
                            this.getCached_cache = s1_;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.getCached(arguments0Value_, arguments1Value_, s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_);
                            return object;
                        }
                        if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.get(arguments0Value_, arguments1Value_);
                            return object;
                        }
                    }
                    if (JSGuards.isJSWeakMap(arguments0Value_) && !JSGuards.isJSObject(arguments1Value)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Object object = WeakMapPrototypeBuiltins.JSWeakMapGetNode.getNonObjectKey(arguments0Value_, arguments1Value);
                        return object;
                    }
                }
                if (!JSGuards.isJSWeakMap(arguments0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = WeakMapPrototypeBuiltins.JSWeakMapGetNode.notWeakMap(arguments0Value, arguments1Value);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "getCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                GetCachedData s1_ = this.getCached_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.storageGetter_, s1_.invertedGetter_, s1_.invertedHas_, s1_.weakMapKlassProfile_, s1_.invertedKlassProfile_, s1_.hasInvertedProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "get";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "getNonObjectKey";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "notWeakMap";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static WeakMapPrototypeBuiltins.JSWeakMapGetNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSWeakMapGetNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapGetNode.class)
        private static final class GetCachedData
        extends Node {
            @Node.Child
            PropertyGetNode storageGetter_;
            @Node.Child
            PropertyGetNode invertedGetter_;
            @Node.Child
            HasHiddenKeyCacheNode invertedHas_;
            @CompilerDirectives.CompilationFinal
            ValueProfile weakMapKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ValueProfile invertedKlassProfile_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile hasInvertedProfile_;

            GetCachedData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.class)
    public static final class JSWeakMapDeleteNodeGen
    extends WeakMapPrototypeBuiltins.JSWeakMapDeleteNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSWeakMapDeleteNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.delete(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 2) != 0 && JSGuards.isJSWeakMap(arguments0Value__) && !JSGuards.isJSObject(arguments1Value_)) {
                    return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.deleteNonObjectKey(arguments0Value__, arguments1Value_);
                }
            }
            if ((state & 4) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 2) != 0) {
                return JSTypesGen.expectBoolean(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSWeakMap(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.delete(arguments0Value__, arguments1Value__);
                    }
                }
            }
            if ((state & 4) != 0 && !JSGuards.isJSWeakMap(arguments0Value_)) {
                return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.notWeakMap(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 2) == 0 && state != 0) {
                    this.executeBoolean(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                    if (JSGuards.isJSWeakMap(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                        this.state_ = state |= 1;
                        return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.delete(arguments0Value_, arguments1Value_);
                    }
                }
                if (JSGuards.isJSWeakMap(arguments0Value_) && !JSGuards.isJSObject(arguments1Value)) {
                    this.state_ = state |= 2;
                    return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.deleteNonObjectKey(arguments0Value_, arguments1Value);
                }
            }
            if (!JSGuards.isJSWeakMap(arguments0Value)) {
                this.state_ = state |= 4;
                return WeakMapPrototypeBuiltins.JSWeakMapDeleteNode.notWeakMap(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "delete";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "deleteNonObjectKey";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "notWeakMap";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static WeakMapPrototypeBuiltins.JSWeakMapDeleteNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSWeakMapDeleteNodeGen(context, builtin, arguments);
        }
    }
}

