/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class JSObject {
    public static final Layout LAYOUT = JSObject.createLayout();
    public static final Class<? extends DynamicObject> CLASS = LAYOUT.getType();
    public static final String CONSTRUCTOR = "constructor";
    public static final String PROTOTYPE = "prototype";
    public static final String PROTO = "__proto__";
    public static final HiddenKey HIDDEN_PROTO = new HiddenKey("__proto__");
    public static final String NO_SUCH_PROPERTY_NAME = "__noSuchProperty__";
    public static final String NO_SUCH_METHOD_NAME = "__noSuchMethod__";
    public static final Property PROTO_PROPERTY = JSObjectUtil.makeHiddenProperty(HIDDEN_PROTO, LAYOUT.createAllocator().locationForType(CLASS, EnumSet.noneOf(LocationModifier.class)));

    private JSObject() {
    }

    public static Layout createLayout() {
        return Layout.newLayout().setAllowedImplicitCasts(EnumSet.of(Layout.ImplicitCast.IntToDouble)).build();
    }

    public static DynamicObject createStatic(Shape shape) {
        CompilerAsserts.neverPartOfCompilation();
        return shape.newInstance();
    }

    public static DynamicObject createInit(Shape shape) {
        CompilerAsserts.neverPartOfCompilation();
        return shape.newInstance();
    }

    public static DynamicObject create(JSContext context, Shape shape) {
        AllocationReporter reporter = context.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
        }
        DynamicObject object = shape.newInstance();
        if (reporter != null) {
            reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public static DynamicObject createBoundary(JSContext context, Shape shape) {
        AllocationReporter reporter = context.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
        }
        DynamicObject object = JSObject.newInstanceBoundary(shape);
        if (reporter != null) {
            reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject newInstanceBoundary(Shape shape) {
        return shape.newInstance();
    }

    public static DynamicObject create(JSContext context, JSObjectFactory factory, Object ... initialValues) {
        return JSObject.createWithRealm(context, factory, context.getRealm(), initialValues);
    }

    public static DynamicObject createWithRealm(JSContext context, JSObjectFactory factory, JSRealm realm, Object ... initialValues) {
        AllocationReporter reporter = context.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
        }
        DynamicObject object = factory.createWithRealm(realm, initialValues);
        if (reporter != null) {
            reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public static DynamicObject createWithPrototype(JSContext context, JSObjectFactory factory, JSRealm realm, DynamicObject proto, Object ... initialValues) {
        AllocationReporter reporter = context.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
        }
        DynamicObject object = factory.createWithPrototype(realm, proto, initialValues);
        if (reporter != null) {
            reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public static DynamicObject createWithBoundPrototype(JSContext context, JSObjectFactory.BoundProto factory, Object ... initialValues) {
        AllocationReporter reporter = context.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
        }
        DynamicObject object = factory.createBound(initialValues);
        if (reporter != null) {
            reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public static DynamicObject createInit(JSRealm realm, DynamicObject prototype, JSClass builtinObject) {
        CompilerAsserts.neverPartOfCompilation();
        return JSObject.createInit(realm.getContext(), prototype, builtinObject);
    }

    public static DynamicObject createInit(JSContext context, DynamicObject prototype, JSClass builtinObject) {
        CompilerAsserts.neverPartOfCompilation();
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        if (context.isMultiContext()) {
            Shape shape = builtinObject == JSUserObject.INSTANCE ? context.getEmptyShapePrototypeInObject() : context.makeEmptyShapeWithPrototypeInObject(builtinObject, PROTO_PROPERTY);
            assert (JSShape.getPrototypeProperty(shape) == PROTO_PROPERTY);
            DynamicObject obj = JSObject.createInit(shape);
            PROTO_PROPERTY.setSafe(obj, (Object)prototype, shape);
            return obj;
        }
        return JSObject.createInit(prototype == Null.instance ? context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, builtinObject, context));
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject create(JSContext context, DynamicObject prototype, JSClass builtinObject) {
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        if (context.isMultiContext() && builtinObject == JSUserObject.INSTANCE) {
            return JSUserObject.createWithPrototypeInObject(prototype, context);
        }
        return JSObject.create(context, prototype == Null.instance ? context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, builtinObject, context));
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject create(JSContext context, DynamicObject prototype, JSClass builtinObject, Property protoProperty) {
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        if (context.isMultiContext()) {
            Shape shape = context.makeEmptyShapeWithPrototypeInObject(builtinObject, protoProperty);
            DynamicObject obj = JSObject.create(context, shape);
            protoProperty.setSafe(obj, (Object)prototype, shape);
            return obj;
        }
        return JSObject.create(context, prototype == Null.instance ? context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, builtinObject, context));
    }

    public static boolean isJSObject(Object object) {
        return JSObject.isDynamicObject(object) && ((DynamicObject)object).getShape().getObjectType() instanceof JSClass;
    }

    public static boolean isDynamicObject(Object object) {
        return CLASS.isInstance(object);
    }

    public static DynamicObject castJSObject(Object object) {
        return CLASS.cast(object);
    }

    public static boolean isJSObjectClass(Class<?> clazz) {
        return CLASS.isAssignableFrom(clazz);
    }

    public static JSClass getJSClass(DynamicObject obj) {
        return JSShape.getJSClass(obj.getShape());
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject getPrototype(DynamicObject obj) {
        return JSObject.getJSClass(obj).getPrototypeOf(obj);
    }

    public static DynamicObject getPrototype(DynamicObject obj, JSClassProfile jsclassProfile) {
        return jsclassProfile.getJSClass(obj).getPrototypeOf(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setPrototype(DynamicObject obj, DynamicObject newPrototype) {
        assert (newPrototype != null);
        return JSObject.getJSClass(obj).setPrototypeOf(obj, newPrototype);
    }

    public static boolean setPrototype(DynamicObject obj, DynamicObject newPrototype, JSClassProfile jsclassProfile) {
        assert (newPrototype != null);
        return jsclassProfile.getJSClass(obj).setPrototypeOf(obj, newPrototype);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(DynamicObject obj, long index) {
        return JSObject.getJSClass(obj).get(obj, index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(DynamicObject obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).get(obj, key);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(TruffleObject obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        if (JSObject.isJSObject(obj)) {
            return JSObject.get((DynamicObject)obj, key);
        }
        return JSInteropUtil.readMemberOrDefault(obj, key, Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(TruffleObject obj, long index) {
        if (JSObject.isJSObject(obj)) {
            return JSObject.get((DynamicObject)obj, index);
        }
        return JSInteropUtil.readArrayElementOrDefault(obj, index, Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getMethod(DynamicObject obj, Object name) {
        assert (JSRuntime.isPropertyKey(name));
        Object result = JSRuntime.nullToUndefined(JSObject.getJSClass(obj).getMethodHelper(obj, obj, name));
        return result == Null.instance ? Undefined.instance : result;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean set(DynamicObject obj, long index, Object value) {
        return JSObject.set(obj, index, value, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean set(DynamicObject obj, Object key, Object value) {
        return JSObject.set(obj, key, value, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean set(DynamicObject obj, long index, Object value, boolean isStrict) {
        return JSObject.getJSClass(obj).set(obj, index, value, (Object)obj, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean set(DynamicObject obj, Object key, Object value, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).set(obj, key, value, (Object)obj, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setWithReceiver(DynamicObject obj, Object key, Object value, Object receiver, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).set(obj, key, value, receiver, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setWithReceiver(DynamicObject obj, long index, Object value, Object receiver, boolean isStrict) {
        return JSObject.getJSClass(obj).set(obj, index, value, receiver, isStrict);
    }

    public static boolean setWithReceiver(DynamicObject obj, Object key, Object value, Object receiver, boolean isStrict, JSClassProfile classProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return classProfile.getJSClass(obj).set(obj, key, value, receiver, isStrict);
    }

    public static boolean setWithReceiver(DynamicObject obj, long index, Object value, Object receiver, boolean isStrict, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).set(obj, index, value, receiver, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean delete(DynamicObject obj, long index) {
        return JSObject.getJSClass(obj).delete(obj, index, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean delete(DynamicObject obj, long index, boolean isStrict) {
        return JSObject.getJSClass(obj).delete(obj, index, isStrict);
    }

    public static boolean delete(DynamicObject obj, long index, boolean isStrict, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).delete(obj, index, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean delete(DynamicObject obj, Object key) {
        return JSObject.delete(obj, key, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean delete(DynamicObject obj, Object key, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).delete(obj, key, isStrict);
    }

    public static boolean delete(DynamicObject obj, Object key, boolean isStrict, JSClassProfile classProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return classProfile.getJSClass(obj).delete(obj, key, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasOwnProperty(DynamicObject obj, long index) {
        return JSObject.getJSClass(obj).hasOwnProperty(obj, index);
    }

    public static boolean hasOwnProperty(DynamicObject obj, long index, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).hasOwnProperty(obj, index);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasOwnProperty(DynamicObject obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).hasOwnProperty(obj, key);
    }

    public static boolean hasOwnProperty(DynamicObject obj, Object key, JSClassProfile classProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return classProfile.getJSClass(obj).hasOwnProperty(obj, key);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(DynamicObject obj, long index) {
        return JSObject.getJSClass(obj).hasProperty(obj, index);
    }

    public static boolean hasProperty(DynamicObject obj, long index, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).hasProperty(obj, index);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(DynamicObject obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).hasProperty(obj, key);
    }

    public static boolean hasProperty(DynamicObject obj, Object key, JSClassProfile classProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return classProfile.getJSClass(obj).hasProperty(obj, key);
    }

    public static PropertyDescriptor getOwnProperty(DynamicObject obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).getOwnProperty(obj, key);
    }

    public static PropertyDescriptor getOwnProperty(DynamicObject obj, Object key, JSClassProfile classProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return classProfile.getJSClass(obj).getOwnProperty(obj, key);
    }

    public static List<Object> ownPropertyKeys(DynamicObject obj) {
        return JSObject.getJSClass(obj).ownPropertyKeys(obj);
    }

    public static List<Object> ownPropertyKeys(DynamicObject obj, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).ownPropertyKeys(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<String> enumerableOwnNames(DynamicObject thisObj) {
        JSClass jsclass = JSObject.getJSClass(thisObj);
        if (jsclass.hasOnlyShapeProperties(thisObj)) {
            return JSShape.getEnumerablePropertyNames(thisObj.getShape());
        }
        List<Object> ownKeys = jsclass.ownPropertyKeys(thisObj);
        ArrayList<String> names = new ArrayList<String>();
        for (Object t : ownKeys) {
            PropertyDescriptor desc;
            if (!(t instanceof String) || (desc = jsclass.getOwnProperty(thisObj, t)) == null || !desc.getEnumerable()) continue;
            names.add((String)t);
        }
        return names;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean defineOwnProperty(DynamicObject obj, Object key, PropertyDescriptor desc) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).defineOwnProperty(obj, key, desc, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean defineOwnProperty(DynamicObject obj, Object key, PropertyDescriptor desc, boolean doThrow) {
        assert (JSRuntime.isPropertyKey(key));
        return JSObject.getJSClass(obj).defineOwnProperty(obj, key, desc, doThrow);
    }

    public static Object get(DynamicObject obj, Object key, JSClassProfile jsclassProfile) {
        assert (JSRuntime.isPropertyKey(key));
        return jsclassProfile.getJSClass(obj).get(obj, key);
    }

    public static Object get(DynamicObject obj, long index, JSClassProfile jsclassProfile) {
        return jsclassProfile.getJSClass(obj).get(obj, index);
    }

    public static Object getOrDefault(DynamicObject obj, Object key, Object receiver, Object defaultValue, JSClassProfile jsclassProfile) {
        assert (JSRuntime.isPropertyKey(key));
        Object result = jsclassProfile.getJSClass(obj).getHelper(obj, receiver, key);
        return result == null ? defaultValue : result;
    }

    public static Object getOrDefault(DynamicObject obj, long index, Object receiver, Object defaultValue, JSClassProfile jsclassProfile) {
        Object result = jsclassProfile.getJSClass(obj).getHelper(obj, receiver, index);
        return result == null ? defaultValue : result;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getWithReceiver(DynamicObject obj, Object key, Object receiver) {
        assert (JSRuntime.isPropertyKey(key));
        Object result = JSObject.getJSClass(obj).getHelper(obj, receiver, key);
        return result == null ? Undefined.instance : result;
    }

    @CompilerDirectives.TruffleBoundary
    public static String defaultToString(DynamicObject obj) {
        return JSObject.getJSClass(obj).defaultToString(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static String safeToString(DynamicObject obj, int depth) {
        return JSObject.getJSClass(obj).safeToString(obj, depth, JavaScriptLanguage.getCurrentLanguage().getJSContext());
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(DynamicObject obj, String hint) {
        assert (obj != Null.instance && obj != Undefined.instance);
        Object exoticToPrim = JSObject.getMethod(obj, Symbol.SYMBOL_TO_PRIMITIVE);
        if (exoticToPrim != Undefined.instance) {
            Object result = JSRuntime.call(exoticToPrim, obj, new Object[]{hint});
            if (JSRuntime.isObject(result)) {
                throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object");
            }
            return result;
        }
        if (hint.equals("default")) {
            return JSObject.ordinaryToPrimitive(obj, "number");
        }
        return JSObject.ordinaryToPrimitive(obj, hint);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(DynamicObject obj) {
        return JSObject.toPrimitive(obj, "default");
    }

    @CompilerDirectives.TruffleBoundary
    public static Object ordinaryToPrimitive(DynamicObject obj, String hint) {
        assert (JSRuntime.isObject(obj));
        assert ("string".equals(hint) || "number".equals(hint));
        String[] methodNames = "string".equals(hint) ? new String[]{"toString", "valueOf"} : new String[]{"valueOf", "toString"};
        for (String name : methodNames) {
            Object result;
            Object method = JSObject.getMethod(obj, name);
            if (!JSRuntime.isCallable(method) || JSRuntime.isObject(result = JSRuntime.call(method, obj, new Object[0]))) continue;
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean preventExtensions(DynamicObject obj) {
        return JSObject.preventExtensions(obj, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean preventExtensions(DynamicObject obj, boolean doThrow) {
        return JSObject.getJSClass(obj).preventExtensions(obj, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isExtensible(DynamicObject obj) {
        return JSObject.getJSClass(obj).isExtensible(obj);
    }

    public static boolean isExtensible(DynamicObject obj, JSClassProfile classProfile) {
        return classProfile.getJSClass(obj).isExtensible(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getClassName(DynamicObject obj) {
        return JSObject.getJSClass(obj).getClassName(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFrozen(DynamicObject obj) {
        return JSObject.testIntegrityLevel(obj, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isSealed(DynamicObject obj) {
        return JSObject.testIntegrityLevel(obj, false);
    }

    public static ScriptArray getArray(DynamicObject obj) {
        return JSObject.getArray(obj, JSObject.hasArray(obj));
    }

    public static ScriptArray getArray(DynamicObject obj, boolean customFloatingCondition) {
        assert (JSObject.hasArray(obj));
        return (ScriptArray)JSAbstractArray.ARRAY_TYPE_PROPERTY.get(obj, customFloatingCondition);
    }

    public static void setArray(DynamicObject obj, ScriptArray array) {
        assert (JSObject.hasArray(obj));
        JSAbstractArray.ARRAY_TYPE_PROPERTY.setSafe(obj, (Object)array, null);
    }

    public static boolean hasArray(DynamicObject obj) {
        return JSArray.isJSArray(obj) || JSArgumentsObject.isJSArgumentsObject(obj) || JSArrayBufferView.isJSArrayBufferView(obj) || JSObjectPrototype.isJSObjectPrototype(obj);
    }

    public static JSContext getJSContext(DynamicObject obj) {
        return JSShape.getJSContext(obj.getShape());
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public static boolean testIntegrityLevel(DynamicObject obj, boolean frozen) {
        return JSObject.getJSClass(obj).testIntegrityLevel(obj, frozen);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setIntegrityLevel(DynamicObject obj, boolean freeze) {
        return JSObject.setIntegrityLevel(obj, freeze, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setIntegrityLevel(DynamicObject obj, boolean freeze, boolean doThrow) {
        return JSObject.getJSClass(obj).setIntegrityLevel(obj, freeze, doThrow);
    }
}

