/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.refactoring.PositionBoundsResolver;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class WebXmlRefactoring
implements WebRefactoring {
    private static final Logger LOGGER = Logger.getLogger(WebXmlRefactoring.class.getName());
    protected final FileObject webDD;
    private AtomicReference<WebApp> webModel = new AtomicReference();

    protected WebXmlRefactoring(FileObject webDD) {
        this.webDD = webDD;
    }

    @Override
    public Problem preCheck() {
        WebApp model = this.getWebModel();
        if (model == null) {
            return new Problem(false, NbBundle.getMessage(WebXmlRefactoring.class, (String)"TXT_WebXmlNotReadable"));
        }
        if (model.getStatus() == 2) {
            return new Problem(false, NbBundle.getMessage(WebXmlRefactoring.class, (String)"TXT_WebXmlInvalidProblem"));
        }
        if (model.getStatus() == 3) {
            return new Problem(false, NbBundle.getMessage(WebXmlRefactoring.class, (String)"TXT_WebXmlOldVersion"));
        }
        return null;
    }

    protected List<Servlet> getServlets(String clazz) {
        ArrayList<Servlet> result = new ArrayList<Servlet>();
        for (Servlet servlet : this.getWebModel().getServlet()) {
            if (!clazz.equals(servlet.getServletClass())) continue;
            result.add(servlet);
        }
        return result;
    }

    protected List<Filter> getFilters(String clazz) {
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (Filter filter : this.getWebModel().getFilter()) {
            if (!clazz.equals(filter.getFilterClass())) continue;
            result.add(filter);
        }
        return result;
    }

    protected List<Listener> getListeners(String clazz) {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (Listener listener : this.getWebModel().getListener()) {
            if (!clazz.equals(listener.getListenerClass())) continue;
            result.add(listener);
        }
        return result;
    }

    protected List<EjbRef> getEjbRefs(String clazz, boolean remote) {
        ArrayList<EjbRef> result = new ArrayList<EjbRef>();
        for (EjbRef ejbRef : this.getWebModel().getEjbRef()) {
            if (remote && clazz.equals(ejbRef.getRemote())) {
                result.add(ejbRef);
                continue;
            }
            if (!clazz.equals(ejbRef.getHome())) continue;
            result.add(ejbRef);
        }
        return result;
    }

    protected List<EjbLocalRef> getEjbLocalRefs(String clazz, boolean localHome) {
        ArrayList<EjbLocalRef> result = new ArrayList<EjbLocalRef>();
        for (EjbLocalRef ejbLocalRef : this.getWebModel().getEjbLocalRef()) {
            if (localHome && clazz.equals(ejbLocalRef.getLocalHome())) {
                result.add(ejbLocalRef);
                continue;
            }
            if (!clazz.equals(ejbLocalRef.getLocal())) continue;
            result.add(ejbLocalRef);
        }
        return result;
    }

    protected WebApp getWebModel() {
        if (this.webDD == null) {
            return null;
        }
        WebApp model = this.webModel.get();
        if (model != null) {
            return model;
        }
        try {
            model = DDProvider.getDefault().getDDRoot(this.webDD);
            this.webModel.compareAndSet(null, model);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
        }
        return model;
    }

    protected static abstract class WebRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final WebApp webApp;
        protected final FileObject webDD;

        public WebRefactoringElement(WebApp webApp, FileObject webDD) {
            this.webApp = webApp;
            this.webDD = webDD;
        }

        public void performChange() {
            this.doChange();
            this.writeDD();
        }

        private void writeDD() {
            try {
                this.webApp.write(this.webDD);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        protected abstract void doChange();

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.webDD;
        }

        public PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.webDD), this.getName()).getPositionBounds();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void undoChange() {
            this.undo();
            this.writeDD();
        }

        protected abstract String getName();

        protected abstract void undo();
    }
}

