/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.OverlayMenu;
import org.primefaces.context.RequestContext;
import org.primefaces.event.MenuActionEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.model.menu.Separator;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMenuRenderer
extends OutcomeTargetRenderer {
    private static final String SB_BUILD_NON_AJAX_REQUEST = BaseMenuRenderer.class.getName() + "#buildNonAjaxRequest";
    public static final String SEPARATOR = "_";

    public void decode(FacesContext context, UIComponent component) {
        AbstractMenu menu = (AbstractMenu)component;
        String clientId = menu.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            String menuid = (String)params.get(clientId + "_menuid");
            MenuItem menuitem = this.findMenuitem(menu.getElements(), menuid);
            MenuActionEvent event = new MenuActionEvent((UIComponent)menu, menuitem);
            if (menuitem.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            menu.queueEvent((FacesEvent)event);
        }
    }

    protected MenuItem findMenuitem(List<MenuElement> elements, String id) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        String[] paths = id.split(SEPARATOR);
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        if (childIndex >= elements.size()) {
            return null;
        }
        MenuElement childElement = elements.get(childIndex);
        if (paths.length == 1) {
            return (MenuItem)childElement;
        }
        String relativeIndex = id.substring(id.indexOf(SEPARATOR) + 1);
        return this.findMenuitem(((MenuGroup)childElement).getElements(), relativeIndex);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        MenuModel model = menu.getModel();
        if (model != null && menu.getElementsCount() > 0) {
            model.generateUniqueIds();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected String getLinkStyleClass(MenuItem menuItem) {
        String styleClass = menuItem.getStyleClass();
        return styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else {
            boolean disabled = menuitem.isDisabled();
            String style = menuitem.getStyle();
            writer.startElement("a", null);
            writer.writeAttribute("tabindex", (Object)"-1", null);
            if (this.shouldRenderId(menuitem)) {
                writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
            }
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            String styleClass = this.getLinkStyleClass(menuitem);
            if (disabled) {
                styleClass = styleClass + " ui-state-disabled";
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                String onclick = menuitem.getOnclick();
                if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
                    String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
                    writer.writeAttribute("href", (Object)targetURL, null);
                    if (menuitem.getTarget() != null) {
                        writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                    }
                } else {
                    String command;
                    writer.writeAttribute("href", (Object)"#", null);
                    UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menu);
                    if (form == null) {
                        throw new FacesException("MenuItem must be inside a form element");
                    }
                    if (menuitem.isDynamic()) {
                        String menuClientId = menu.getClientId(context);
                        Map<String, List<String>> params = menuitem.getParams();
                        if (params == null) {
                            params = new LinkedHashMap<String, List<String>>();
                        }
                        ArrayList<String> idParams = new ArrayList<String>();
                        idParams.add(menuitem.getId());
                        params.put(menuClientId + "_menuid", idParams);
                        command = menuitem.isAjax() ? this.buildAjaxRequest(context, menu, (AjaxSource)((Object)menuitem), form, params) : this.buildNonAjaxRequest(context, (UIComponent)menu, form, menuClientId, params, true);
                    } else {
                        command = menuitem.isAjax() ? this.buildAjaxRequest(context, (AjaxSource)((Object)menuitem), form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, form, ((UIComponent)menuitem).getClientId(context), true);
                    }
                    String string = onclick = onclick == null ? command : onclick + ";" + command;
                }
                if (onclick != null) {
                    writer.writeAttribute("onclick", (Object)onclick, null);
                }
            }
            this.encodeMenuItemContent(context, menu, menuitem);
            writer.endElement("a");
        }
    }

    protected boolean shouldRenderId(MenuItem item) {
        return item.isDynamic() ? false : this.shouldWriteId((UIComponent)item);
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuitem.getIcon();
        Object value = menuitem.getValue();
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.endElement("span");
        }
        if (value != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText(value, "value");
            writer.endElement("span");
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void encodeOverlayConfig(FacesContext context, OverlayMenu menu, WidgetBuilder wb) throws IOException {
        wb.attr("overlay", true).attr("my", menu.getMy()).attr("at", menu.getAt());
        String trigger = menu.getTrigger();
        if (trigger != null) {
            wb.attr("trigger", SearchExpressionFacade.resolveComponentsForClient(context, (UIComponent)menu, trigger)).attr("triggerEvent", menu.getTriggerEvent());
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String buildAjaxRequest(FacesContext context, AbstractMenu menu, AjaxSource source, UIComponent form, Map<String, List<String>> params) {
        String clientId = menu.getClientId(context);
        AjaxRequestBuilder builder = RequestContext.getCurrentInstance().getAjaxRequestBuilder();
        builder.init().source(clientId).process((UIComponent)menu, source.getProcess()).update((UIComponent)menu, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).delay(source.getDelay()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).params(params);
        if (form != null) {
            builder.form(form.getClientId(context));
        }
        builder.preventDefault();
        return builder.build();
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, Map<String, List<String>> parameters, boolean submit) {
        StringBuilder request = SharedStringBuilder.get(context, SB_BUILD_NON_AJAX_REQUEST);
        String formId = form.getClientId(context);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (decodeParam != null) {
            params.put(decodeParam, decodeParam);
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter) || !child.isRendered()) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), param.getValue());
        }
        if (parameters != null && !parameters.isEmpty()) {
            for (String paramName : parameters.keySet()) {
                params.put(paramName, parameters.get(paramName).get(0));
            }
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(formId).append("',{");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                Object value = params.get(key);
                request.append("'").append(key).append("':'").append(value).append("'");
                if (!it.hasNext()) continue;
                request.append(",");
            }
            request.append("})");
        }
        if (submit) {
            request.append(".submit('").append(formId).append("');return false;");
        }
        return request.toString();
    }

    protected void encodeKeyboardTarget(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.endElement("div");
    }
}

