/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

public class Version {
    private long major;
    private long minor;
    private long micro;
    private long update;
    private long build;

    public static Version getVersion(String string) {
        if (string != null && string.matches("([0-9]+[\\._\\-]+)*[0-9]+")) {
            return new Version(string);
        }
        return null;
    }

    private Version(String string) {
        String[] split = string.split("[\\._\\-]+");
        if (split.length > 0) {
            this.major = new Long(split[0]);
        }
        if (split.length > 1) {
            this.minor = new Long(split[1]);
        }
        if (split.length > 2) {
            this.micro = new Long(split[2]);
        }
        if (split.length > 3) {
            this.update = new Long(split[3]);
        }
        if (split.length > 4) {
            this.build = new Long(split[4]);
        }
    }

    public boolean equals(Version version) {
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.update == version.update && this.build == version.build;
    }

    public boolean newerThan(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major == version.major) {
            if (this.minor > version.minor) {
                return true;
            }
            if (this.minor == version.minor) {
                if (this.micro > version.micro) {
                    return true;
                }
                if (this.micro == version.micro) {
                    if (this.update > version.update) {
                        return true;
                    }
                    if (this.update == version.update && this.build > version.build) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean newerOrEquals(Version version) {
        return this.newerThan(version) || this.equals(version);
    }

    public boolean olderThan(Version version) {
        return !this.newerOrEquals(version);
    }

    public boolean olderOrEquals(Version version) {
        return !this.newerThan(version);
    }

    public VersionDistance getDistance(Version version) {
        return new VersionDistance(this, version);
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getMicro() {
        return this.micro;
    }

    public long getUpdate() {
        return this.update;
    }

    public long getBuild() {
        return this.build;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.micro + "." + this.update + "." + this.build;
    }

    public String toMajor() {
        return "" + this.major;
    }

    public String toMinor() {
        return "" + this.major + "." + this.minor;
    }

    public String toMicro() {
        return "" + this.major + "." + this.minor + "." + this.micro;
    }

    public String toJdkStyle() {
        return "" + this.major + "." + this.minor + "." + this.micro + (this.update != 0L ? "_" + (this.update < 10L ? "0" + this.update : Long.valueOf(this.update)) : "");
    }

    public static class VersionDistance {
        private final long majorDistance;
        private final long minorDistance;
        private final long microDistance;
        private final long updateDistance;
        private final long buildDistance;

        private VersionDistance(Version version1, Version version2) {
            this.majorDistance = Math.abs(version1.getMajor() - version2.getMajor());
            this.minorDistance = Math.abs(version1.getMinor() - version2.getMinor());
            this.microDistance = Math.abs(version1.getMicro() - version2.getMicro());
            this.updateDistance = Math.abs(version1.getUpdate() - version2.getUpdate());
            this.buildDistance = Math.abs(version1.getBuild() - version2.getBuild());
        }

        public boolean equals(VersionDistance distance) {
            return this.majorDistance == distance.majorDistance && this.minorDistance == distance.minorDistance && this.microDistance == distance.microDistance && this.updateDistance == distance.updateDistance && this.buildDistance == distance.buildDistance;
        }

        public boolean greaterThan(VersionDistance distance) {
            if (this.majorDistance > distance.majorDistance) {
                return true;
            }
            if (this.majorDistance == distance.majorDistance) {
                if (this.minorDistance > distance.minorDistance) {
                    return true;
                }
                if (this.minorDistance == distance.minorDistance) {
                    if (this.microDistance > distance.microDistance) {
                        return true;
                    }
                    if (this.microDistance == distance.microDistance) {
                        if (this.updateDistance > distance.updateDistance) {
                            return true;
                        }
                        if (this.updateDistance == distance.updateDistance && this.buildDistance > distance.buildDistance) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public boolean greaterOrEquals(VersionDistance version) {
            return this.greaterThan(version) || this.equals(version);
        }

        public boolean lessThan(VersionDistance version) {
            return !this.greaterOrEquals(version);
        }

        public boolean lessOrEquals(VersionDistance distance) {
            return !this.greaterThan(distance);
        }
    }
}

