/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitMethodAliasDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpAnnotations;

public class SemanticAnalysis
extends SemanticAnalyzer {
    public static final EnumSet<ColoringAttributes> UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> DEPRECATED_UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> DEPRECATED_FIELD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> DEPRECATED_UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> DEPRECATED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> DEPRECATED_UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> DEPRECATED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> DEPRECATED_METHOD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    public static final EnumSet<ColoringAttributes> DEPRECATED_UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    public static final EnumSet<ColoringAttributes> DEPRECATED_CLASS_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.CLASS);
    public static final EnumSet<ColoringAttributes> DEPRECATED_SET = EnumSet.of(ColoringAttributes.DEPRECATED);
    public static final EnumSet<ColoringAttributes> DEPRECATED_STATIC_SET = EnumSet.of(ColoringAttributes.DEPRECATED, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> ANNOTATION_TYPE_SET = EnumSet.of(ColoringAttributes.ANNOTATION_TYPE);
    public static final EnumSet<ColoringAttributes> METHOD_INVOCATION_SET = EnumSet.of(ColoringAttributes.CUSTOM1);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_INVOCATION_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.CUSTOM1);
    private static final Logger LOGGER = Logger.getLogger(SemanticAnalysis.class.getName());
    private static boolean isLogged = false;
    private volatile boolean cancelled;
    private boolean checkIfResolveDeprecatedElements = true;
    private boolean isResolveDeprecatedElements = false;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;

    private static void setIsLogged(boolean isLogged) {
        SemanticAnalysis.isLogged = isLogged;
    }

    private static boolean isLogged() {
        return isLogged;
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result r, SchedulerEvent event) {
        this.checkIfResolveDeprecatedElements = true;
        if (this.isResolveDeprecatedElements() && !SemanticAnalysis.isLogged()) {
            LOGGER.info("Resolving of deprecated elements in Semantic analysis - IDE will be possibly slow!");
            SemanticAnalysis.setIsLogged(true);
        }
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        this.process(r);
    }

    void process(Parser.Result r) {
        PHPParseResult result = (PHPParseResult)r;
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        if (result.getProgram() != null) {
            SemanticHighlightVisitor semanticHighlightVisitor = new SemanticHighlightVisitor(highlights, result.getSnapshot(), result.getModel());
            result.getProgram().accept(semanticHighlightVisitor);
            this.semanticHighlights = highlights.size() > 0 ? highlights : null;
        }
    }

    protected final boolean isCancelled() {
        return this.cancelled;
    }

    protected final void resume() {
        this.cancelled = false;
    }

    protected boolean isResolveDeprecatedElements() {
        if (this.checkIfResolveDeprecatedElements) {
            this.isResolveDeprecatedElements = PhpAnnotations.getDefault().isResolveDeprecatedElements();
            this.checkIfResolveDeprecatedElements = false;
        }
        return this.isResolveDeprecatedElements;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private static final class ClassInstanceCreationTypeInfo
    implements TypeInfo {
        private final ClassInstanceCreation classInstanceCreation;

        ClassInstanceCreationTypeInfo(ClassInstanceCreation classInstanceCreation) {
            assert (classInstanceCreation != null);
            this.classInstanceCreation = classInstanceCreation;
        }

        @Override
        public Expression getName() {
            return this.classInstanceCreation.getClassName().getName();
        }

        @Override
        public boolean isTrait() {
            return false;
        }
    }

    private static final class TypeDeclarationTypeInfo
    implements TypeInfo {
        private final TypeDeclaration typeDeclaration;
        private final boolean isTrait;

        TypeDeclarationTypeInfo(TypeDeclaration typeDeclaration) {
            assert (typeDeclaration != null);
            this.typeDeclaration = typeDeclaration;
            this.isTrait = typeDeclaration instanceof TraitDeclaration;
        }

        @Override
        public Expression getName() {
            return this.typeDeclaration.getName();
        }

        @Override
        public boolean isTrait() {
            return this.isTrait;
        }
    }

    private static interface TypeInfo {
        public Expression getName();

        public boolean isTrait();
    }

    private class SemanticHighlightVisitor
    extends DefaultTreePathVisitor {
        Map<OffsetRange, Set<ColoringAttributes>> highlights;
        private final Map<UnusedIdentifier, ASTNodeColoring> privateUnusedConstants;
        private final Map<UnusedIdentifier, ASTNodeColoring> privateFieldsUnused;
        private final Map<UnusedIdentifier, ASTNodeColoring> privateUnusedMethods;
        private List<Block> needToScan = new ArrayList<Block>();
        private final Snapshot snapshot;
        private final Model model;
        private Set<TypeElement> deprecatedTypes;
        private Set<MethodElement> deprecatedMethods;
        private Set<FieldElement> deprecatedFields;
        private Set<TypeConstantElement> deprecatedConstants;
        private Set<FunctionElement> deprecatedFunctions;
        private TypeInfo typeInfo;

        public SemanticHighlightVisitor(Map<OffsetRange, Set<ColoringAttributes>> highlights, Snapshot snapshot, Model model) {
            this.highlights = highlights;
            this.privateUnusedConstants = new HashMap<UnusedIdentifier, ASTNodeColoring>();
            this.privateFieldsUnused = new HashMap<UnusedIdentifier, ASTNodeColoring>();
            this.privateUnusedMethods = new HashMap<UnusedIdentifier, ASTNodeColoring>();
            this.snapshot = snapshot;
            this.model = model;
        }

        private Set<TypeElement> getDeprecatedTypes() {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            if (this.deprecatedTypes == null) {
                this.deprecatedTypes = ElementFilter.forDeprecated(true).filter(this.model.getIndexScope().getIndex().getTypes(NameKind.empty()));
            }
            return this.deprecatedTypes;
        }

        private Set<MethodElement> getDeprecatedMethods() {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            if (this.deprecatedMethods == null) {
                this.deprecatedMethods = ElementFilter.forDeprecated(true).filter(this.model.getIndexScope().getIndex().getMethods(NameKind.empty()));
            }
            return this.deprecatedMethods;
        }

        private Set<FunctionElement> getDeprecatedFunctions() {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            if (this.deprecatedFunctions == null) {
                this.deprecatedFunctions = ElementFilter.forDeprecated(true).filter(this.model.getIndexScope().getIndex().getFunctions(NameKind.empty()));
            }
            return this.deprecatedFunctions;
        }

        private Set<FieldElement> getDeprecatedFields() {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            if (this.deprecatedFields == null) {
                this.deprecatedFields = ElementFilter.forDeprecated(true).filter(this.model.getIndexScope().getIndex().getFields(NameKind.empty()));
            }
            return this.deprecatedFields;
        }

        private Set<TypeConstantElement> getDeprecatedConstants() {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            if (this.deprecatedConstants == null) {
                this.deprecatedConstants = ElementFilter.forDeprecated(true).filter(this.model.getIndexScope().getIndex().getTypeConstants(NameKind.empty()));
            }
            return this.deprecatedConstants;
        }

        private void addColoringForNode(ASTNode node, Set<ColoringAttributes> coloring) {
            int start = this.snapshot.getOriginalOffset(node.getStartOffset());
            if (start > -1) {
                int end = start + node.getEndOffset() - node.getStartOffset();
                assert (coloring != null) : this.snapshot.getText().toString();
                this.highlights.put(new OffsetRange(start, end), coloring);
            }
        }

        private void addColoringForUnusedPrivateFields() {
            for (ASTNodeColoring item : this.privateFieldsUnused.values()) {
                if (item.coloring.contains(ColoringAttributes.STATIC)) {
                    if (item.coloring.contains(ColoringAttributes.DEPRECATED)) {
                        this.addColoringForNode(item.identifier, DEPRECATED_UNUSED_STATIC_FIELD_SET);
                        continue;
                    }
                    this.addColoringForNode(item.identifier, UNUSED_STATIC_FIELD_SET);
                    continue;
                }
                if (item.coloring.contains(ColoringAttributes.DEPRECATED)) {
                    this.addColoringForNode(item.identifier, DEPRECATED_UNUSED_FIELD_SET);
                    continue;
                }
                this.addColoringForNode(item.identifier, UNUSED_FIELD_SET);
            }
        }

        private void addColoringForUnusedPrivateConstants() {
            for (ASTNodeColoring item : this.privateUnusedConstants.values()) {
                if (item.coloring.contains(ColoringAttributes.DEPRECATED)) {
                    this.addColoringForNode(item.identifier, DEPRECATED_UNUSED_STATIC_FIELD_SET);
                    continue;
                }
                this.addColoringForNode(item.identifier, UNUSED_STATIC_FIELD_SET);
            }
        }

        @Override
        public void scan(ASTNode node) {
            if (!SemanticAnalysis.this.isCancelled()) {
                super.scan(node);
            }
        }

        @Override
        public void visit(Program program) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.scan(program.getStatements());
            this.scan(program.getComments());
            for (ASTNodeColoring item : this.privateUnusedMethods.values()) {
                if (item.coloring.contains(ColoringAttributes.STATIC)) {
                    if (item.coloring.contains(ColoringAttributes.DEPRECATED)) {
                        this.addColoringForNode(item.identifier, DEPRECATED_UNUSED_STATIC_METHOD_SET);
                        continue;
                    }
                    this.addColoringForNode(item.identifier, UNUSED_STATIC_METHOD_SET);
                    continue;
                }
                if (item.coloring.contains(ColoringAttributes.DEPRECATED)) {
                    this.addColoringForNode(item.identifier, DEPRECATED_UNUSED_METHOD_SET);
                    continue;
                }
                this.addColoringForNode(item.identifier, UNUSED_METHOD_SET);
            }
        }

        @Override
        public void visit(ClassDeclaration cldec) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.addToPath(cldec);
            this.typeInfo = new TypeDeclarationTypeInfo(cldec);
            this.scan(cldec.getSuperClass());
            this.scan(cldec.getInterfaes());
            Identifier name = cldec.getName();
            this.addColoringForNode(name, this.createTypeNameColoring(name));
            this.needToScan = new ArrayList<Block>();
            if (cldec.getBody() != null) {
                cldec.getBody().accept(this);
                while (!this.needToScan.isEmpty()) {
                    Block block = this.needToScan.remove(0);
                    block.accept(this);
                }
                this.addColoringForUnusedPrivateConstants();
                this.addColoringForUnusedPrivateFields();
            }
            this.removeFromPath();
        }

        private Set<ColoringAttributes> createTypeNameColoring(Identifier typeName) {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            EnumSet result = this.isDeprecatedTypeDeclaration(typeName) ? DEPRECATED_CLASS_SET : ColoringAttributes.CLASS_SET;
            return result;
        }

        private boolean isDeprecatedTypeDeclaration(Identifier typeName) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                VariableScope variableScope = this.model.getVariableScope(typeName.getStartOffset());
                QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(typeName), typeName.getStartOffset(), variableScope);
                for (TypeElement typeElement : this.getDeprecatedTypes()) {
                    if (!typeElement.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier functionName = node.getFunctionName();
            if (this.isDeprecatedFunctionDeclaration(functionName)) {
                this.addColoringForNode(functionName, DEPRECATED_SET);
            }
            super.visit(node);
        }

        private boolean isDeprecatedFunctionDeclaration(Identifier functionName) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                for (FunctionElement functionElement : this.getDeprecatedFunctions()) {
                    if (!functionElement.getName().equals(functionName.getName())) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(MethodDeclaration md) {
            Block body;
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (CodeUtils.isConstructor(md)) {
                for (FormalParameter formalParameter : md.getFunction().getFormalParameters()) {
                    if (SemanticAnalysis.this.isCancelled()) {
                        return;
                    }
                    FieldsDeclaration fieldsDeclaration = FieldsDeclaration.create(formalParameter);
                    if (fieldsDeclaration == null) continue;
                    this.scan(fieldsDeclaration);
                }
            }
            this.scan(md.getFunction().getFormalParameters());
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(md.getModifier());
            Identifier identifier = md.getFunction().getFunctionName();
            String name = identifier.getName().toLowerCase();
            Set<ColoringAttributes> coloring = this.createMethodDeclarationColoring(md);
            if (isPrivate && !this.typeInfo.isTrait() && name != null && !name.startsWith("__")) {
                this.privateUnusedMethods.put(new UnusedIdentifier(name, this.typeInfo), new ASTNodeColoring(identifier, coloring));
            } else {
                this.addColoringForNode(identifier, coloring);
            }
            if (!BodyDeclaration.Modifier.isAbstract(md.getModifier()) && (body = md.getFunction().getBody()) != null) {
                this.needToScan.add(body);
            }
        }

        private Set<ColoringAttributes> createMethodDeclarationColoring(MethodDeclaration methodDeclaration) {
            EnumSet<ColoringAttributes> coloring;
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            boolean isDeprecated = this.isDeprecatedMethodDeclaration(methodDeclaration.getFunction().getFunctionName());
            EnumSet<ColoringAttributes> enumSet = coloring = isDeprecated ? DEPRECATED_METHOD_SET : ColoringAttributes.METHOD_SET;
            if (BodyDeclaration.Modifier.isStatic(methodDeclaration.getModifier())) {
                coloring = isDeprecated ? DEPRECATED_STATIC_METHOD_SET : STATIC_METHOD_SET;
            }
            return coloring;
        }

        private boolean isDeprecatedMethodDeclaration(Identifier methodName) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                VariableScope variableScope = this.model.getVariableScope(methodName.getStartOffset());
                QualifiedName typeFullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(this.typeInfo.getName()), methodName.getStartOffset(), variableScope);
                for (MethodElement methodElement : this.getDeprecatedMethods()) {
                    if (!methodElement.getName().equals(methodName.getName()) || !methodElement.getType().getFullyQualifiedName().equals(typeFullyQualifiedName)) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(TraitMethodAliasDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (node.getNewMethodName() != null) {
                this.addColoringForNode(node.getNewMethodName(), ColoringAttributes.METHOD_SET);
            }
        }

        @Override
        public void visit(MethodInvocation node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier identifier = null;
            if (node.getMethod().getFunctionName().getName() instanceof Variable) {
                Variable variable = (Variable)node.getMethod().getFunctionName().getName();
                if (variable.getName() instanceof Identifier) {
                    identifier = (Identifier)variable.getName();
                }
            } else if (node.getMethod().getFunctionName().getName() instanceof Identifier) {
                identifier = (Identifier)node.getMethod().getFunctionName().getName();
            }
            if (identifier != null) {
                ASTNodeColoring item = this.privateUnusedMethods.remove(new UnusedIdentifier(identifier.getName().toLowerCase(), this.typeInfo));
                if (item != null) {
                    this.addColoringForNode(item.identifier, item.coloring);
                }
                this.addColoringForNode(identifier, METHOD_INVOCATION_SET);
            }
            super.visit(node);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (node.isAnonymous()) {
                this.addToPath(node);
                this.typeInfo = new ClassInstanceCreationTypeInfo(node);
                this.scan(node.getSuperClass());
                this.scan(node.getInterfaces());
                this.needToScan = new ArrayList<Block>();
                Block body = node.getBody();
                if (body != null) {
                    body.accept(this);
                    while (!this.needToScan.isEmpty()) {
                        Block block = this.needToScan.remove(0);
                        block.accept(this);
                    }
                    this.addColoringForUnusedPrivateConstants();
                    this.addColoringForUnusedPrivateFields();
                }
                this.removeFromPath();
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.typeInfo = new TypeDeclarationTypeInfo(node);
            Identifier name = node.getName();
            this.addColoringForNode(name, this.createTypeNameColoring(name));
            super.visit(node);
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.typeInfo = new TypeDeclarationTypeInfo(node);
            Identifier name = node.getName();
            this.addColoringForNode(name, this.createTypeNameColoring(name));
            this.needToScan = new ArrayList<Block>();
            if (node.getBody() != null) {
                node.getBody().accept(this);
                for (Block block : this.needToScan) {
                    block.accept(this);
                }
                this.addColoringForUnusedPrivateFields();
            }
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(node.getModifier());
            boolean isStatic = BodyDeclaration.Modifier.isStatic(node.getModifier());
            Variable[] variables = node.getVariableNames();
            for (int i = 0; i < variables.length; ++i) {
                Variable variable = variables[i];
                Set<ColoringAttributes> coloring = this.createFieldDeclarationColoring(variable, isStatic);
                if (!isPrivate || this.typeInfo.isTrait()) {
                    this.addColoringForNode(variable.getName(), coloring);
                    continue;
                }
                if (!(variable.getName() instanceof Identifier)) continue;
                Identifier identifier = (Identifier)variable.getName();
                this.privateFieldsUnused.put(new UnusedIdentifier(identifier.getName(), this.typeInfo), new ASTNodeColoring(identifier, coloring));
            }
            super.visit(node);
        }

        private Set<ColoringAttributes> createFieldDeclarationColoring(Variable variable, boolean isStatic) {
            EnumSet coloring;
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            boolean isDeprecated = this.isDeprecatedFieldDeclaration(variable);
            EnumSet enumSet = coloring = isDeprecated ? DEPRECATED_FIELD_SET : ColoringAttributes.FIELD_SET;
            if (isStatic) {
                coloring = isDeprecated ? DEPRECATED_STATIC_FIELD_SET : ColoringAttributes.STATIC_FIELD_SET;
            }
            return coloring;
        }

        private boolean isDeprecatedFieldDeclaration(Variable variable) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                String variableName = CodeUtils.extractVariableName(variable);
                VariableScope variableScope = this.model.getVariableScope(variable.getStartOffset());
                QualifiedName typeFullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(this.typeInfo.getName()), variable.getStartOffset(), variableScope);
                for (FieldElement fieldElement : this.getDeprecatedFields()) {
                    if (!fieldElement.getName().equals(variableName) || !fieldElement.getType().getFullyQualifiedName().equals(typeFullyQualifiedName)) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(FieldAccess node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (!node.getField().isDollared()) {
                new FieldAccessVisitor(ColoringAttributes.FIELD_SET).scan(node.getField().getName());
            }
            this.scan(node.getField());
            super.scan(node.getDispatcher());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            FunctionName fnName = node.getMethod().getFunctionName();
            if (fnName.getName() instanceof Identifier) {
                Identifier identifier = (Identifier)fnName.getName();
                String name = identifier.getName().toLowerCase();
                ASTNodeColoring item = this.privateUnusedMethods.remove(new UnusedIdentifier(name, this.typeInfo));
                if (item != null) {
                    this.addColoringForNode(item.identifier, item.coloring);
                }
            } else if (fnName.getName() instanceof Variable) {
                Variable variable;
                VariableBase expr = variable = (Variable)fnName.getName();
                if (variable instanceof ArrayAccess) {
                    ArrayAccess arrayAccess = (ArrayAccess)variable;
                    expr = arrayAccess.getName();
                }
                if (variable.isDollared() || variable instanceof ArrayAccess) {
                    new FieldAccessVisitor(ColoringAttributes.STATIC_FIELD_SET).scan(expr);
                    super.visit(node);
                    return;
                }
            }
            this.addColoringForNode(fnName, STATIC_METHOD_INVOCATION_SET);
            super.visit(node);
        }

        @Override
        public void visit(PHPVarComment node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            int start = node.getVariable().getStartOffset();
            int end = start + 4;
            int startTranslated = this.snapshot.getOriginalOffset(start);
            if (startTranslated > -1) {
                int endTranslated = startTranslated + end - start;
                this.highlights.put(new OffsetRange(startTranslated, endTranslated), ANNOTATION_TYPE_SET);
            }
        }

        @Override
        public void visit(StaticFieldAccess node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Expression expr = node.getField().getName();
            if (expr instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)expr;
                expr = arrayAccess.getName();
            }
            new FieldAccessVisitor(ColoringAttributes.STATIC_FIELD_SET).scan(expr);
            super.visit(node);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            ASTNode parentNode = null;
            List<ASTNode> path = this.getPath();
            if (path != null && path.size() > 1) {
                parentNode = path.get(1);
            }
            if (parentNode instanceof ClassDeclaration || parentNode instanceof InterfaceDeclaration || parentNode instanceof ClassInstanceCreation) {
                boolean isPrivate = BodyDeclaration.Modifier.isPrivate(node.getModifier());
                List<Identifier> names = node.getNames();
                for (Identifier identifier : names) {
                    Set<ColoringAttributes> coloring = this.createConstantDeclarationColoring(identifier);
                    if (!isPrivate) {
                        this.addColoringForNode(identifier, coloring);
                        continue;
                    }
                    this.privateUnusedConstants.put(new UnusedIdentifier(identifier.getName(), this.typeInfo), new ASTNodeColoring(identifier, coloring));
                }
            }
            super.visit(node);
        }

        private Set<ColoringAttributes> createConstantDeclarationColoring(Identifier constantName) {
            if (SemanticAnalysis.this.isCancelled()) {
                return Collections.EMPTY_SET;
            }
            return this.isDeprecatedConstantDeclaration(constantName) ? DEPRECATED_STATIC_FIELD_SET : ColoringAttributes.STATIC_FIELD_SET;
        }

        private boolean isDeprecatedConstantDeclaration(Identifier constantName) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                VariableScope variableScope = this.model.getVariableScope(constantName.getStartOffset());
                QualifiedName typeFullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(this.typeInfo.getName()), constantName.getStartOffset(), variableScope);
                for (TypeConstantElement constantElement : this.getDeprecatedConstants()) {
                    if (!constantElement.getName().equals(constantName.getName()) || !constantElement.getType().getFullyQualifiedName().equals(typeFullyQualifiedName)) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(StaticConstantAccess node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier constant = node.getConstantName();
            if (constant != null) {
                ASTNodeColoring item = this.privateUnusedConstants.remove(new UnusedIdentifier(constant.getName(), this.typeInfo));
                if (item != null) {
                    this.addColoringForNode(item.identifier, item.coloring);
                }
                this.addColoringForNode(constant, ColoringAttributes.STATIC_FIELD_SET);
            }
            super.visit(node);
        }

        @Override
        public void visit(PHPDocTypeNode node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (this.isDeprecatedTypeNode(node)) {
                this.addColoringForNode(node, DEPRECATED_SET);
            }
        }

        private boolean isDeprecatedTypeNode(PHPDocTypeNode node) {
            return this.isDeprecatedType(QualifiedName.create(node.getValue()), node.getStartOffset());
        }

        @Override
        public void visit(NamespaceName node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (this.isDeprecatedNamespaceName(node)) {
                this.addColoringForNode(node, DEPRECATED_SET);
            }
        }

        private boolean isDeprecatedNamespaceName(NamespaceName node) {
            return this.isDeprecatedType(QualifiedName.create(node), node.getStartOffset());
        }

        private boolean isDeprecatedType(QualifiedName qualifiedName, int offset) {
            boolean isDeprecated = false;
            if (!SemanticAnalysis.this.isCancelled() && SemanticAnalysis.this.isResolveDeprecatedElements()) {
                VariableScope variableScope = this.model.getVariableScope(offset);
                QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(qualifiedName, offset, variableScope);
                for (TypeElement typeElement : this.getDeprecatedTypes()) {
                    if (!typeElement.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
                    isDeprecated = true;
                    break;
                }
            }
            return isDeprecated;
        }

        @Override
        public void visit(UseStatement node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            List<UseStatementPart> parts = node.getParts();
            for (int i = 0; i < parts.size(); ++i) {
                UseStatementPart useStatementPart = parts.get(i);
                if (useStatementPart instanceof SingleUseStatementPart) {
                    SingleUseStatementPart singleUseStatementPart = (SingleUseStatementPart)useStatementPart;
                    if (!this.isDeprecatedNamespaceName(singleUseStatementPart.getName())) continue;
                    this.addColoringForNode(singleUseStatementPart.getName(), DEPRECATED_SET);
                    continue;
                }
                if (useStatementPart instanceof GroupUseStatementPart) {
                    GroupUseStatementPart groupUseStatementPart = (GroupUseStatementPart)useStatementPart;
                    for (SingleUseStatementPart item : groupUseStatementPart.getItems()) {
                        if (!this.isDeprecatedNamespaceName(CodeUtils.compoundName(groupUseStatementPart, item, true))) continue;
                        this.addColoringForNode(item.getName(), DEPRECATED_SET);
                    }
                    continue;
                }
                assert (false) : "Unexpected class type: " + useStatementPart.getClass().getName();
            }
        }

        private class UnusedIdentifier {
            private final String name;
            private final TypeInfo typeInfo;

            UnusedIdentifier(String name, TypeInfo typeInfo) {
                this.name = name;
                this.typeInfo = typeInfo;
            }

            public int hashCode() {
                int hash = 5;
                hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
                hash = 29 * hash + (this.typeInfo != null ? this.typeInfo.hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                UnusedIdentifier other = (UnusedIdentifier)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return this.typeInfo == other.typeInfo || this.typeInfo != null && this.typeInfo.equals(other.typeInfo);
            }
        }

        private class FieldAccessVisitor
        extends DefaultVisitor {
            private final Set<ColoringAttributes> coloring;

            public FieldAccessVisitor(Set<ColoringAttributes> coloring) {
                this.coloring = coloring;
            }

            @Override
            public void visit(ArrayAccess node) {
                super.scan(node.getName());
            }

            @Override
            public void visit(Identifier identifier) {
                ASTNodeColoring removed = (ASTNodeColoring)SemanticHighlightVisitor.this.privateFieldsUnused.remove(new UnusedIdentifier(identifier.getName(), SemanticHighlightVisitor.this.typeInfo));
                if (removed != null) {
                    SemanticHighlightVisitor.this.addColoringForNode(removed.identifier, removed.coloring);
                }
                SemanticHighlightVisitor.this.addColoringForNode(identifier, this.coloring);
            }
        }

        private class ASTNodeColoring {
            public ASTNode identifier;
            public Set<ColoringAttributes> coloring;

            public ASTNodeColoring(ASTNode identifier, Set<ColoringAttributes> coloring) {
                this.identifier = identifier;
                this.coloring = coloring;
            }
        }
    }
}

