/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;

public final class FreePlaceNodesLayouter {
    PageFlowSceneListener pfsl = new PageFlowSceneListener();
    PageFlowObjectSceneListener pfosl = new PageFlowObjectSceneListener();
    final PageFlowScene scene;
    private final Map<String, Point> positions = new HashMap<String, Point>();
    private final int SEP_X = 250;
    private final int SEP_Y = 150;
    private static final UnsupportedOperationException uoe = new UnsupportedOperationException("Not supported yet");
    private final Collection<Page> nodesAdded = new HashSet<Page>();

    public FreePlaceNodesLayouter(PageFlowScene scene) {
        this(scene, false);
    }

    public static final void performLayout(PageFlowScene scene) {
        FreePlaceNodesLayouter layout = new FreePlaceNodesLayouter(scene, true);
        Collection pages = scene.getNodes();
        for (Page page : pages) {
            Widget widget = scene.findWidget(page);
            widget.setPreferredLocation(null);
        }
        scene.validate();
        layout.layoutNodesLocations(scene, scene.getNodes());
        scene.validate();
    }

    public void registerListeners(PageFlowScene scene) {
        scene.addSceneListener(this.pfsl);
        scene.addObjectSceneListener(this.pfosl, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
    }

    public void unregisterListeners(PageFlowScene scene) {
        scene.removeSceneListener(this.pfsl);
        scene.removeObjectSceneListener(this.pfosl, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
    }

    private FreePlaceNodesLayouter(PageFlowScene scene, boolean isOneTimeUse) {
        this.scene = scene;
        if (!isOneTimeUse) {
            this.registerListeners(scene);
        }
    }

    public FreePlaceNodesLayouter(PageFlowScene scene, Rectangle visibleRectangle) {
        this(scene);
    }

    public void layoutNodesLocations(PageFlowScene scene, Collection<Page> nodes) {
        Collection allNodes = scene.getNodes();
        for (Page node : nodes) {
            Widget nodeWidget = scene.findWidget(node);
            if (nodeWidget == null) {
                return;
            }
            if (nodeWidget.getPreferredLocation() != null) {
                this.positions.put(node.getDisplayName(), nodeWidget.getPreferredLocation());
                continue;
            }
            Point point = this.positions.get(node.getDisplayName());
            if (point == null) {
                point = this.getNewComponentLocation(scene, this.positions, allNodes);
            }
            this.positions.put(node.getDisplayName(), point);
            nodeWidget.setPreferredLocation(point);
        }
    }

    public void addNode(Page node) {
        this.nodesAdded.add(node);
    }

    private Point getNewComponentLocation(PageFlowScene scene, Map positions, Collection<Page> nodes) {
        int a = 0;
        while (true) {
            for (int b = 0; b <= a; ++b) {
                int x = 150 + 250 * (a - b);
                int y = 150 * (1 + b);
                if (!this.isThereEmptyPlace(scene, positions, nodes, x, y)) continue;
                return new Point(x, y);
            }
            ++a;
        }
    }

    private boolean isThereEmptyPlace(PageFlowScene scene, Map positions, Collection<Page> nodes, int x, int y) {
        Rectangle rectangle = new Rectangle(x, y, 100, 150);
        if (nodes != null) {
            for (Page node : nodes) {
                Point location = (Point)positions.get(node.getDisplayName());
                if (location == null) {
                    location = scene.findWidget(node).getLocation();
                }
                if (location != null && rectangle.contains(location)) {
                    return false;
                }
                Rectangle bounds = scene.findWidget(node).getBounds();
                if (bounds == null || !rectangle.contains(bounds)) continue;
                return false;
            }
        }
        return true;
    }

    private class PageFlowSceneListener
    implements Scene.SceneListener {
        private PageFlowSceneListener() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
        }

        public void sceneValidated() {
            if (!FreePlaceNodesLayouter.this.nodesAdded.isEmpty()) {
                FreePlaceNodesLayouter.this.layoutNodesLocations(FreePlaceNodesLayouter.this.scene, FreePlaceNodesLayouter.this.nodesAdded);
                FreePlaceNodesLayouter.this.nodesAdded.clear();
            }
        }
    }

    private class PageFlowObjectSceneListener
    implements ObjectSceneListener {
        private PageFlowObjectSceneListener() {
        }

        public void objectAdded(ObjectSceneEvent event, Object addedObject) {
            if (((PageFlowScene)event.getObjectScene()).isNode(addedObject)) {
                FreePlaceNodesLayouter.this.nodesAdded.add((Page)addedObject);
            }
        }

        public void objectRemoved(ObjectSceneEvent event, Object removedObject) {
            throw uoe;
        }

        public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState prevState, ObjectState newState) {
            throw uoe;
        }

        public void selectionChanged(ObjectSceneEvent event, Set<Object> prevSelection, Set<Object> newSelection) {
            throw uoe;
        }

        public void highlightingChanged(ObjectSceneEvent event, Set<Object> prevHighlighting, Set<Object> newHighlighting) {
            throw uoe;
        }

        public void hoverChanged(ObjectSceneEvent event, Object prevHoveredObject, Object newHoveredObject) {
            throw uoe;
        }

        public void focusChanged(ObjectSceneEvent event, Object prevFocusedObject, Object newFocusedObject) {
            throw uoe;
        }
    }
}

