/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.dev;

import com.sun.istack.logging.Logger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class WSATRuntimeConfig {
    private static final Logger LOGGER = Logger.getLogger(WSATRuntimeConfig.class);
    private static final Lock DATA_LOCK = new ReentrantLock();
    private static WSATRuntimeConfig instance;
    private static boolean isWsatRecoveryEnabled;
    private static TxlogLocationProvider txLogLocationProvider;
    private static boolean isWsatSslEnabled;
    private static boolean isRollbackOnFailedPrepare;
    private static String domainName;
    private static String hostName;
    private static int httpPort;
    private static int httpsPort;
    private static RecoveryEventListener wsatRecoveryEventListener;

    private WSATRuntimeConfig() {
    }

    public static Initializer initializer() {
        DATA_LOCK.lock();
        return new Initializer();
    }

    public static WSATRuntimeConfig getInstance() {
        DATA_LOCK.lock();
        try {
            if (instance == null) {
                instance = new WSATRuntimeConfig();
            }
            WSATRuntimeConfig wSATRuntimeConfig = instance;
            return wSATRuntimeConfig;
        }
        finally {
            DATA_LOCK.unlock();
        }
    }

    public boolean isWSATRecoveryEnabled() {
        return isWsatRecoveryEnabled;
    }

    public String getHostAndPort() {
        return isWsatSslEnabled ? "https://" + hostName + ":" + httpsPort : "http://" + hostName + ":" + httpPort;
    }

    public static String getDomainName() {
        return domainName;
    }

    public static String getHostName() {
        return hostName;
    }

    public static int getHttpPort() {
        return httpPort;
    }

    public static int getHttpsPort() {
        return httpsPort;
    }

    public String getTxLogLocation() {
        return txLogLocationProvider == null ? null : txLogLocationProvider.getTxLogLocation();
    }

    public boolean isRollbackOnFailedPrepare() {
        return isRollbackOnFailedPrepare;
    }

    public void setWSATRecoveryEventListener(RecoveryEventListener WSATRecoveryEventListener2) {
        wsatRecoveryEventListener = WSATRecoveryEventListener2;
    }

    static {
        isWsatRecoveryEnabled = Boolean.valueOf(System.getProperty("wsat.recovery.enabled", "true"));
        isWsatSslEnabled = Boolean.valueOf(System.getProperty("wsat.ssl.enabled", "false"));
        isRollbackOnFailedPrepare = Boolean.valueOf(System.getProperty("wsat.rollback.on.failed.prepare", "true"));
        domainName = "domain1";
        hostName = "localhost";
        httpPort = 8080;
        httpsPort = 8181;
    }

    public class WSATRecoveryEventListener
    implements RecoveryEventListener {
        @Override
        public void beforeRecovery(boolean delegated, String instance) {
            if (wsatRecoveryEventListener != null) {
                wsatRecoveryEventListener.beforeRecovery(delegated, instance);
            }
        }

        @Override
        public void afterRecovery(boolean success, boolean delegated, String instance) {
            if (wsatRecoveryEventListener != null) {
                wsatRecoveryEventListener.afterRecovery(success, delegated, instance);
            }
        }
    }

    public static interface RecoveryEventListener {
        public void beforeRecovery(boolean var1, String var2);

        public void afterRecovery(boolean var1, boolean var2, String var3);
    }

    public static interface TxlogLocationProvider {
        public String getTxLogLocation();
    }

    public static final class Initializer {
        private Initializer() {
        }

        public Initializer domainName(String value) {
            domainName = value;
            return this;
        }

        public Initializer hostName(String value) {
            hostName = value;
            return this;
        }

        public Initializer httpPort(String value) {
            if (value != null && value.trim().length() > 0) {
                httpPort = Integer.parseInt(value.trim());
            } else {
                LOGGER.config(String.format("Could not set HTTP port value to '%1s'. Rolling back to default: %2d", value, httpPort));
            }
            return this;
        }

        public Initializer httpsPort(String value) {
            if (value != null && value.trim().length() > 0) {
                httpsPort = Integer.parseInt(value.trim());
            } else {
                LOGGER.config(String.format("Could not set HTTPS port value to '%1s'. Rolling back to default: %2d", value, httpsPort));
            }
            return this;
        }

        public Initializer txLogLocation(TxlogLocationProvider provider) {
            txLogLocationProvider = provider;
            return this;
        }

        public Initializer enableWsatRecovery(boolean value) {
            isWsatRecoveryEnabled = value;
            return this;
        }

        public Initializer enableWsatSsl(boolean value) {
            isWsatSslEnabled = value;
            return this;
        }

        public Initializer enableRollbackOnFailedPrepare(boolean value) {
            isRollbackOnFailedPrepare = value;
            return this;
        }

        public void done() {
            DATA_LOCK.unlock();
        }
    }
}

