/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import java.lang.reflect.Field;
import java.util.Map;
import org.netbeans.processtreekiller.ProcessTreeKiller;
import org.netbeans.processtreekiller.UnixProcess;
import org.netbeans.processtreekiller.UnixSystem;

abstract class Unix<S extends UnixSystem<?>>
extends ProcessTreeKiller {
    private static final Field PID_FIELD;

    Unix() {
    }

    protected abstract S createSystem();

    @Override
    public void kill(Process proc, Map<String, String> modelEnvVars) {
        S system = this.createSystem();
        if (proc != null) {
            Object p;
            try {
                p = ((UnixSystem)system).get((Integer)PID_FIELD.get(proc));
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
            if (p == null) {
                proc.destroy();
            } else {
                ((UnixProcess)p).killRecursively();
                proc.destroy();
            }
        }
        if (modelEnvVars != null) {
            for (UnixProcess lp : system) {
                if (!this.hasMatchingEnvVars(lp.getEnvVars(), modelEnvVars)) continue;
                lp.killRecursively();
            }
        }
    }

    static {
        Field pidField;
        try {
            Class<?> clazz = Class.forName("java.lang.UNIXProcess");
            pidField = clazz.getDeclaredField("pid");
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            LinkageError x = new LinkageError();
            x.initCause(e);
            throw x;
        }
        PID_FIELD = pidField;
        PID_FIELD.setAccessible(true);
    }
}

