/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.ContainerItemSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.JaxRsConfigurationPanel;
import org.netbeans.modules.websvc.rest.wizard.SingletonSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PatternResourcesSetupPanel
extends AbstractPanel {
    private JComponent component;
    private Pattern currentPattern = Pattern.CONTAINER;
    private String[] allWizardSteps;
    private int indexInAllSteps = 2;

    public PatternResourcesSetupPanel(String name, WizardDescriptor wizardDescriptor) {
        super(name, wizardDescriptor);
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    public void setCurrentPattern(Pattern pattern) {
        if (this.currentPattern != pattern) {
            this.component = null;
            this.currentPattern = pattern;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.currentPattern.createUI(this.panelName);
            if (this.allWizardSteps != null) {
                this.component.putClientProperty("WizardPanel_contentData", this.allWizardSteps);
                this.component.putClientProperty("WizardPanel_contentSelectedIndex", this.indexInAllSteps);
            }
            this.component.setName(this.panelName);
            ((AbstractPanel.Settings)((Object)this.component)).addChangeListener(this);
        }
        return this.component;
    }

    void saveStepsAndIndex() {
        if (this.component != null) {
            this.allWizardSteps = (String[])this.component.getClientProperty("WizardPanel_contentData");
            this.indexInAllSteps = (Integer)this.component.getClientProperty("WizardPanel_contentSelectedIndex");
        }
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PatternResourcesSetupPanel.class.getCanonicalName() + "." + (Object)((Object)this.currentPattern));
    }

    static class PatternPanel
    extends JPanel
    implements AbstractPanel.Settings,
    SourcePanel {
        private static final long serialVersionUID = -5802330662876130253L;
        private AbstractPanel.Settings mainPanel;
        private JaxRsConfigurationPanel jaxRsConfigurationPanel;

        PatternPanel(String name, Pattern pattern) {
            JPanel panel = null;
            switch (pattern) {
                case CONTAINER: 
                case CLIENTCONTROLLED: {
                    panel = new ContainerItemSetupPanelVisual(name);
                    break;
                }
                case STANDALONE: {
                    panel = new SingletonSetupPanelVisual(name);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.setLayout(new BoxLayout(this, 1));
            this.add(panel);
            this.mainPanel = panel;
            this.jaxRsConfigurationPanel = new JaxRsConfigurationPanel(this);
            this.mainPanel.addChangeListener(this.jaxRsConfigurationPanel);
            this.add(this.jaxRsConfigurationPanel);
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    final 1 listener = this;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Component[] components;
                            double height = 0.0;
                            for (Component component : components = this.getComponents()) {
                                double renderedHeight;
                                if (component instanceof SingletonSetupPanelVisual) {
                                    renderedHeight = ((SingletonSetupPanelVisual)component).getRenderedHeight();
                                    height += renderedHeight;
                                    this.resize(component, renderedHeight);
                                    continue;
                                }
                                if (component instanceof ContainerItemSetupPanelVisual) {
                                    renderedHeight = ((ContainerItemSetupPanelVisual)component).getRenderedHeight();
                                    height += renderedHeight;
                                    this.resize(component, renderedHeight);
                                    continue;
                                }
                                if (!(component instanceof JaxRsConfigurationPanel)) continue;
                                renderedHeight = ((JaxRsConfigurationPanel)component).getRenderedHeight();
                                height += renderedHeight;
                                this.resize(component, renderedHeight);
                            }
                            Dimension dim = this.getSize();
                            int newHeight = (int)height;
                            if (dim.height < newHeight) {
                                this.setPreferredSize(new Dimension(dim.width, newHeight));
                                Window window = SwingUtilities.getWindowAncestor(this);
                                if (window != null) {
                                    window.pack();
                                }
                            }
                            this.removeHierarchyListener(listener);
                        }
                    });
                }
            });
        }

        @Override
        public SourceGroup getSourceGroup() {
            return ((SourcePanel)((Object)this.mainPanel)).getSourceGroup();
        }

        @Override
        public String getPackageName() {
            return ((SourcePanel)((Object)this.mainPanel)).getPackageName();
        }

        @Override
        public void read(final WizardDescriptor wizard) {
            this.mainPanel.read(wizard);
            Project project = Templates.getProject((WizardDescriptor)wizard);
            final RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            if (restSupport.isEE5() && restSupport.hasJersey1(true) || restSupport.hasSpringSupport() && !restSupport.hasJersey2(true)) {
                wizard.putProperty("useJersey", (Object)true);
            }
            if (this.jaxRsConfigurationPanel != null) {
                ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean configured = restSupport.isRestSupportOn();
                        if (!configured) {
                            configured = restSupport.hasJerseyServlet();
                        }
                        if (!configured) {
                            List restApplications = restSupport.getRestApplications();
                            configured = restApplications != null && !restApplications.isEmpty();
                        }
                        this.configureJaxRsConfigurationPanel(configured, wizard);
                    }
                }, (String)NbBundle.getMessage(PatternResourcesSetupPanel.class, (String)"LBL_SearchAppConfig"));
            }
        }

        @Override
        public void store(WizardDescriptor wizard) {
            this.mainPanel.store(wizard);
            if (this.hasJaxRsConfigurationPanel()) {
                this.jaxRsConfigurationPanel.store(wizard);
            }
        }

        @Override
        public boolean valid(WizardDescriptor wizard) {
            boolean isValid = this.mainPanel.valid(wizard);
            if (isValid && this.hasJaxRsConfigurationPanel()) {
                return this.jaxRsConfigurationPanel.valid(wizard);
            }
            return isValid;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.mainPanel.addChangeListener(l);
            if (this.hasJaxRsConfigurationPanel()) {
                this.jaxRsConfigurationPanel.addChangeListener(l);
            }
        }

        private void resize(Component component, double height) {
            Dimension size = component.getSize();
            if ((double)size.height < height) {
                component.setPreferredSize(new Dimension(size.width, (int)height));
            }
        }

        private boolean hasJaxRsConfigurationPanel() {
            return this.jaxRsConfigurationPanel != null;
        }

        private void configureJaxRsConfigurationPanel(boolean remove, WizardDescriptor wizard) {
            if (this.jaxRsConfigurationPanel == null) {
                return;
            }
            if (remove) {
                this.remove(this.jaxRsConfigurationPanel);
                this.jaxRsConfigurationPanel = null;
            } else {
                this.jaxRsConfigurationPanel.read(wizard);
            }
        }
    }

    public static enum Pattern {
        CONTAINER,
        STANDALONE,
        CLIENTCONTROLLED;


        public JComponent createUI(String name) {
            return new PatternPanel(name, this);
        }
    }
}

