/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.nb;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.Schedulers;
import org.netbeans.modules.parsing.implspi.EnvironmentFactory;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.netbeans.modules.parsing.implspi.SourceEnvironment;
import org.netbeans.modules.parsing.nb.CurrentDocumentScheduler;
import org.netbeans.modules.parsing.nb.CursorSensitiveScheduler;
import org.netbeans.modules.parsing.nb.EventSupport;
import org.netbeans.modules.parsing.nb.SelectedNodesScheduler;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class DataObjectEnvFactory
implements EnvironmentFactory {
    private static Map<String, Reference<Parser>> cachedParsers = new HashMap<String, Reference<Parser>>();

    public Lookup getContextLookup() {
        return Lookup.getDefault();
    }

    public Collection<? extends Scheduler> getSchedulers(Lookup context) {
        return Schedulers.getSchedulers();
    }

    public Parser findMimeParser(Lookup context, String mimeType) {
        Parser p = null;
        Reference<Parser> ref = cachedParsers.get(mimeType);
        if (ref != null) {
            p = ref.get();
        }
        if (p == null) {
            Lookup lookup = MimeLookup.getLookup((String)mimeType);
            ParserFactory parserFactory = (ParserFactory)lookup.lookup(ParserFactory.class);
            if (parserFactory == null) {
                throw new IllegalArgumentException("No parser for mime type: " + mimeType);
            }
            p = parserFactory.createParser(Collections.emptyList());
            cachedParsers.put(mimeType, new SoftReference<Parser>(p));
        }
        return p;
    }

    public Class<? extends Scheduler> findStandardScheduler(String schedulerName) {
        switch (schedulerName) {
            case "CURSOR_SENSITIVE_TASK_SCHEDULER": {
                return CursorSensitiveScheduler.class;
            }
            case "EDITOR_SENSITIVE_TASK_SCHEDULER": {
                return CurrentDocumentScheduler.class;
            }
            case "SELECTED_NODES_SENSITIVE_TASK_SCHEDULER": {
                return SelectedNodesScheduler.class;
            }
        }
        return null;
    }

    static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    public <T> T runPriorityIO(Callable<T> r) throws Exception {
        assert (r != null);
        return (T)ProvidedExtensions.priorityIO(r);
    }

    public SourceEnvironment createEnvironment(Source src, SourceControl control) {
        return new EventSupport(control);
    }
}

