/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.SearchUtil;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ExecSupport {
    private String lookFor;
    private OutputCopier[] copyMakers;
    private Thread t;
    private Connect connect;
    private Map<String, Runnable> outputStringHandlers = null;
    private String displayName;
    private Process child;

    public ExecSupport(Process child, String displayName) {
        this.displayName = displayName;
        this.child = child;
    }

    public void start() {
        InputOutput io = IOProvider.getDefault().getIO(this.displayName, false);
        try {
            io.getOut().reset();
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        io.select();
        this.copyMakers = new OutputCopier[3];
        this.copyMakers[0] = new OutputCopier(new InputStreamReader(this.child.getInputStream()), (Writer)io.getOut(), true, this.lookFor, this.outputStringHandlers);
        this.copyMakers[0].start();
        this.copyMakers[1] = new OutputCopier(new InputStreamReader(this.child.getErrorStream()), (Writer)io.getErr(), true, this.lookFor, this.outputStringHandlers);
        this.copyMakers[1].start();
        this.copyMakers[2] = new OutputCopier(io.getIn(), new OutputStreamWriter(this.child.getOutputStream()), true);
        this.copyMakers[2].start();
        new Thread(){

            @Override
            public void run() {
                try {
                    int ret = ExecSupport.this.child.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        ExecSupport.this.copyMakers[0].interrupt();
                        ExecSupport.this.copyMakers[1].interrupt();
                        ExecSupport.this.copyMakers[2].interrupt();
                    }
                    catch (Exception e) {
                        Logger.getLogger("global").log(Level.INFO, null, e);
                    }
                }
            }
        }.start();
    }

    public void setStringToLookFor(String lookFor) {
        this.lookFor = lookFor;
    }

    public void addOutputStringHandler(String string, Runnable handler) {
        if (this.outputStringHandlers == null) {
            this.outputStringHandlers = new HashMap<String, Runnable>();
        }
        this.outputStringHandlers.put(string, handler);
    }

    public boolean isStringFound() {
        if (this.copyMakers == null) {
            return false;
        }
        return this.copyMakers[0].stringFound() || this.copyMakers[1].stringFound() || this.copyMakers[2].stringFound();
    }

    public boolean waitForMessage(int timeout) {
        int retryTime = 10;
        this.connect = new Connect(retryTime);
        this.t = new Thread(this.connect);
        this.t.start();
        try {
            this.t.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.t.isAlive()) {
            this.connect.finishLoop();
            this.t.interrupt();
        }
        return this.connect.getStatus();
    }

    public boolean interruptWaiting() {
        if (this.t == null) {
            return false;
        }
        if (this.t.isAlive()) {
            this.connect.finishLoop();
            this.t.interrupt();
            return true;
        }
        return false;
    }

    public void terminate() {
        this.child.destroy();
    }

    private class Connect
    implements Runnable {
        int retryTime;
        boolean status = false;
        boolean loop = true;

        public Connect(int retryTime) {
            this.retryTime = retryTime;
        }

        public void finishLoop() {
            this.loop = false;
        }

        @Override
        public void run() {
            while (this.loop) {
                if (ExecSupport.this.isStringFound()) {
                    this.status = true;
                    break;
                }
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;
        private String stringToLookFor;
        private boolean stringFound = false;
        private Map<String, Runnable> outputStreamHandlers;
        private static final int FOUND = -1;

        public OutputCopier(Reader is, Writer os, boolean b, String lookFor, Map<String, Runnable> outputStreamHandlers) {
            this.os = os;
            this.is = is;
            this.autoflush = b;
            this.stringToLookFor = lookFor;
            this.outputStreamHandlers = outputStreamHandlers;
        }

        public OutputCopier(Reader is, Writer os, boolean b) {
            this(is, os, b, null, null);
        }

        public boolean stringFound() {
            return this.stringFound;
        }

        @Override
        public void run() {
            int stringFoundChars = 0;
            HashMap<String, Integer> stringFoundCharsMap = this.outputStreamHandlers != null ? new HashMap<String, Integer>() : null;
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    if (this.stringToLookFor != null && (stringFoundChars = SearchUtil.checkForString(this.stringToLookFor, stringFoundChars, buff, read)) == -1) {
                        this.stringToLookFor = null;
                        this.stringFound = true;
                    }
                    if (this.outputStreamHandlers != null) {
                        this.checkOutputHandlers(stringFoundCharsMap, buff, read);
                    }
                    if (this.os == null) continue;
                    this.os.write(buff, 0, read);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        private void checkOutputHandlers(Map<String, Integer> stringFoundCharsMap, char[] buff, int read) {
            assert (this.outputStreamHandlers != null);
            for (Map.Entry<String, Runnable> e : this.outputStreamHandlers.entrySet()) {
                Integer alreadyFoundOb = stringFoundCharsMap.get(e.getKey());
                int alreadyFound = alreadyFoundOb == null ? 0 : alreadyFoundOb;
                int found = SearchUtil.checkForString(e.getKey(), alreadyFound, buff, read);
                if (found == -1) {
                    stringFoundCharsMap.remove(e.getKey());
                    e.getValue().run();
                    continue;
                }
                if (found > 0) {
                    stringFoundCharsMap.put(e.getKey(), found);
                    continue;
                }
                if (found != 0) continue;
                stringFoundCharsMap.remove(e.getKey());
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            while (!is.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return is.read(buff, start, count);
        }
    }
}

