/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMRFieldNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CMFieldChildren
extends Children.Keys<CommonDDBean>
implements PropertyChangeListener {
    private final EntityMethodController controller;
    private final Entity model;
    private final EjbJar ejbJar;
    private final FileObject ddFile;

    public CMFieldChildren(EntityMethodController controller, Entity model, FileObject ddFile) throws IOException {
        this.model = model;
        this.controller = controller;
        this.ejbJar = DDProvider.getDefault().getDDRoot(ddFile);
        this.ddFile = ddFile;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CMFieldChildren.this.controller.getBeanClass() == null) {
                    CMFieldChildren.this.setKeys(Collections.emptySet());
                } else {
                    List keys = CMFieldChildren.this.getCmrFields(CMFieldChildren.this.model.getEjbName());
                    CmpField[] cmpFields = CMFieldChildren.this.model.getCmpField();
                    Arrays.sort(cmpFields, new Comparator<CmpField>(){

                        @Override
                        public int compare(CmpField cmpField1, CmpField cmpField2) {
                            String fieldName1 = cmpField1.getFieldName();
                            String fieldName2 = cmpField2.getFieldName();
                            if (fieldName1 == null) {
                                fieldName1 = "";
                            }
                            if (fieldName2 == null) {
                                fieldName2 = "";
                            }
                            return fieldName1.compareTo(fieldName2);
                        }
                    });
                    keys.addAll(Arrays.asList(cmpFields));
                    CMFieldChildren.this.setKeys(keys);
                }
            }
        });
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(CommonDDBean key) {
        Node[] nodes = null;
        if (key instanceof CmpField) {
            CmpField field = (CmpField)key;
            CMPFieldNode node = new CMPFieldNode(field, this.controller, this.ddFile);
            nodes = new Node[]{node};
        } else if (key instanceof CmrField) {
            CmrField field = (CmrField)key;
            CMRFieldNode node = new CMRFieldNode(field, this.controller, this.ddFile);
            nodes = new Node[]{node};
        }
        return nodes;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }

    private CmrField getCmrField(EjbRelationshipRole role, String ejbName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName()) && role.getCmrField() != null ? role.getCmrField() : null;
    }

    private void getFields(String ejbName, List<CommonDDBean> list) {
        EjbRelation[] relations;
        Relationships relationships = this.ejbJar.getSingleRelationships();
        if (relationships != null && (relations = relationships.getEjbRelation()) != null) {
            for (int i = 0; i < relations.length; ++i) {
                CmrField cmrField = this.getCmrField(relations[i].getEjbRelationshipRole(), ejbName);
                if (cmrField != null) {
                    list.add((CommonDDBean)cmrField);
                }
                if ((cmrField = this.getCmrField(relations[i].getEjbRelationshipRole2(), ejbName)) == null) continue;
                list.add((CommonDDBean)cmrField);
            }
        }
    }

    private List<CommonDDBean> getCmrFields(String ejbName) {
        LinkedList<CommonDDBean> resultList = new LinkedList<CommonDDBean>();
        this.getFields(ejbName + "", resultList);
        return resultList;
    }
}

