/**
 * The CSSStyleDeclaration interface represents a single CSS declaration block. This interface may be used to determine the style properties currently set in a block or to set style properties explicitly within the block.While an implementation may not recognize all CSS properties within a CSS declaration block, it is expected to provide access to all specified properties in the style sheet through the CSSStyleDeclaration interface. Furthermore, implementations that support a specific level of CSS should correctly handle CSS shorthand properties for that level. For a further discussion of shorthand properties, see the CSS2Properties interface.This interface is also used to provide a read-only access to the computed values of an element. See also the ViewCSS interface.Note: The CSS Object Model doesn't provide an access to the specified or actual values of the CSS cascade.
 */
var CSSStyleDeclaration = {
}
/**
 * The CSS rule that contains this declaration block or null if this CSSStyleDeclaration is not attached to a CSSRule.
 * @syntax cSSStyleDeclaration.parentRule
 * @returns {CSSRule} 
 */
CSSStyleDeclaration.prototype.parentRule = new CSSRule();

/**
 * Used to retrieve the properties that have been explicitly set in this declaration block.
 * @syntax cSSStyleDeclaration.item(index)
 * @param {Number} index Index of the property name to retrieve.
 * @returns {String} The name of the property at this ordinal position. The empty string if no property exists at this position.
 */
CSSStyleDeclaration.prototype.item = function(index) {};

/**
 * The parsable textual representation of the declaration block (excluding the surrounding curly braces). Setting this attribute will result in the parsing of the new value and resetting of all the properties in the declaration block including the removal or addition of properties. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified CSS string value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this declaration is readonly or a property is readonly.
 * @syntax cSSStyleDeclaration.cssText
 * @returns {String} 
 */
CSSStyleDeclaration.prototype.cssText = new String();

/**
 * The number of properties that have been explicitly set in this declaration block. The range of valid indices is 0 to length-1 inclusive.
 * @syntax cSSStyleDeclaration.length
 * @returns {Number} 
 */
CSSStyleDeclaration.prototype.length = new Number();

/**
 * Used to retrieve the object representation of the value of a CSS property if it has been explicitly set within this declaration block. This method returns null if the property is a shorthand property. Shorthand property values can only be accessed and modified as strings, using the getPropertyValue and setProperty methods.
 * @syntax cSSStyleDeclaration.getPropertyCSSValue(propertyName)
 * @param {String} propertyName The name of the CSS property. See the CSS property index.
 * @returns {CSSValue} Returns the value of the property if it has been explicitly set for this declaration block. Returns null if the property has not been set.
 */
CSSStyleDeclaration.prototype.getPropertyCSSValue = function(propertyName) {};

/**
 * Used to retrieve the value of a CSS property if it has been explicitly set within this declaration block.
 * @syntax cSSStyleDeclaration.getPropertyValue(propertyName)
 * @param {String} propertyName The name of the CSS property. See the CSS property index.
 * @returns {String} Returns the value of the property if it has been explicitly set for this declaration block. Returns the empty string if the property has not been set.
 */
CSSStyleDeclaration.prototype.getPropertyValue = function(propertyName) {};

/**
 * Used to set a property value and priority within this declaration block.
 * @syntax cSSStyleDeclaration.setProperty(propertyName, value, priority)
 * @param {String} propertyName The name of the CSS property. See the CSS property index.
 * @param {String} value The new value of the property.
 * @param {String} priority The new priority of the property (e.g. "important").
 * @returns {undefined} 
 */
CSSStyleDeclaration.prototype.setProperty = function(propertyName,  value,  priority) {};

/**
 * Used to retrieve the priority of a CSS property (e.g. the "important" qualifier) if the property has been explicitly set in this declaration block.
 * @syntax cSSStyleDeclaration.getPropertyPriority(propertyName)
 * @param {String} propertyName The name of the CSS property. See the CSS property index.
 * @returns {String} A string representing the priority (e.g. "important") if one exists. The empty string if none exists.
 */
CSSStyleDeclaration.prototype.getPropertyPriority = function(propertyName) {};

/**
 * Used to remove a CSS property if it has been explicitly set within this declaration block.
 * @syntax cSSStyleDeclaration.removeProperty(propertyName)
 * @param {String} propertyName The name of the CSS property. See the CSS property index.
 * @returns {String} Returns the value of the property if it has been explicitly set for this declaration block. Returns the empty string if the property has not been set or the property name does not correspond to a known CSS property.
 */
CSSStyleDeclaration.prototype.removeProperty = function(propertyName) {};

/**
 * Represents the CSSStyleDeclaration prototype object.
 * @syntax CSSStyleDeclaration.prototype
 * @static
 */
CSSStyleDeclaration.prototype;

