/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notificators.Notificator;

public class NotificatorFirebase
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorFirebase.class);
    private final String url;
    private final String key;

    public NotificatorFirebase() {
        this("https://fcm.googleapis.com/fcm/send", Context.getConfig().getString(Keys.NOTIFICATOR_FIREBASE_KEY));
    }

    protected NotificatorFirebase(String url, String key) {
        this.url = url;
        this.key = key;
    }

    @Override
    public void sendSync(long userId, Event event, Position position) {
        User user = Context.getPermissionsManager().getUser(userId);
        if (user.getAttributes().containsKey("notificationTokens")) {
            Notification notification = new Notification();
            notification.body = NotificationFormatter.formatShortMessage(userId, event, position).trim();
            Message message = new Message();
            Message.access$102(message, user.getString("notificationTokens").split("[, ]"));
            message.notification = notification;
            Context.getClient().target(this.url).request().header("Authorization", (Object)("key=" + this.key)).async().post(Entity.json((Object)message), (InvocationCallback)new InvocationCallback<Object>(){

                public void completed(Object o) {
                }

                public void failed(Throwable throwable) {
                    LOGGER.warn("Firebase notification error", throwable);
                }
            });
        }
    }

    @Override
    public void sendAsync(long userId, Event event, Position position) {
        this.sendSync(userId, event, position);
    }

    public static class Message {
        @JsonProperty(value="registration_ids")
        private String[] tokens;
        @JsonProperty(value="notification")
        private Notification notification;

        static /* synthetic */ String[] access$102(Message x0, String[] x1) {
            x0.tokens = x1;
            return x1;
        }
    }

    public static class Notification {
        @JsonProperty(value="body")
        private String body;
    }
}

