import{RelatedIssue as t}from"../browser_sdk/browser_sdk.js";import{ParsedURL as e}from"../common/common.js";import{DataGrid as i}from"../data_grid/data_grid.js";import{i18n as s}from"../i18n/i18n.js";import{StringUtilities as o}from"../platform/platform.js";import{Runtime as r}from"../root/root.js";import{Cookie as a}from"../sdk/sdk.js";import{Widget as l,Tooltip as n,Icon as d}from"../ui/ui.js";const u={session:"Session",name:"Name",value:"Value",size:"Size",editableCookies:"Editable Cookies",cookies:"Cookies",na:"N/A",showRequestsWithThisCookie:"Show Requests With This Cookie",showIssueAssociatedWithThis:"Show issue associated with this cookie",sourcePortTooltip:"Shows the source port (range 1-65535) the cookie was set on. If the port is unknown, this shows -1.",sourceSchemeTooltip:"Shows the source scheme (`Secure`, `NonSecure`) the cookie was set on. If the scheme is unknown, this shows `Unset`."},c=s.registerUIStrings("cookie_table/CookiesTable.ts",u),h=s.getLocalizedString.bind(void 0,c),b=s.getLazilyComputedLocalizedString.bind(void 0,c)(u.session);class m extends l.VBox{constructor(t,e,s,o,l){super(),this.registerRequiredCSS("cookie_table/cookiesTable.css",{enableLegacyPatching:!0}),this.element.classList.add("cookies-table"),this._saveCallback=e,this._refreshCallback=s,this._deleteCallback=l;const n=Boolean(e),d=[{id:a.Attributes.Name,title:h(u.name),sortable:!0,disclosure:n,sort:i.Order.Ascending,longText:!0,weight:24,editable:n},{id:a.Attributes.Value,title:h(u.value),sortable:!0,longText:!0,weight:34,editable:n},{id:a.Attributes.Domain,title:"Domain",sortable:!0,weight:7,editable:n},{id:a.Attributes.Path,title:"Path",sortable:!0,weight:7,editable:n},{id:a.Attributes.Expires,title:"Expires / Max-Age",sortable:!0,weight:7,editable:n},{id:a.Attributes.Size,title:h(u.size),sortable:!0,align:i.Align.Right,weight:7},{id:a.Attributes.HttpOnly,title:"HttpOnly",sortable:!0,align:i.Align.Center,weight:7,dataType:i.DataType.Boolean,editable:n},{id:a.Attributes.Secure,title:"Secure",sortable:!0,align:i.Align.Center,weight:7,dataType:i.DataType.Boolean,editable:n},{id:a.Attributes.SameSite,title:"SameSite",sortable:!0,weight:7,editable:n},{id:a.Attributes.SameParty,title:"SameParty",sortable:!0,align:i.Align.Center,weight:7,dataType:i.DataType.Boolean,editable:n},{id:a.Attributes.Priority,title:"Priority",sortable:!0,sort:i.Order.Descending,weight:7,editable:n}];if(r.experiments.isEnabled("experimentalCookieFeatures")){const t=[{id:a.Attributes.SourceScheme,title:"SourceScheme",sortable:!0,align:i.Align.Center,weight:7,editable:n},{id:a.Attributes.SourcePort,title:"SourcePort",sortable:!0,align:i.Align.Center,weight:7,editable:n}];d.push(...t)}this._dataGrid=n?new i.DataGridImpl({displayName:h(u.editableCookies),columns:d,editCallback:this._onUpdateCookie.bind(this),deleteCallback:this._onDeleteCookie.bind(this),refreshCallback:s}):new i.DataGridImpl({displayName:h(u.cookies),columns:d,editCallback:void 0,deleteCallback:void 0,refreshCallback:void 0}),this._dataGrid.setStriped(!0),this._dataGrid.setName("cookiesTable"),this._dataGrid.addEventListener(i.Events.SortingChanged,this._rebuildTable,this),this._dataGrid.setRowContextMenuCallback(this._populateContextMenu.bind(this)),t&&this._dataGrid.renderInline(),o&&this._dataGrid.addEventListener(i.Events.SelectedNode,o,this),this._lastEditedColumnId=null,this._dataGrid.asWidget().show(this.element),this._data=[],this._cookieDomain="",this._cookieToBlockedReasons=null}setCookies(t,e){this.setCookieFolders([{cookies:t,folderName:null}],e)}setCookieFolders(t,e){this._data=t,this._cookieToBlockedReasons=e||null,this._rebuildTable()}setCookieDomain(t){this._cookieDomain=t}selectedCookie(){const t=this._dataGrid.selectedNode;return t?t.cookie:null}_getSelectionCookies(){const t=this._dataGrid.selectedNode,e=t&&t.traverseNextNode(!0),i=t&&t.traversePreviousNode(!0);return{current:t&&t.cookie,neighbor:e&&e.cookie||i&&i.cookie}}willHide(){this._lastEditedColumnId=null}_findSelectedCookie(t,e){if(!e)return null;const i=t.current,s=e.find((t=>this._isSameCookie(t,i)));if(s)return s;const o=t.neighbor,r=e.find((t=>this._isSameCookie(t,o)));return r||null}_isSameCookie(t,e){return null!=e&&e.name()===t.name()&&e.domain()===t.domain()&&e.path()===t.path()}_rebuildTable(){const t=this._getSelectionCookies(),e=this._lastEditedColumnId;this._lastEditedColumnId=null,this._dataGrid.rootNode().removeChildren();for(let s=0;s<this._data.length;++s){const o=this._data[s],r=this._findSelectedCookie(t,o.cookies);if(o.folderName){const t={};t[a.Attributes.Name]=o.folderName,t[a.Attributes.Value]="",t[a.Attributes.Size]=this._totalSize(o.cookies),t[a.Attributes.Domain]="",t[a.Attributes.Path]="",t[a.Attributes.Expires]="",t[a.Attributes.HttpOnly]="",t[a.Attributes.Secure]="",t[a.Attributes.SameSite]="",t[a.Attributes.SameParty]="",t[a.Attributes.SourcePort]="",t[a.Attributes.SourceScheme]="",t[a.Attributes.Priority]="";const s=new i.DataGridNode(t);s.selectable=!0,this._dataGrid.rootNode().appendChild(s),s.element().classList.add("row-group"),this._populateNode(s,o.cookies,r,e),s.expand()}else this._populateNode(this._dataGrid.rootNode(),o.cookies,r,e)}t.current&&e&&!this._dataGrid.selectedNode&&this._addInactiveNode(this._dataGrid.rootNode(),t.current,e),this._saveCallback&&this._dataGrid.addCreationNode(!1)}_populateNode(t,e,i,s){if(t.removeChildren(),e){this._sortCookies(e);for(let o=0;o<e.length;++o){const r=e[o],a=this._createGridNode(r);t.appendChild(a),this._isSameCookie(r,i)&&(a.select(),null!==s&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(a,s))}}}_addInactiveNode(t,e,i){const s=this._createGridNode(e);t.appendChild(s),s.select(),s.setInactive(!0),null!==i&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(s,i)}_totalSize(t){let e=0;for(let i=0;t&&i<t.length;++i)e+=t[i].size();return e}_sortCookies(t){const e=this._dataGrid.isSortOrderAscending()?1:-1;function i(t,e){switch(e){case a.Attributes.Name:return String(t.name());case a.Attributes.Value:return String(t.value());case a.Attributes.Domain:return String(t.domain());case a.Attributes.Path:return String(t.path());case a.Attributes.HttpOnly:return String(t.httpOnly());case a.Attributes.Secure:return String(t.secure());case a.Attributes.SameSite:return String(t.sameSite());case a.Attributes.SameParty:return String(t.sameParty());case a.Attributes.SourceScheme:return String(t.sourceScheme());default:return String(t.name())}}function s(t,i,s){return e*(t(i)-t(s))}let r;const l=this._dataGrid.sortColumnId()||a.Attributes.Name;r=l===a.Attributes.Expires?function(t,i){return t.session()!==i.session()?e*(t.session()?1:-1):t.session()?0:t.maxAge()&&i.maxAge()?e*(t.maxAge()-i.maxAge()):t.expires()&&i.expires()?e*(t.expires()-i.expires()):e*(t.expires()?1:-1)}:l===a.Attributes.Size?s.bind(null,(t=>t.size())):l===a.Attributes.SourcePort?s.bind(null,(t=>t.sourcePort())):l===a.Attributes.Priority?function(t,i){const s=[Protocol.Network.CookiePriority.Low,Protocol.Network.CookiePriority.Medium,Protocol.Network.CookiePriority.High],o=s.indexOf(t.priority()),r=s.indexOf(i.priority());return e*(o-r)}:function(t,s,r){return e*o.compare(i(s,t),i(r,t))}.bind(null,l),t.sort(r)}_createGridNode(t){const e={};e[a.Attributes.Name]=t.name(),e[a.Attributes.Value]=t.value(),t.type()===a.Type.Request?(e[a.Attributes.Domain]=t.domain()?t.domain():h(u.na),e[a.Attributes.Path]=t.path()?t.path():h(u.na)):(e[a.Attributes.Domain]=t.domain()||"",e[a.Attributes.Path]=t.path()||""),t.maxAge()?e[a.Attributes.Expires]=Number.secondsToString(Math.floor(t.maxAge())):t.expires()?t.expires()<0?e[a.Attributes.Expires]=b():e[a.Attributes.Expires]=new Date(t.expires()).toISOString():e[a.Attributes.Expires]=t.type()===a.Type.Request?h(u.na):b(),e[a.Attributes.Size]=t.size(),e[a.Attributes.HttpOnly]=t.httpOnly(),e[a.Attributes.Secure]=t.secure(),e[a.Attributes.SameSite]=t.sameSite()||"",e[a.Attributes.SameParty]=t.sameParty(),e[a.Attributes.SourcePort]=t.sourcePort(),e[a.Attributes.SourceScheme]=t.sourceScheme(),e[a.Attributes.Priority]=t.priority()||"";const i=this._cookieToBlockedReasons?this._cookieToBlockedReasons.get(t):null,s=new A(e,t,i||null);return s.selectable=!0,s}_onDeleteCookie(t){t.cookie&&this._deleteCallback&&this._deleteCallback(t.cookie,(()=>this._refresh()))}_onUpdateCookie(t,e,i,s){this._lastEditedColumnId=e,this._setDefaults(t),this._isValidCookieData(t.data)?this._saveNode(t):t.setDirty(!0)}_setDefaults(t){null===t.data[a.Attributes.Name]&&(t.data[a.Attributes.Name]=""),null===t.data[a.Attributes.Value]&&(t.data[a.Attributes.Value]=""),null===t.data[a.Attributes.Domain]&&(t.data[a.Attributes.Domain]=this._cookieDomain),null===t.data[a.Attributes.Path]&&(t.data[a.Attributes.Path]="/"),null===t.data[a.Attributes.Expires]&&(t.data[a.Attributes.Expires]=b())}_saveNode(t){const e=t.cookie,i=this._createCookieFromData(t.data);t.cookie=i,this._saveCallback&&this._saveCallback(i,e).then((e=>{e?this._refresh():t.setDirty(!0)}))}_createCookieFromData(t){const e=new a.Cookie(t[a.Attributes.Name],t[a.Attributes.Value],null,t[a.Attributes.Priority]);return e.addAttribute(a.Attributes.Domain,t[a.Attributes.Domain]),e.addAttribute(a.Attributes.Path,t[a.Attributes.Path]),t.expires&&t.expires!==b()&&e.addAttribute(a.Attributes.Expires,new Date(t[a.Attributes.Expires]).toUTCString()),t[a.Attributes.HttpOnly]&&e.addAttribute(a.Attributes.HttpOnly),t[a.Attributes.Secure]&&e.addAttribute(a.Attributes.Secure),t[a.Attributes.SameSite]&&e.addAttribute(a.Attributes.SameSite,t[a.Attributes.SameSite]),t[a.Attributes.SameParty]&&e.addAttribute(a.Attributes.SameParty),a.Attributes.SourceScheme in t&&e.addAttribute(a.Attributes.SourceScheme,t[a.Attributes.SourceScheme]),a.Attributes.SourcePort in t&&e.addAttribute(a.Attributes.SourcePort,Number.parseInt(t[a.Attributes.SourcePort],10)||void 0),e.setSize(t[a.Attributes.Name].length+t[a.Attributes.Value].length),e}_isValidCookieData(t){return(Boolean(t.name)||Boolean(t.value))&&this._isValidDomain(t.domain)&&this._isValidPath(t.path)&&this._isValidDate(t.expires)}_isValidDomain(t){if(!t)return!0;const i=e.ParsedURL.fromString("http://"+t);return null!==i&&i.domain()===t}_isValidPath(t){const i=e.ParsedURL.fromString("http://example.com"+t);return null!==i&&i.path===t}_isValidDate(t){return""===t||t===b()||!isNaN(Date.parse(t))}_refresh(){this._refreshCallback&&this._refreshCallback()}_populateContextMenu(e,i){const s=i.cookie;if(!s)return;const o=s;e.revealSection().appendItem(h(u.showRequestsWithThisCookie),(()=>{const t=new CustomEvent("networkrevealandfilter",{bubbles:!0,composed:!0,detail:[{filterType:"cookie-domain",filterValue:o.domain()},{filterType:"cookie-name",filterValue:o.name()}]});this.element.dispatchEvent(t)})),t.hasIssues(o)&&e.revealSection().appendItem(h(u.showIssueAssociatedWithThis),(()=>{t.reveal(o)}))}}class A extends i.DataGridNode{constructor(t,e,i){super(t),this.cookie=e,this._blockedReasons=i}createCells(t){super.createCells(t),this._blockedReasons&&this._blockedReasons.length&&t.classList.add("flagged-cookie-attribute-row")}createCell(t){const e=super.createCell(t);t===a.Attributes.SourcePort?n.Tooltip.install(e,h(u.sourcePortTooltip)):t===a.Attributes.SourceScheme?n.Tooltip.install(e,h(u.sourceSchemeTooltip)):n.Tooltip.install(e,e.textContent||"");let i="";if(this._blockedReasons)for(const e of this._blockedReasons){const s=e.attribute===t,o=!e.attribute&&t===a.Attributes.Name;(s||o)&&(i&&(i+="\n"),i+=e.uiString)}if(i){const t=d.Icon.create("smallicon-info","cookie-warning-icon");n.Tooltip.install(t,i),e.insertBefore(t,e.firstChild),e.classList.add("flagged-cookie-attribute-cell")}return e}}var p=Object.freeze({__proto__:null,UIStrings:u,CookiesTable:m,DataGridNode:A});export{p as CookiesTable};
