/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.Msg;
import ghidra.util.classfinder.ClassFinder;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClassJar {
    private static Pattern ANY_MODULE_LIB_JAR_FILE_PATTERN = Pattern.compile(".*/(.*)/(?:lib|build/libs)/(.+).jar");
    private String path;
    private Set<String> classNameList = new HashSet<String>();
    private Set<Class<?>> classes = new HashSet();

    ClassJar(String path, TaskMonitor monitor) throws CancelledException {
        this.path = path;
        this.scan(monitor);
    }

    void getClasses(Set<Class<?>> set, TaskMonitor monitor) {
        set.addAll(this.classes);
    }

    private void scan(TaskMonitor monitor) throws CancelledException {
        File file = new File(this.path);
        try (JarFile jarFile = new JarFile(file);){
            String pathName = jarFile.getName();
            int separatorIndex = pathName.lastIndexOf(File.separator);
            String jarFilename = pathName.substring(separatorIndex + 1);
            monitor.setMessage("Scanning jar: " + jarFilename);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                monitor.checkCanceled();
                this.processClassFiles(entries.nextElement());
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error reading jarFile: " + this.path), (Throwable)e);
        }
    }

    static boolean ignoreJar(String pathName) {
        if (pathName.contains("ExternalLibraries")) {
            return true;
        }
        return !ClassJar.isModuleDependencyJar(pathName);
    }

    static boolean isModuleDependencyJar(String pathName) {
        if (ClassSearcher.SEARCH_ALL_JARS) {
            return true;
        }
        String forwardSlashed = pathName.replaceAll("\\\\", "/");
        Matcher matcher = ANY_MODULE_LIB_JAR_FILE_PATTERN.matcher(forwardSlashed);
        if (!matcher.matches()) {
            return false;
        }
        String moduleName = matcher.group(1);
        String jarName = matcher.group(2);
        return jarName.startsWith(moduleName);
    }

    private void processClassFiles(JarEntry entry) {
        String name = entry.getName();
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(0, name.indexOf(".class"));
        Class<?> c = ClassFinder.loadExtensionPoint(this.path, name = name.replace('/', '.'));
        if (c != null) {
            this.classNameList.add(name);
            this.classes.add(c);
        }
    }

    public String toString() {
        return this.path;
    }
}

