/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.worker;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QProgressListener;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.task.BusyListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractWorker<T extends Job> {
    private ConcurrentQ<T, Object> concurrentQ;
    private volatile BusyListener busyListener;
    private volatile boolean isDisposed;
    private AtomicBoolean isBusy = new AtomicBoolean(false);
    private QProgressListener<T> qProgressListener;

    protected AbstractWorker(BlockingQueue<T> queue, boolean isPersistentThread, String name, boolean shareThreadPool, TaskMonitor monitor) {
        GThreadPool threadPool;
        GThreadPool gThreadPool = threadPool = shareThreadPool ? GThreadPool.getSharedThreadPool(name) : GThreadPool.getPrivateThreadPool(name);
        if (isPersistentThread) {
            threadPool.setMinThreadCount(1);
        }
        JobCallback callback = new JobCallback();
        this.concurrentQ = new ConcurrentQBuilder().setThreadPool(threadPool).setQueue(queue).setCancelClearsAllJobs(false).setJobsReportProgress(true).setMaxInProgress(1).build(callback);
        this.qProgressListener = new ProgressListener();
        this.concurrentQ.addProgressListener(this.qProgressListener);
        this.concurrentQ.setMonitor(monitor, false);
    }

    public void setTaskMonitor(TaskMonitor monitor) {
        this.concurrentQ.setMonitor(monitor, false);
    }

    private static <K> void reportException(Throwable t, K job, boolean isCancelled) {
        if (AbstractWorker.canSquashException(t, isCancelled)) {
            return;
        }
        String jobName = job.getClass().getSimpleName();
        Msg.error(AbstractWorker.class, (Object)("Unexpected error processing job: " + jobName), (Throwable)t);
    }

    private static <K> boolean canSquashException(Throwable t, boolean isCancelled) {
        if (!isCancelled) {
            return false;
        }
        if (t instanceof CancelledException) {
            return true;
        }
        if (t instanceof ClosedException) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            return AbstractWorker.canSquashException(cause, isCancelled);
        }
        return false;
    }

    public void schedule(T job) {
        if (this.isDisposed) {
            Msg.trace((Object)this, (Object)("A job was scheduled after this worker was disposed - " + job));
            return;
        }
        this.setBusy(true);
        this.concurrentQ.add(job);
    }

    public void clearAllJobs() {
        this.clearAllJobs(false);
    }

    public void clearAllJobsWithInterrupt_IKnowTheRisks() {
        this.clearAllJobs(true);
    }

    private void clearAllJobs(boolean interruptRuningJob) {
        List<T> pendingJobs = this.concurrentQ.cancelAllTasks(interruptRuningJob);
        for (Job job : pendingJobs) {
            job.cancel();
        }
    }

    public void clearPendingJobs() {
        this.concurrentQ.removeUnscheduledJobs();
    }

    public void dispose() {
        this.concurrentQ.setMonitor(null, false);
        this.concurrentQ.cancelAllTasks(true);
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private void setBusy(boolean b) {
        boolean changed = this.isBusy.compareAndSet(!b, b);
        if (this.busyListener != null && changed) {
            this.busyListener.setBusy(this.isBusy.get());
        }
    }

    public void setBusyListener(BusyListener listener) {
        this.busyListener = listener;
    }

    public boolean isBusy() {
        return this.isBusy.get();
    }

    public void waitUntilNoJobsScheduled(int maxWait) {
        try {
            this.concurrentQ.waitUntilDone(maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class JobCallback<K extends Job>
    implements QCallback<K, Object> {
        private JobCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object process(K job, TaskMonitor monitor) {
            ((Job)job).setTaskMonitor(monitor);
            if (((Job)job).isCancelled()) {
                monitor.cancel();
                return null;
            }
            try {
                ((Job)job).run(monitor);
            }
            catch (CancelledException cancelledException) {
            }
            catch (Throwable t) {
                AbstractWorker.reportException(t, job, monitor.isCancelled());
            }
            finally {
                ((Job)job).setTaskMonitor(null);
                if (monitor.isCancelled()) {
                    ((Job)job).cancel();
                } else {
                    ((Job)job).setCompleted();
                }
            }
            return null;
        }
    }

    class ProgressListener
    implements QProgressListener<T> {
        ProgressListener() {
        }

        @Override
        public void taskStarted(long id, T Item) {
            AbstractWorker.this.setBusy(true);
        }

        @Override
        public void taskEnded(long id, T Item, long totalCount, long completedCount) {
            if (AbstractWorker.this.concurrentQ.isEmpty()) {
                AbstractWorker.this.setBusy(false);
            }
        }

        @Override
        public void progressChanged(long id, T Item, long currentProgress) {
        }

        @Override
        public void progressModeChanged(long id, T item, boolean indeterminate) {
        }

        @Override
        public void progressMessageChanged(long id, T item, String message) {
        }

        @Override
        public void maxProgressChanged(long id, T item, long maxProgress) {
        }
    }
}

