/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import ghidra.util.classfinder.ExtensionPoint;
import java.util.List;
import utilities.util.reflection.ReflectionUtilities;

public abstract class ColumnTypeMapper<T, M>
implements ExtensionPoint {
    private Class<T> sourceType;
    private Class<M> destinationType;

    public ColumnTypeMapper() {
        this.sourceType = this.findSourceType();
        this.destinationType = this.findDestinationType();
    }

    protected ColumnTypeMapper(Class<T> sourceType, Class<M> destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    public abstract M convert(T var1);

    public final Class<T> getSourceType() {
        return this.sourceType;
    }

    public final Class<M> getDestinationType() {
        return this.destinationType;
    }

    private Class<T> findSourceType() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(ColumnTypeMapper.class, implementationClass);
        return (Class)typeArguments.get(0);
    }

    private Class<M> findDestinationType() {
        Class<?> implementationClass = this.getClass();
        List typeArguments = ReflectionUtilities.getTypeArguments(ColumnTypeMapper.class, implementationClass);
        return (Class)typeArguments.get(1);
    }
}

