/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.data.AbstractCreateStructureCmd;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureFactory;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;

public class CreateStructureInStructureCmd
extends AbstractCreateStructureCmd {
    private int[] fromPath;
    private int[] toPath;
    private Structure structure;

    public CreateStructureInStructureCmd(Address address, int[] fromPath, int[] toPath) {
        this("struct", address, fromPath, toPath);
    }

    public CreateStructureInStructureCmd(String name, Address addr, int[] fromPath, int[] toPath) {
        super(name, addr);
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    public CreateStructureInStructureCmd(Structure newStructure, Address address, int[] fromPath, int[] toPath) {
        this(address, fromPath, toPath);
        this.structure = newStructure;
    }

    @Override
    Structure createStructure(Address address, Program program) {
        if (this.structure == null) {
            this.structure = StructureFactory.createStructureDataTypeInStrucuture((Program)program, (Address)address, (int[])this.fromPath, (int[])this.toPath, (String)this.getStructureName(), (boolean)true);
        }
        return this.structure;
    }

    @Override
    DataType initializeStructureData(Program program, Structure localStructure) {
        Data data = program.getListing().getDataContaining(this.getStructureAddress());
        Data comp1 = data.getComponent(this.fromPath);
        Data comp2 = data.getComponent(this.toPath);
        int dataLength = comp2.getParentOffset() + comp2.getLength() - comp1.getParentOffset();
        DataType parentDataType = comp1.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            throw new IllegalArgumentException("Data not in a structure");
        }
        Structure originalStructure = (Structure)parentDataType;
        this.clearStruct(originalStructure, comp1.getParentOffset(), dataLength);
        originalStructure.replace(comp1.getComponentIndex(), (DataType)localStructure, localStructure.getLength());
        comp1 = data.getComponent(this.fromPath);
        return comp1.getDataType();
    }

    private void clearStruct(Structure struct, int offset, int length) {
        DataTypeComponent[] comps = struct.getDefinedComponents();
        int endOffset = offset + length;
        for (int i = comps.length - 1; i >= 0; --i) {
            if (comps[i].getOffset() < offset || comps[i].getOffset() >= endOffset) continue;
            struct.clearComponent(comps[i].getOrdinal());
        }
    }
}

