/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.pcode.floatformat.UnsupportedFloatFormatException;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import java.math.BigDecimal;

public class ConvertToFloatAction
extends AbstractConvertAction {
    public ConvertToFloatAction(EquatePlugin plugin) {
        super(plugin, "Convert To Float", false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        String valueString = this.convertToString(program, scalar, isData);
        if (valueString == null) {
            return null;
        }
        return this.getStandardLengthString("Float:") + valueString;
    }

    private static BigDecimal value(Program program, Scalar s) {
        DataOrganization dataOrganization = program.getDataTypeManager().getDataOrganization();
        try {
            FloatFormat format = FloatFormatFactory.getFloatFormat((int)dataOrganization.getFloatSize());
            return format.getHostFloat(s.getBigInteger());
        }
        catch (UnsupportedFloatFormatException e) {
            return null;
        }
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        if (isData) {
            return null;
        }
        BigDecimal value = ConvertToFloatAction.value(program, scalar);
        return value != null ? value.toString() : null;
    }

    @Override
    protected int getFormatChoice() {
        return -1;
    }
}

