/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.StringTableModel;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.util.string.FoundString;
import java.util.List;

public abstract class StringEvent {
    protected DataType stringDataType;
    protected Address address;
    protected int length;

    protected StringEvent(DataType stringDataType, Address address, int length) {
        this.stringDataType = stringDataType;
        this.address = address;
        this.length = length;
    }

    public abstract void process(StringTableModel var1, StringTableOptions var2);

    protected FoundString findRowSlowWay(StringTableModel model) {
        List modelData = model.getModelData();
        for (int row = 0; row < modelData.size(); ++row) {
            FoundString string = (FoundString)modelData.get(row);
            if (!this.overlaps(string)) continue;
            return string;
        }
        return null;
    }

    public Address getMaxAddress(Address addr1, Address addr2) {
        if (addr1.compareTo((Object)addr2) > 0) {
            return addr1;
        }
        return addr2;
    }

    public Address getMinAddress(Address addr1, Address addr2) {
        if (addr1.compareTo((Object)addr2) < 0) {
            return addr1;
        }
        return addr2;
    }

    protected boolean overlaps(FoundString string) {
        Address otherAddress = string.getAddress();
        int result = this.address.compareTo((Object)otherAddress);
        if (result == 0) {
            return true;
        }
        if (result < 0) {
            return this.subtract(otherAddress, this.address) < this.length;
        }
        return this.subtract(this.address, otherAddress) < string.getLength();
    }

    private int subtract(Address bigAddress, Address smallAddress) {
        if (bigAddress.getAddressSpace() != smallAddress.getAddressSpace()) {
            return Integer.MAX_VALUE;
        }
        long diff = bigAddress.subtract(smallAddress);
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }
}

