/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.RelocationTypeARM;
import ghidra.app.util.bin.format.macho.RelocationTypeARM64;
import ghidra.app.util.bin.format.macho.RelocationTypeGeneric;
import ghidra.app.util.bin.format.macho.RelocationTypePPC;
import ghidra.app.util.bin.format.macho.RelocationTypeX86_32;
import ghidra.app.util.bin.format.macho.RelocationTypeX86_64;
import ghidra.app.util.bin.format.macho.ScatteredRelocationInfo;
import java.io.IOException;

public final class RelocationFactory {
    public static final int SECTION = 2730;
    public static final int EXTERNAL = 3003;
    public static final int LOCAL = 3276;

    public static final RelocationInfo readRelocation(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        long relocIndex = reader.getPointerIndex();
        RelocationInfo info = RelocationInfo.createRelocationInfo(reader);
        if ((info.getAddress() & Integer.MIN_VALUE) == 0) {
            return info;
        }
        reader.setPointerIndex(relocIndex);
        return ScatteredRelocationInfo.createScatteredRelocationInfo(reader);
    }

    public static final String getRelocationDescription(MachHeader header, RelocationInfo relocation) {
        switch (header.getCpuType()) {
            case 18: 
            case 0x1000012: {
                RelocationTypePPC[] values;
                for (RelocationTypePPC value : values = RelocationTypePPC.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
                break;
            }
            case 7: {
                RelocationTypeX86_32[] values;
                for (RelocationTypeX86_32 value : values = RelocationTypeX86_32.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
                break;
            }
            case 0x1000007: {
                RelocationTypeX86_64[] values;
                for (RelocationTypeX86_64 value : values = RelocationTypeX86_64.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
                break;
            }
            case 12: {
                RelocationTypeARM[] values;
                for (RelocationTypeARM value : values = RelocationTypeARM.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
                break;
            }
            case 0x100000C: {
                RelocationTypeARM64[] values;
                for (RelocationTypeARM64 value : values = RelocationTypeARM64.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
                break;
            }
            default: {
                RelocationTypeGeneric[] values;
                for (RelocationTypeGeneric value : values = RelocationTypeGeneric.values()) {
                    if (value.ordinal() != relocation.getType()) continue;
                    return value.name();
                }
            }
        }
        return "Unknown Relocation Type: 0x" + Integer.toHexString(relocation.getType());
    }
}

