/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_TypeEncodings;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectiveC1_State {
    public final Set<Long> beenApplied = new HashSet<Long>();
    public final Map<Address, ObjectiveC_Method> methodMap = new HashMap<Address, ObjectiveC_Method>();
    public final Set<Address> thumbCodeLocations = new HashSet<Address>();
    public final Program program;
    public final boolean is32bit;
    public final boolean is64bit;
    public final boolean isARM;
    public final boolean isPowerPC;
    public final boolean isX86;
    public final int pointerSize;
    public final TaskMonitor monitor;
    public final ObjectiveC1_TypeEncodings encodings;

    public ObjectiveC1_State(Program program, TaskMonitor monitor, CategoryPath categoryPath) {
        this.program = program;
        this.pointerSize = program.getAddressFactory().getDefaultAddressSpace().getPointerSize();
        this.is32bit = this.pointerSize * 8 == 32;
        this.is64bit = this.pointerSize * 8 == 64;
        this.monitor = monitor;
        this.encodings = new ObjectiveC1_TypeEncodings(this.pointerSize, categoryPath);
        Language language = program.getLanguage();
        this.isARM = language.getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
        this.isPowerPC = language.getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"PowerPC"));
        this.isX86 = language.getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"));
    }

    public void dispose() {
        this.beenApplied.clear();
        this.methodMap.clear();
        this.thumbCodeLocations.clear();
    }

    public List<String> getObjectiveCSectionNames() {
        return ObjectiveC1_Constants.getObjectiveCSectionNames();
    }
}

