/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableParam
extends CliAbstractTable {
    public CliTableParam(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliParamRow row = new CliParamRow(reader.readNextShort(), reader.readNextShort(), this.readStringIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ParamRow", 0);
        rowDt.add((DataType)CliFlags.CliEnumParamAttributes.dataType, "Flags", "bitmask of type ParamAttributes");
        rowDt.add(WORD, "Sequence", "constant");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        return rowDt;
    }

    public class CliParamRow
    extends CliAbstractTableRow {
        public short flags;
        public short sequence;
        public int nameIndex;

        public CliParamRow(short flags, short sequence, int nameIndex) {
            this.flags = flags;
            this.sequence = sequence;
            this.nameIndex = nameIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("%s Flags %s Sequence %x", CliTableParam.this.metadataStream.getStringsStream().getString(this.nameIndex), CliFlags.CliEnumParamAttributes.dataType.getName(this.flags & 0xFFFF), this.sequence);
        }
    }
}

