/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import util.demangler.GenericDemangledAddressTable;
import util.demangler.GenericDemangledObject;

public class DemangledAddressTable
extends DemangledObject {
    private int length;

    public DemangledAddressTable(String name, int length) {
        this.setName(name);
        this.length = length;
    }

    DemangledAddressTable(GenericDemangledAddressTable generic) {
        super((GenericDemangledObject)generic);
        this.length = generic.getLength();
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getSignature(boolean format) {
        StringBuffer buffer = new StringBuffer();
        if (this.specialPrefix != null) {
            buffer.append(this.specialPrefix);
            buffer.append(' ');
        }
        String namespaceStr = this.namespace.toSignature();
        buffer.append(namespaceStr);
        if (!namespaceStr.endsWith("::")) {
            buffer.append("::");
        }
        buffer.append(this.getDemangledName());
        return buffer.toString();
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        if (this.isAlreadyDemangled(program, address)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        Symbol s = this.applyDemangledName(address, true, false, program);
        if (s == null) {
            return false;
        }
        if (MemoryBlock.isExternalBlockAddress((Address)address, (Program)program)) {
            program.getListing().setComment(address, 0, "WARNING: Unable to apply demangled Address Table");
            return true;
        }
        if (this.length == -1) {
            Data d = program.getListing().getDefinedDataAt(address);
            if (d != null && Undefined.isUndefinedArray((DataType)d.getDataType())) {
                this.length = d.getLength();
            } else {
                this.length = DemangledAddressTable.guessTableLength(program, address);
                if (this.length <= 0) {
                    return false;
                }
            }
        }
        if (this.isUndefinedInRange(program, address, address.add((long)(this.length - 1)))) {
            long count = this.length / program.getDefaultPointerSize();
            this.createPointers(program, address, (int)count);
        }
        return true;
    }

    private static int guessTableLength(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        if (block == null || !block.isInitialized()) {
            return -1;
        }
        Address endAddr = block.getEnd();
        Symbol nextsym = DemangledAddressTable.findNextImportedSymbol(program, address);
        if (nextsym != null && nextsym.getAddress().compareTo((Object)endAddr) < 0) {
            endAddr = nextsym.getAddress();
        }
        return (int)endAddr.subtract(address);
    }

    private static Symbol findNextImportedSymbol(Program program, Address address) {
        int count = 0;
        SymbolIterator symiter = program.getSymbolTable().getSymbolIterator(address.add(1L), true);
        while (symiter.hasNext()) {
            Symbol nextsym = symiter.next();
            if (nextsym.getSource() == SourceType.IMPORTED) {
                return nextsym;
            }
            if (++count <= 50) continue;
            break;
        }
        return null;
    }

    private void createPointers(Program program, Address start, int count) {
        PointerDataType pointerDt = new PointerDataType(program.getDataTypeManager());
        Listing listing = program.getListing();
        Memory mem = program.getMemory();
        DumbMemBufferImpl buf = new DumbMemBufferImpl(mem, start);
        for (int i = 0; i < count; ++i) {
            Data d;
            Address addr = start.add((long)(pointerDt.getLength() * i));
            buf.setPosition(addr);
            Address refAddr = (Address)pointerDt.getValue((MemBuffer)buf, null, -1);
            if (refAddr == null) {
                return;
            }
            if (refAddr.getOffset() == 0L || (d = listing.getDefinedDataAt(addr)) != null && d.isPointer()) continue;
            if (!mem.contains(refAddr)) {
                return;
            }
            CreateDataCmd cmd = new CreateDataCmd(addr, false, false, (DataType)pointerDt);
            if (cmd.applyTo((DomainObject)program)) continue;
            Msg.debug((Object)this, (Object)("Unable to demangled address table pointer at " + addr + ": " + cmd.getStatusMsg()));
            return;
        }
    }

    private boolean isUndefinedInRange(Program program, Address start, Address end) {
        Data data;
        Instruction instr;
        InstructionIterator instructions = program.getListing().getInstructions(start, true);
        if (instructions.hasNext() && (instr = instructions.next()).getMinAddress().compareTo((Object)end) <= 0) {
            return false;
        }
        DataIterator definedData = program.getListing().getDefinedData(start, true);
        while (definedData.hasNext() && (data = definedData.next()).getMinAddress().compareTo((Object)end) <= 0) {
            if (Undefined.isUndefined((DataType)data.getDataType()) || data.getDataType() instanceof Pointer) continue;
            return false;
        }
        return true;
    }
}

