/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisRecipe;
import org.jdom.Element;

public class AnalysisPhase
implements Comparable<AnalysisPhase> {
    static final String XML_ELEMENT_NAME = "ANALYSIS_PHASE";
    private AnalysisRecipe recipe;
    private int index;
    private boolean isCheckPoint;

    public AnalysisPhase(AnalysisRecipe recipe, int index, boolean isCheckPoint) {
        this.recipe = recipe;
        this.index = index;
        this.isCheckPoint = isCheckPoint;
    }

    AnalysisPhase(Element element) {
        this.index = Integer.parseInt(element.getAttributeValue("INDEX"));
        this.isCheckPoint = Boolean.parseBoolean(element.getAttributeValue("CHECKPOINT"));
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return Integer.toString(this.index + 1);
    }

    public Element toXML() {
        Element element = new Element(XML_ELEMENT_NAME);
        element.setAttribute("INDEX", Integer.toString(this.index));
        element.setAttribute("CHECKPOINT", Boolean.toString(this.isCheckPoint));
        return element;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int i) {
        this.index = i;
    }

    public boolean isEnabled(Analyzer analyzer) {
        return this.recipe.isAnalyzerEnabled(analyzer);
    }

    public AnalysisPhase getExecutionPhase(Analyzer analyzer) {
        return this.recipe.getExecutionPhase(analyzer, this);
    }

    @Override
    public int compareTo(AnalysisPhase o) {
        return this.index - o.index;
    }

    public boolean isCheckPoint() {
        return this.isCheckPoint;
    }

    public void setIsCheckPoint(boolean b) {
        if (this.recipe.getLastPhase() == this) {
            return;
        }
        this.isCheckPoint = b;
    }
}

