/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedField
implements StructConverter {
    private long _fileOffset;
    private int fieldIndexDifference;
    private int fieldIndexDifferenceLength;
    private int accessFlags;
    private int accessFlagsLength;

    public EncodedField(BinaryReader reader) throws IOException {
        this._fileOffset = reader.getPointerIndex();
        this.fieldIndexDifference = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.fieldIndexDifferenceLength = Leb128.unsignedLeb128Size(this.fieldIndexDifference);
        reader.readNextByteArray(this.fieldIndexDifferenceLength);
        this.accessFlags = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.accessFlagsLength = Leb128.unsignedLeb128Size(this.accessFlags);
        reader.readNextByteArray(this.accessFlagsLength);
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getFieldIndexDifference() {
        return this.fieldIndexDifference;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "encoded_field_" + this.fieldIndexDifferenceLength + "_" + this.accessFlagsLength;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.fieldIndexDifferenceLength, BYTE.getLength()), "field_idx_diff", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.accessFlagsLength, BYTE.getLength()), "accessFlags", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_field"));
        return structure;
    }
}

