/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProviderFactory;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.user.UserAccessControlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlProviderFactoryImpl
implements AccessControlProviderFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)AccessControlProviderFactoryImpl.class);
    private String secWorkspaceName = null;
    private String defaultWorkspaceName = null;

    public void init(Session securitySession) throws RepositoryException {
        this.secWorkspaceName = securitySession.getWorkspace().getName();
        if (securitySession instanceof SessionImpl) {
            this.defaultWorkspaceName = ((RepositoryImpl)securitySession.getRepository()).getConfig().getDefaultWorkspaceName();
        }
    }

    public void close() throws RepositoryException {
    }

    public AccessControlProvider createProvider(Session systemSession, WorkspaceSecurityConfig config) throws RepositoryException {
        Map<Object, Object> props;
        AccessControlProvider prov;
        String workspaceName = systemSession.getWorkspace().getName();
        if (config != null && config.getAccessControlProviderConfig() != null) {
            BeanConfig bc = config.getAccessControlProviderConfig();
            prov = (AccessControlProvider)bc.newInstance();
            props = bc.getParameters();
        } else {
            log.debug("No ac-provider configuration for workspace " + workspaceName + " -> using defaults.");
            prov = workspaceName.equals(this.secWorkspaceName) && !workspaceName.equals(this.defaultWorkspaceName) ? new UserAccessControlProvider() : new ACLProvider();
            log.debug("Default provider for workspace " + workspaceName + " = " + prov.getClass().getName());
            props = Collections.EMPTY_MAP;
        }
        prov.init(systemSession, props);
        return prov;
    }
}

