/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.QPropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class QNodeTypeDefinitionImpl
implements QNodeTypeDefinition,
Serializable {
    private final Name name;
    private final Name[] supertypes;
    private final Name[] supportedMixins;
    private final boolean isMixin;
    private final boolean hasOrderableChildNodes;
    private final Name primaryItemName;
    private final QPropertyDefinition[] propertyDefs;
    private final QNodeDefinition[] childNodeDefs;
    private transient Collection dependencies;

    public QNodeTypeDefinitionImpl(QNodeTypeDefinition nt) {
        this(nt.getName(), nt.getSupertypes(), nt.isMixin(), nt.hasOrderableChildNodes(), nt.getPrimaryItemName(), nt.getPropertyDefs(), nt.getChildNodeDefs());
    }

    public QNodeTypeDefinitionImpl(Name name, Name[] supertypes, boolean isMixin, boolean hasOrderableChildNodes, Name primaryItemName, QPropertyDefinition[] declaredPropDefs, QNodeDefinition[] declaredNodeDefs) {
        this.name = name;
        this.supertypes = supertypes;
        this.supportedMixins = null;
        this.isMixin = isMixin;
        this.hasOrderableChildNodes = hasOrderableChildNodes;
        this.primaryItemName = primaryItemName;
        this.propertyDefs = QNodeTypeDefinitionImpl.getSerializablePropertyDefs(declaredPropDefs);
        this.childNodeDefs = QNodeTypeDefinitionImpl.getSerializableNodeDefs(declaredNodeDefs);
    }

    public QNodeTypeDefinitionImpl(Name name, Name[] supertypes, Name[] supportedMixins, boolean isMixin, boolean hasOrderableChildNodes, Name primaryItemName, QPropertyDefinition[] declaredPropDefs, QNodeDefinition[] declaredNodeDefs) {
        this.name = name;
        this.supertypes = supertypes;
        this.supportedMixins = supportedMixins;
        this.isMixin = isMixin;
        this.hasOrderableChildNodes = hasOrderableChildNodes;
        this.primaryItemName = primaryItemName;
        this.propertyDefs = QNodeTypeDefinitionImpl.getSerializablePropertyDefs(declaredPropDefs);
        this.childNodeDefs = QNodeTypeDefinitionImpl.getSerializableNodeDefs(declaredNodeDefs);
    }

    public Name getName() {
        return this.name;
    }

    public Name[] getSupertypes() {
        Name[] sTypes = new Name[this.supertypes.length];
        System.arraycopy(this.supertypes, 0, sTypes, 0, this.supertypes.length);
        return sTypes;
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public QPropertyDefinition[] getPropertyDefs() {
        QPropertyDefinition[] pDefs = new QPropertyDefinition[this.propertyDefs.length];
        System.arraycopy(this.propertyDefs, 0, pDefs, 0, this.propertyDefs.length);
        return pDefs;
    }

    public QNodeDefinition[] getChildNodeDefs() {
        QNodeDefinition[] cnDefs = new QNodeDefinition[this.childNodeDefs.length];
        System.arraycopy(this.childNodeDefs, 0, cnDefs, 0, this.childNodeDefs.length);
        return cnDefs;
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            int i;
            HashSet<Name> deps = new HashSet<Name>();
            for (i = 0; i < this.supertypes.length; ++i) {
                deps.add(this.supertypes[i]);
            }
            for (i = 0; i < this.childNodeDefs.length; ++i) {
                Name ntName = this.childNodeDefs[i].getDefaultPrimaryType();
                if (ntName != null && !this.name.equals(ntName)) {
                    deps.add(ntName);
                }
                Name[] ntNames = this.childNodeDefs[i].getRequiredPrimaryTypes();
                for (int j = 0; j < ntNames.length; ++j) {
                    if (ntNames[j] == null || this.name.equals(ntNames[j])) continue;
                    deps.add(ntNames[j]);
                }
            }
            for (i = 0; i < this.propertyDefs.length; ++i) {
                String[] ca;
                if (this.propertyDefs[i].getRequiredType() != 9 || (ca = this.propertyDefs[i].getValueConstraints()) == null) continue;
                for (int j = 0; j < ca.length; ++j) {
                    NameFactory factory = NameFactoryImpl.getInstance();
                    Name ntName = factory.create(ca[j]);
                    if (this.name.equals(ntName)) continue;
                    deps.add(ntName);
                }
            }
            this.dependencies = Collections.unmodifiableCollection(deps);
        }
        return this.dependencies;
    }

    public Name[] getSupportedMixinTypes() {
        if (this.supportedMixins == null) {
            return null;
        }
        Name[] mixins = new Name[this.supportedMixins.length];
        System.arraycopy(this.supportedMixins, 0, mixins, 0, this.supportedMixins.length);
        return mixins;
    }

    private static QPropertyDefinition[] getSerializablePropertyDefs(QPropertyDefinition[] propDefs) {
        QPropertyDefinition[] serDefs = new QPropertyDefinition[propDefs.length];
        for (int i = 0; i < propDefs.length; ++i) {
            serDefs[i] = propDefs[i] instanceof Serializable ? propDefs[i] : new QPropertyDefinitionImpl(propDefs[i]);
        }
        return serDefs;
    }

    private static QNodeDefinition[] getSerializableNodeDefs(QNodeDefinition[] nodeDefs) {
        QNodeDefinition[] serDefs = new QNodeDefinition[nodeDefs.length];
        for (int i = 0; i < nodeDefs.length; ++i) {
            serDefs[i] = nodeDefs[i] instanceof Serializable ? nodeDefs[i] : new QNodeDefinitionImpl(nodeDefs[i]);
        }
        return serDefs;
    }
}

